/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ConfigureTree;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.AuditableException;
import VASSAL.script.expression.ExpressionException;

public class BadDataReport {
    private String message;
    private String data;
    private Throwable cause;
    private boolean reportable = true;
    private AuditTrail auditTrail;
    private Auditable owner;

    public BadDataReport() {
    }

    public BadDataReport(String message, String data, Throwable cause) {
        this.message = message;
        this.data = data;
        this.setCause(cause);
    }

    public BadDataReport(String message, String data, ExpressionException cause) {
        this(null, null, message, data, cause);
    }

    public BadDataReport(String message, String data, Throwable cause, Auditable owner, AuditTrail auditTrail) {
        this(null, null, message, data, cause);
        this.owner = owner;
        this.auditTrail = auditTrail;
    }

    public BadDataReport(String message, String data) {
        this(message, data, null);
    }

    public BadDataReport(EditablePiece piece, String message, String data, Throwable cause) {
        this(BadDataReport.getPieceName(piece), piece.getBaseDescription(), message, data, cause);
        this.setReportable(piece.getMap() != null);
    }

    public BadDataReport(EditablePiece piece, String message, String data) {
        this(piece, message, data, null);
    }

    public BadDataReport(EditablePiece piece, String message) {
        this(piece, message, "");
    }

    public BadDataReport(String pieceName, String traitDesc, String message, String data, Throwable cause) {
        Object m = "";
        if (!(cause instanceof AuditableException)) {
            m = pieceName != null && pieceName.length() > 0 ? pieceName + " " : "";
            m = (String)m + (String)(traitDesc != null && traitDesc.length() > 0 ? "[" + traitDesc + "] " : "");
            m = (String)m + (((String)m).length() > 0 ? ". " : "");
        }
        this.message = m = (String)m + message + ". " + this.getAuditMessage();
        this.data = data;
        this.setCause(cause);
    }

    protected static String getPieceName(EditablePiece piece) {
        if (piece instanceof Decorator) {
            return ((Decorator)piece).getInner().getLocalizedName();
        }
        return piece.getLocalizedName();
    }

    public BadDataReport(AbstractConfigurable c, String message, String data, Throwable cause) {
        this.message = c.getConfigureName() + "[" + ConfigureTree.getConfigureName(c.getClass()) + "]: " + message + " " + this.getAuditMessage();
        this.data = data;
        this.setCause(cause);
    }

    public BadDataReport(AbstractConfigurable c, String messageKey, String data) {
        this(c, messageKey, data, null);
    }

    private String getAuditMessage() {
        return Resources.getString(AuditTrail.isEnabled() ? "BadDataReport.see_errorlog" : "BadDataReport.enable_pref");
    }

    public BadDataReport(PieceSlot slot, String message, String data) {
        this.message = slot.getName() + ": " + message;
        this.data = data;
        this.setCause(null);
    }

    public boolean isReportable() {
        return this.reportable;
    }

    public void setReportable(boolean reportable) {
        this.reportable = reportable;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.owner != null) {
            sb.append(this.getDescription(this.owner));
        }
        if (this.data != null) {
            sb.append(' ').append(Resources.getString("Audit.source", this.data));
        }
        sb.append(' ').append(Resources.getString("Audit.error", this.message));
        return sb.toString();
    }

    private String getDescription(Auditable owner) {
        return owner.getComponentName() + " " + owner.getComponentTypeName();
    }

    public Throwable getCause() {
        return this.cause;
    }

    private void setCause(Throwable cause) {
        this.cause = cause;
        if (cause instanceof AuditableException) {
            this.auditTrail = ((AuditableException)cause).getAuditTrail();
            this.owner = ((AuditableException)cause).getOwner();
        }
    }

    public String getData() {
        return this.data;
    }

    public AuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    public String getAuditReport() {
        return this.auditTrail == null ? "" : this.auditTrail.toString();
    }

    public String getFullData() {
        return this.auditTrail == null ? "" : "\n" + this.auditTrail.toString();
    }
}

