/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.configure.ComponentDescription;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public class LayerControl
extends AbstractToolbarItem
implements ComponentDescription {
    public static final String COMMAND = "command";
    public static final String SKIP = "skip";
    public static final String LAYERS = "layers";
    public static final String CMD_ROTATE_UP = "Rotate Layer Order Up";
    public static final String CMD_ROTATE_DN = "Rotate Layer Order Down";
    public static final String CMD_ENABLE = "Make Layer Active";
    public static final String CMD_DISABLE = "Make Layer Inactive";
    public static final String CMD_TOGGLE = "Switch Layer between Active and Inactive";
    public static final String CMD_RESET = "Reset All Layers";
    public static final String DESCRIPTION = "description";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String NAME = "name";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String TOOLTIP = "tooltip";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_TEXT = "text";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_ICON = "icon";
    @Deprecated(since="2020-10-21", forRemoval=true)
    public static final String BUTTON_HOTKEY = "hotkey";
    @Deprecated(since="2021-04-03", forRemoval=true)
    protected LaunchButton launch;
    protected static final String[] COMMANDS = new String[]{"Rotate Layer Order Up", "Rotate Layer Order Down", "Make Layer Active", "Make Layer Inactive", "Switch Layer between Active and Inactive", "Reset All Layers"};
    protected static final String[] COMMANDS_DISPLAY_NAMES = new String[]{"Editor.LayerControl.rotate_layer_order_up", "Editor.LayerControl.rotate_layer_order_down", "Editor.LayerControl.make_layer_active", "Editor.LayerControl.make_layer_inactive", "Editor.LayerControl.switch_layer_between_active_and_inactive", "Editor.LayerControl.reset_all_layers"};
    protected String command = "Reset All Layers";
    protected boolean skip = true;
    protected String[] layers = new String[0];
    protected LayeredPieceCollection pieceLayers;
    protected CompoundPieceCollection pieceCollection;
    protected String description;

    public LayerControl() {
        this.setShowDisabledOptions(false);
        this.setNameKey("");
        this.setLaunchButton(this.makeLaunchButton(Resources.getString("Editor.LayerControl.reset_layers"), Resources.getString("Editor.LayerControl.reset_layers"), "", e -> this.launch()));
        this.launch = this.getLaunchButton();
        this.setShowDisabledOptions(true);
    }

    public void launch() {
        if (this.command.equals(CMD_RESET)) {
            this.pieceCollection.reset();
        } else if (this.command.equals(CMD_ROTATE_UP)) {
            this.pieceCollection.rotate(true, this.skip);
        } else if (this.command.equals(CMD_ROTATE_DN)) {
            this.pieceCollection.rotate(false, this.skip);
        } else if (this.command.equals(CMD_ENABLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.setLayerEnabled(i, true);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.pieceCollection.setLayerEnabled(this.layers[i], true);
                }
            }
        } else if (this.command.equals(CMD_DISABLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.setLayerEnabled(i, false);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.pieceCollection.setLayerEnabled(this.layers[i], false);
                }
            }
        } else if (this.command.equals(CMD_TOGGLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.toggleLayerEnabled(i);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.pieceCollection.toggleLayerEnabled(this.layers[i]);
                }
            }
        } else {
            return;
        }
        this.getMap().repaint();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.LayerControl.action"), Resources.getString("Editor.LayerControl.skip_layer"), Resources.getString("Editor.LayerControl.affect_layer")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{String.class, CommandConfig.class, Boolean.class, String[].class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{DESCRIPTION, COMMAND, SKIP, LAYERS});
    }

    @Override
    public String getAttributeValueString(String key) {
        if (COMMAND.equals(key)) {
            return this.command;
        }
        if (SKIP.equals(key)) {
            return String.valueOf(this.skip);
        }
        if (LAYERS.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.layers);
        }
        if (DESCRIPTION.equals(key)) {
            return this.description;
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            if (super.getAttributeValueString(TOOLTIP) == null) {
                super.setAttribute(TOOLTIP, value);
            }
        } else if (COMMAND.equals(key)) {
            this.command = (String)value;
        } else if (SKIP.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.skip = (Boolean)value;
        } else if (LAYERS.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.layers = value;
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (SKIP.equals(name)) {
            return () -> this.command.equals(CMD_ROTATE_UP) || this.command.equals(CMD_ROTATE_DN);
        }
        if (LAYERS.equals(name)) {
            return () -> Stream.of(CMD_ENABLE, CMD_DISABLE, CMD_TOGGLE).anyMatch(s -> this.command.equals(s));
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void addTo(Buildable parent) {
        this.pieceLayers = (LayeredPieceCollection)parent;
        this.pieceLayers.getToolBar().add(this.getLaunchButton());
        this.pieceCollection = this.pieceLayers.getPieceCollection();
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (this.getMap() != null) {
            this.getMap().getToolBar().remove(this.getLaunchButton());
        }
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    public Map getMap() {
        return this.pieceLayers.getMap();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayers.html");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.LayerControl.component_type");
    }

    public static class CommandConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return COMMANDS;
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return COMMANDS_DISPLAY_NAMES;
        }
    }
}

