/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AbstractFolder;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.AbstractScenarioProperty;
import VASSAL.build.module.properties.BooleanScenarioProperty;
import VASSAL.build.module.properties.ListScenarioProperty;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.NumberScenarioProperty;
import VASSAL.build.module.properties.StringScenarioProperty;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ComponentConfigPanel;
import VASSAL.configure.Configurer;
import VASSAL.configure.NotNullConfigureName;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ScenarioPropertiesOptionTab
extends AbstractConfigurable
implements MutablePropertiesContainer,
CommandEncoder,
GameComponent {
    public static final char COMMAND_DELIMITER = '\t';
    public static final String COMMAND_PREFIX = "LOCKSPOTAB";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String REPORT = "report";
    public static final String ALIGN_LABELS_RIGHT = "alignLabelsRight";
    public static final String REPORT_PROP_NAME = "propertyName";
    public static final String REPORT_OLD_VALUE = "oldValue";
    public static final String REPORT_NEW_VALUE = "newValue";
    public static final String REPORT_PROMPT = "propertyPrompt";
    public static final String REPORT_TAB = "tabName";
    protected String description = "";
    protected MutablePropertiesContainer parentContainer;
    protected Buildable parent;
    protected FormattedString reportFormat = new FormattedString(Resources.getString("ScenarioOptions.default_report"));
    protected boolean alignLabelsRight = true;
    protected String lockedByuser = "";
    protected String lockedBypw = "";
    protected String lockedDt;
    protected boolean uiTabLock;
    protected String uiTabLockUser;
    protected String uiTabLockPw;
    protected String uiTabLockDt;
    protected JLabel lockLabel;
    protected JButton lockButton;
    protected JLabel unlockLabel;
    protected JButton unlockButton;
    protected ComponentConfigPanel uiPanel = new ComponentConfigPanel();
    protected Map<String, Entry> entries = new HashMap<String, Entry>();

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ScenarioPropertiesTab.component_type");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, DESCRIPTION, REPORT, ALIGN_LABELS_RIGHT};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
        } else if (DESCRIPTION.equals(key)) {
            this.description = (String)value;
        } else if (REPORT.equals(key)) {
            this.reportFormat.setFormat((String)value);
        } else if (ALIGN_LABELS_RIGHT.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.alignLabelsRight = (Boolean)value;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (DESCRIPTION.equals(key)) {
            return this.description;
        }
        if (REPORT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (ALIGN_LABELS_RIGHT.equals(key)) {
            return String.valueOf(this.alignLabelsRight);
        }
        return null;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.report_format"), Resources.getString("Editor.ScenarioProperties.align_labels_right")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, ChangeOptionConfig.class, Boolean.class};
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        this.parent = parent;
        this.parentContainer = (MutablePropertiesContainer)((Object)parent);
        this.validator = new NotNullConfigureName(this);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
    }

    public Buildable getParent() {
        return this.parent;
    }

    public FormattedString getReportFormat() {
        return this.reportFormat;
    }

    @Override
    public void removeFrom(Buildable parent) {
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{ListScenarioProperty.class, BooleanScenarioProperty.class, StringScenarioProperty.class, NumberScenarioProperty.class};
    }

    @Override
    public void addMutableProperty(String key, MutableProperty p) {
        this.parentContainer.addMutableProperty(key, p);
    }

    @Override
    public MutableProperty removeMutableProperty(String key) {
        return this.parentContainer.removeMutableProperty(key);
    }

    @Override
    public MutableProperty getMutableProperty(String propertyName) {
        return this.parentContainer.getMutableProperty(propertyName);
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return this.parentContainer.getMutablePropertiesContainerId();
    }

    @Override
    public Command decode(String command) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(command, '\t');
        String prefix = sd.nextToken("");
        if (!COMMAND_PREFIX.equals(prefix)) {
            return null;
        }
        String name = sd.nextToken("");
        if (!name.equals(this.getConfigureName())) {
            return null;
        }
        String by = sd.nextToken("");
        String pw = sd.nextToken("");
        String dt = sd.nextToken("");
        return new LockScenarioOptionsTab(this, by, pw, dt);
    }

    @Override
    public String encode(Command c) {
        if (c instanceof LockScenarioOptionsTab) {
            LockScenarioOptionsTab com = (LockScenarioOptionsTab)c;
            SequenceEncoder se = new SequenceEncoder(COMMAND_PREFIX, '\t');
            se.append(com.getTab().getConfigureName()).append(com.getLockedBy()).append(com.getLockedPw()).append(com.getLockedDt());
            return se.getValue();
        }
        return null;
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.resetTab();
        }
    }

    protected void resetTab() {
        this.lockedByuser = "";
        this.lockedBypw = "";
        this.lockedDt = "";
        this.uiTabLock = false;
        this.uiTabLockUser = "";
        this.uiTabLockDt = "";
    }

    @Override
    public Command getRestoreCommand() {
        return new LockScenarioOptionsTab(this, this.lockedByuser, this.lockedBypw, this.lockedDt);
    }

    public Component getUI() {
        this.uiTabLock = this.isLocked();
        this.uiTabLockUser = this.lockedByuser;
        this.uiTabLockDt = this.lockedDt;
        this.uiTabLockPw = this.lockedBypw;
        this.rebuildUI();
        return this.uiPanel;
    }

    protected void rebuildUI() {
        this.entries.clear();
        this.uiPanel.removeAll();
        for (AbstractScenarioProperty option : this.getAllDescendantComponentsOf(AbstractScenarioProperty.class)) {
            Entry entry = new Entry(option);
            this.entries.put(option.getConfigureName(), entry);
            this.uiPanel.add((Component)new JLabel(entry.getDescription()), this.alignLabelsRight ? "right" : "left");
            this.uiPanel.add(entry.getConfigurer().getControls());
        }
        this.uiPanel.add(this.getLockUI(), "span 2, alignx left, gapy 10");
        this.refreshLockUI();
    }

    public Component getLockUI() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEtchedBorder());
        p.setLayout((LayoutManager)new MigLayout("ins 5, hidemode 3", "[]10[]"));
        this.lockLabel = new JLabel(Resources.getString("ScenarioProperties.tabUnlocked"));
        p.add(this.lockLabel);
        this.lockButton = new JButton(Resources.getString("ScenarioProperties.lock"));
        this.lockButton.addActionListener(e -> this.lockUi(true));
        p.add(this.lockButton);
        this.unlockLabel = new JLabel(Resources.getString("ScenarioProperties.tabLocked", this.uiTabLockUser, this.uiTabLockDt));
        p.add(this.unlockLabel);
        this.unlockButton = new JButton(Resources.getString("ScenarioProperties.unlock"));
        this.unlockButton.addActionListener(e -> this.lockUi(false));
        p.add(this.unlockButton);
        this.refreshLockUI();
        return p;
    }

    protected void lockUi(boolean lock) {
        StringBuilder sb = new StringBuilder();
        sb.append(Resources.getString(lock ? "ScenarioProperties.lock_messaage" : "ScenarioProperties.unlock_messaage")).append("\n\n").append(Resources.getString("ScenarioProperties.are_you_sure")).append("\n\n");
        if (0 == JOptionPane.showConfirmDialog(this.uiPanel, sb.toString(), Resources.getString("ScenarioProperties.lock_title"), 0)) {
            this.uiTabLock = lock;
            this.uiTabLockUser = lock ? (String)GameModule.getGameModule().getPrefs().getValue("RealName") : "";
            this.uiTabLockPw = lock ? (String)GameModule.getGameModule().getPrefs().getValue("SecretName") : "";
            Instant now = Instant.now();
            DateTimeFormatter fmt = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM);
            String utc = fmt.withZone(ZoneOffset.UTC).format(now);
            this.uiTabLockDt = utc + " UTC";
        }
        this.refreshLockUI();
    }

    protected void refreshLockUI() {
        this.lockLabel.setVisible(!this.isUiLocked());
        this.lockButton.setVisible(!this.isUiLocked());
        this.lockButton.setEnabled(this.isLockingAllowed());
        this.unlockLabel.setText(Resources.getString("ScenarioProperties.tabLocked", this.uiTabLockUser, this.uiTabLockDt));
        this.unlockLabel.setVisible(this.isUiLocked());
        this.unlockButton.setVisible(this.isUiLocked());
        this.unlockButton.setEnabled(this.isLockingAllowed());
        for (Entry entry : this.entries.values()) {
            entry.setEnabled(!this.isUiLocked() && this.isLockingAllowed());
        }
        SwingUtils.repack(this.uiPanel);
    }

    protected void lockTab(boolean locking, String lockDt) {
        Command c;
        GameModule gm = GameModule.getGameModule();
        String user = (String)gm.getPrefs().getValue("RealName");
        String pw = (String)gm.getPrefs().getValue("SecretName");
        if (locking) {
            c = new LockScenarioOptionsTab(this, user, pw, lockDt);
            c = c.append(new Chatter.DisplayText(gm.getChatter(), "*" + this.deHtml(Resources.getString("ScenarioProperties.lockReport", this.getConfigureName(), user))));
        } else {
            c = new LockScenarioOptionsTab(this, "", "", "");
            c = c.append(new Chatter.DisplayText(gm.getChatter(), "*" + this.deHtml(Resources.getString("ScenarioProperties.unlockReport", this.getConfigureName(), user))));
        }
        c.execute();
        gm.sendAndLog(c);
    }

    private String deHtml(String message) {
        int pos = ((String)message).toUpperCase().indexOf("<HTML>");
        if (pos > 0) {
            message = ((String)message).substring(0, pos) + ((String)message).substring(pos + 6);
        }
        if ((pos = ((String)message).toUpperCase().indexOf("</HTML>")) > 0) {
            message = ((String)message).substring(0, pos) + ((String)message).substring(pos + 7);
        }
        return message;
    }

    protected boolean isLockingAllowed() {
        GameModule gm = GameModule.getGameModule();
        String pw = (String)gm.getPrefs().getValue("SecretName");
        if (this.isUiLocked()) {
            return this.getLockedBypw().equals(pw) || this.uiTabLockPw.equals(pw);
        }
        if (!gm.isRealName()) {
            return false;
        }
        if (!gm.isNonBlankPassword()) {
            return false;
        }
        PlayerRoster roster = gm.getPlayerRoster();
        if (roster == null) {
            return true;
        }
        String side = PlayerRoster.getMySide();
        if (side == null) {
            return true;
        }
        return !"<observer>".equals(side) || roster.getAvailableSides().size() == roster.getSides().size();
    }

    public String getLockedByuser() {
        return this.lockedByuser;
    }

    public String getLockedBypw() {
        return this.lockedBypw;
    }

    public boolean isLocked() {
        return !this.lockedByuser.isBlank();
    }

    public boolean isUiLocked() {
        return this.uiTabLock;
    }

    public void processChanges() {
        for (AbstractScenarioProperty property : this.getAllDescendantComponentsOf(AbstractScenarioProperty.class)) {
            Entry entry = this.entries.get(property.getConfigureName());
            if (!entry.hasValueChanged()) continue;
            entry.getProperty().processOptionChange(entry.getNewValue());
        }
        if (this.isLocked() != this.uiTabLock) {
            this.lockTab(this.uiTabLock, this.uiTabLockDt);
        }
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        for (AbstractScenarioProperty b : this.getComponentsOf(AbstractScenarioProperty.class)) {
            l.add(b.getConfigureName());
        }
        return l;
    }

    @Override
    public List<String> getPropertyList() {
        return this.getPropertyNames();
    }

    public static class ChangeOptionConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[]{ScenarioPropertiesOptionTab.REPORT_PROP_NAME, ScenarioPropertiesOptionTab.REPORT_PROMPT, ScenarioPropertiesOptionTab.REPORT_OLD_VALUE, ScenarioPropertiesOptionTab.REPORT_NEW_VALUE, ScenarioPropertiesOptionTab.REPORT_TAB});
        }
    }

    public static class LockScenarioOptionsTab
    extends Command {
        private final ScenarioPropertiesOptionTab tab;
        private final String lockedBy;
        private final String lockedPw;
        private final String lockedDt;
        private final String oldLockedBy;
        private final String oldLockedPw;
        private final String oldLockedDt;

        public LockScenarioOptionsTab(ScenarioPropertiesOptionTab tab, String lockedBy, String lockedPw, String lockedDt) {
            this.tab = tab;
            this.lockedBy = lockedBy;
            this.lockedPw = lockedPw;
            this.lockedDt = lockedDt;
            this.oldLockedBy = tab.lockedByuser;
            this.oldLockedPw = tab.lockedBypw;
            this.oldLockedDt = tab.lockedDt;
        }

        @Override
        protected void executeCommand() {
            this.tab.lockedByuser = this.lockedBy;
            this.tab.lockedBypw = this.lockedPw;
            this.tab.lockedDt = this.lockedDt;
        }

        @Override
        protected Command myUndoCommand() {
            return new LockScenarioOptionsTab(this.tab, this.oldLockedBy, this.oldLockedPw, this.oldLockedDt);
        }

        public ScenarioPropertiesOptionTab getTab() {
            return this.tab;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }

        public String getLockedPw() {
            return this.lockedPw;
        }

        public String getLockedDt() {
            return this.lockedDt;
        }
    }

    private static class Entry {
        private final AbstractScenarioProperty property;
        private final String oldValue;
        private final Configurer configurer;

        public Entry(AbstractScenarioProperty property) {
            this.property = property;
            this.oldValue = property.getPropertyValue();
            this.configurer = property.getOptionConfigurer();
            this.configurer.getControls();
        }

        public boolean hasValueChanged() {
            return !Objects.equals(this.oldValue, this.getNewValue());
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String getNewValue() {
            return this.configurer.getValueString();
        }

        public Configurer getConfigurer() {
            return this.configurer;
        }

        public String getDescription() {
            return this.property.getDescription();
        }

        public AbstractScenarioProperty getProperty() {
            return this.property;
        }

        public void setEnabled(boolean enabled) {
            this.getConfigurer().setEnabled(enabled);
        }
    }
}

