/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.messageboard;

import VASSAL.chat.messageboard.Message;
import VASSAL.chat.messageboard.MessageBoard;
import VASSAL.chat.messageboard.MessageViewer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class MessageBoardControls {
    private MessageBoard server;
    private String serverName;
    private Action checkMessagesAction;
    private Action postMessageAction;
    private MessageViewer viewer;
    private JFrame msgFrame;
    private JFrame msgComposer;

    public MessageBoardControls() {
        this.initComponents();
        this.setServer(null, null);
    }

    public void setServer(MessageBoard msgSvr, String name) {
        this.server = msgSvr;
        this.serverName = name;
        this.checkMessagesAction.setEnabled(this.server != null);
        this.postMessageAction.setEnabled(this.server != null);
    }

    public void showMessages(Message[] m) {
        this.viewer.setMessages(Collections.enumeration(Collections.unmodifiableList(Arrays.asList(m))));
    }

    private void initComponents() {
        this.viewer = new MessageViewer();
        this.msgFrame = new JFrame(Resources.getString("Chat.message_board"));
        this.msgFrame.setDefaultCloseOperation(1);
        this.msgFrame.setLayout(new BoxLayout(this.msgFrame.getContentPane(), 1));
        this.msgFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this.msgFrame));
        this.msgFrame.add(this.viewer);
        Box box = Box.createHorizontalBox();
        final JButton refresh = new JButton(Resources.getString("Chat.refresh"));
        refresh.addActionListener(evt -> {
            refresh.setEnabled(false);
            new SwingWorker<Message[], Void>(this){
                final /* synthetic */ MessageBoardControls this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected Message[] doInBackground() {
                    return this.this$0.server.getMessages();
                }

                @Override
                protected void done() {
                    try {
                        this.this$0.showMessages((Message[])this.get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        ErrorDialog.bug(e);
                    }
                    this.this$0.msgFrame.setTitle(this.this$0.serverName != null ? Resources.getString("Chat.message_board_title", this.this$0.serverName) : Resources.getString("Chat.message_board"));
                    refresh.setEnabled(true);
                }
            }.execute();
        });
        box.add(refresh);
        JButton b = new JButton(Resources.getString("General.close"));
        b.addActionListener(e -> this.msgFrame.setVisible(false));
        box.add(b);
        this.msgFrame.add(box);
        this.msgComposer = new Comp();
        this.checkMessagesAction = new AbstractAction(Resources.getString("Chat.check_messages")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.setEnabled(false);
                new SwingWorker<Message[], Void>(){

                    @Override
                    protected Message[] doInBackground() {
                        return MessageBoardControls.this.server.getMessages();
                    }

                    @Override
                    protected void done() {
                        try {
                            MessageBoardControls.this.showMessages((Message[])this.get());
                        }
                        catch (InterruptedException | ExecutionException e) {
                            ErrorDialog.bug(e);
                        }
                        MessageBoardControls.this.msgFrame.setTitle(MessageBoardControls.this.serverName != null ? Resources.getString("Chat.message_board_title", MessageBoardControls.this.serverName) : Resources.getString("Chat.message_board"));
                        MessageBoardControls.this.msgFrame.setVisible(true);
                        this.setEnabled(true);
                    }
                }.execute();
            }
        };
        URL imageURL = this.getClass().getResource("/images/getMessages.gif");
        if (imageURL != null) {
            this.checkMessagesAction.putValue("ShortDescription", this.checkMessagesAction.getValue("Name"));
            this.checkMessagesAction.putValue("Name", "");
            this.checkMessagesAction.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        this.postMessageAction = new AbstractAction(Resources.getString("Chat.post_message")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBoardControls.this.msgComposer.setVisible(true);
            }
        };
        imageURL = this.getClass().getResource("/images/postMessage.gif");
        if (imageURL != null) {
            this.postMessageAction.putValue("ShortDescription", this.postMessageAction.getValue("Name"));
            this.postMessageAction.putValue("Name", "");
            this.postMessageAction.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        this.msgFrame.pack();
        this.msgFrame.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.msgFrame.getSize().width / 2, 0);
    }

    public Action getCheckMessagesAction() {
        return this.checkMessagesAction;
    }

    public Action getPostMessageAction() {
        return this.postMessageAction;
    }

    private class Comp
    extends JFrame {
        private static final long serialVersionUID = 1L;

        private Comp() {
            super(Resources.getString("Chat.message_composer"));
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(1);
            this.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this));
            final JTextArea msgArea = new JTextArea(15, 60);
            Box b = Box.createHorizontalBox();
            final JButton okButton = new JButton(Resources.getString("Chat.send"));
            okButton.addActionListener(evt -> {
                okButton.setEnabled(false);
                msgArea.setEnabled(false);
                new SwingWorker<Void, Void>(this){
                    final /* synthetic */ Comp this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    protected Void doInBackground() {
                        this.this$1.MessageBoardControls.this.server.postMessage(msgArea.getText());
                        return null;
                    }

                    @Override
                    protected void done() {
                        this.this$1.setVisible(false);
                        okButton.setEnabled(true);
                        msgArea.setText("");
                        msgArea.setEnabled(true);
                    }
                }.execute();
            });
            JButton cancelButton = new JButton(Resources.getString("General.cancel"));
            cancelButton.addActionListener(evt -> {
                this.setVisible(false);
                msgArea.setText("");
            });
            b.add(okButton);
            b.add(cancelButton);
            this.add(new JScrollPane(msgArea));
            this.add(b);
            SwingUtils.setDefaultButtons(this.getRootPane(), okButton, cancelButton);
            this.pack();
            this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getSize().width / 2, 0);
        }
    }
}

