/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.tools.PropertiesEncoder;
import java.io.IOException;
import java.util.Properties;
import org.litesoft.p2pchat.PeerInfo;

public class P2PPlayer
extends SimplePlayer {
    private static final String ID = "id";
    private static final String ROOM = "room";
    private final PeerInfo info;
    private Properties props;

    public P2PPlayer(PeerInfo info) {
        this.info = info;
        if (info.getChatName() != null) {
            try {
                this.props = new PropertiesEncoder(info.getChatName()).getProperties();
                this.setStats();
            }
            catch (IOException ex) {
                this.props = new Properties();
                this.setProps();
            }
        } else {
            this.props = new Properties();
            this.setProps();
        }
    }

    public void setStats(Player p) {
        this.setName(p.getName());
        this.setStatus(p.getStatus());
        this.setId(p.getId());
        this.setProps();
    }

    private void setProps() {
        SimpleStatus s = (SimpleStatus)this.status;
        this.props.put("name", this.getName());
        this.props.put("looking", String.valueOf(s.isLooking()));
        this.props.put("away", String.valueOf(s.isAway()));
        this.props.put("profile", s.getProfile());
        this.props.put("ip", s.getIp());
        this.props.put("client", s.getClient());
        this.props.put("moduleVersion", s.getModuleVersion());
        this.props.put("crc", s.getCrc());
        this.props.put("CombinedCrc", s.getCombinedCrc());
        this.info.setChatName(new PropertiesEncoder(this.props).getStringValue());
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    private void setStats() {
        this.setName(this.props.getProperty("name", "???"));
        this.setStatus(new SimpleStatus("true".equals(this.props.getProperty("looking")), "true".equals(this.props.getProperty("away")), this.props.getProperty("profile", ""), this.props.getProperty("client", ""), this.props.getProperty("ip", ""), this.props.getProperty("moduleVersion", ""), this.props.getProperty("crc", ""), this.props.getProperty("CombinedCrc", "")));
    }

    public String getRoom() {
        return this.props.getProperty(ROOM);
    }

    public void setRoom(String name) {
        this.props.put(ROOM, name);
        this.setProps();
    }

    @Override
    public String getId() {
        return this.props.getProperty(ID);
    }

    @Override
    public void setId(String id) {
        this.props.put(ID, id);
        this.setProps();
    }

    @Override
    public int hashCode() {
        return this.getId() == null ? this.info.hashCode() : this.getId().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof P2PPlayer) {
            P2PPlayer p = (P2PPlayer)o;
            return this.getId() == null ? this.info.equals(p.info) : this.getId().equals(p.getId());
        }
        return false;
    }

    public PeerInfo getInfo() {
        return this.info;
    }

    public String summary() {
        return this.getName() + " [looking = " + ((SimpleStatus)this.status).isLooking() + ", away = " + ((SimpleStatus)this.getStatus()).isAway() + ", room = " + this.props.getProperty(ROOM) + ", host = " + this.getInfo().getAddresses() + "]";
    }
}

