/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.filechooser.AudioFileFilter;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AudioClipConfigurer
extends FileConfigurer {
    protected static DirectoryConfigurer resourceDirPref;
    protected FormattedExpressionConfigurer.ExpressionButton button;
    protected EditablePiece sourcePiece;

    public AudioClipConfigurer(String key, String name, ArchiveWriter archive, EditablePiece piece) {
        super(key, name, archive);
        this.sourcePiece = piece;
    }

    public AudioClipConfigurer(String key, String name, ArchiveWriter archive) {
        super(key, name);
        this.archive = archive;
    }

    @Override
    protected FileChooser initFileChooser() {
        if (resourceDirPref == null) {
            resourceDirPref = new DirectoryConfigurer("audioDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, resourceDirPref);
        }
        FileChooser fc = FileChooser.createFileChooser(GameModule.getGameModule().getPlayerWindow(), resourceDirPref);
        fc.setFileFilter(new AudioFileFilter());
        return fc;
    }

    @Override
    protected void addToArchive(File f) {
        this.archive.addSound(f.getPath(), f.getName());
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new ConfigurerPanel(this.getName(), "[]rel[grow,fill,push]1[]", "[]rel[]rel[grow,fill,push]1[]");
            JButton b = new JButton(Resources.getString("Editor.select"));
            this.p.add(b);
            this.tf = new JTextField(this.getValueString());
            this.tf.setEditable(this.editable);
            if (this.editable) {
                this.tf.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AudioClipConfigurer.this.tf.selectAll();
                            }
                        });
                    }
                });
            }
            this.tf.setMaximumSize(new Dimension(this.tf.getMaximumSize().width, this.tf.getPreferredSize().height));
            this.tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent evt) {
                    this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent evt) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent evt) {
                    this.update();
                }

                public void update() {
                    String text = AudioClipConfigurer.this.tf.getText();
                    if (text != null && text.startsWith("{")) {
                        AudioClipConfigurer.this.noUpdate = true;
                        AudioClipConfigurer.this.setValue(text);
                        AudioClipConfigurer.this.noUpdate = false;
                    } else {
                        File f = text != null && text.length() > 0 && !"null".equals(text) ? new File(text) : null;
                        AudioClipConfigurer.this.noUpdate = true;
                        AudioClipConfigurer.this.setValue(f);
                        AudioClipConfigurer.this.noUpdate = false;
                    }
                }
            });
            this.p.add((Component)this.tf, "grow");
            this.button = new FormattedExpressionConfigurer.ExpressionButton(this, this.tf.getPreferredSize().height, this.sourcePiece);
            this.p.add(this.button);
            b.addActionListener(e -> this.chooseNewValue());
        }
        return this.p;
    }

    @Override
    public String getValueString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return super.getValueString();
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof String && ((String)o).startsWith("{")) {
            Object oldValue = this.getValue();
            this.value = o;
            if (!this.frozen) {
                this.changeSupport.firePropertyChange(this.key, oldValue, this.value);
            }
            if (this.tf != null && !this.noUpdate) {
                this.tf.setText(this.getValueString());
            }
        } else {
            super.setValue(o);
        }
    }

    @Override
    public void setValue(String s) {
        if (s != null && s.startsWith("{")) {
            this.setValue((Object)s);
        } else {
            super.setValue(s);
        }
    }
}

