/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.AbstractConfigurableListEntry;
import VASSAL.configure.ConfigurableList;
import VASSAL.configure.ConfigurableListController;
import VASSAL.configure.ConfigurableListEntry;
import VASSAL.configure.Configurer;
import VASSAL.configure.DynamicKeyCommandConfigurer;
import VASSAL.configure.NoInsetButton;
import VASSAL.counters.DynamicProperty;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class DynamicKeyCommandListConfigurer
extends Configurer
implements ConfigurableList {
    private static final int HEADER_COMPONENT_COUNT = 4;
    private static final int COMPONENT_COUNT = 6;
    private DynamicProperty target;
    private ConfigurableListController controller;
    private int selectedEntryIndex = -1;
    private JPanel panel;
    private JPanel controls;
    private JPanel configControls;
    private final List<ConfigurableListEntry> entries = new ArrayList<ConfigurableListEntry>();
    private final boolean remote;

    public DynamicKeyCommandListConfigurer(String key, String name, DynamicProperty target, boolean remote) {
        super(key, name);
        this.setTarget(target);
        this.value = new ArrayList(0);
        this.remote = remote;
    }

    public DynamicKeyCommandListConfigurer(String key, String name, DynamicProperty target) {
        this(key, name, target, false);
    }

    public boolean isRemote() {
        return this.remote;
    }

    public DynamicProperty getTarget() {
        return this.target;
    }

    public void setTarget(DynamicProperty target) {
        this.target = target;
    }

    @Override
    public void moveEntryUp() {
        int pos = this.getSelectedEntryIndex();
        if (pos < 0 || pos > this.entries.size() - 1) {
            return;
        }
        int listPos = this.getSelectedEntryIndex();
        DKCEntry entry = (DKCEntry)this.entries.get(listPos);
        this.removeConfigControls(entry);
        this.insertConfigControls(entry, listPos - 1);
        this.entries.remove(entry);
        this.entries.add(listPos - 1, entry);
        Object temp = this.getListValue().get(pos);
        this.getListValue().set(pos, this.getListValue().get(pos - 1));
        this.getListValue().set(pos - 1, temp);
        this.setSelectedEntryIndex(pos - 1);
        this.updateControls();
    }

    @Override
    public void moveEntryDown() {
        int pos = this.getSelectedEntryIndex();
        if (pos < 0 || pos >= this.entries.size()) {
            return;
        }
        int listPos = this.getSelectedEntryIndex();
        DKCEntry entry = (DKCEntry)this.entries.get(listPos);
        this.removeConfigControls(entry);
        this.insertConfigControls(entry, listPos + 1);
        this.entries.remove(entry);
        this.entries.add(listPos + 1, entry);
        Object temp = this.getListValue().get(pos);
        this.getListValue().set(pos, this.getListValue().get(pos + 1));
        this.getListValue().set(pos + 1, temp);
        this.setSelectedEntryIndex(pos + 1);
        this.updateControls();
    }

    @Override
    public void addEntry() {
        int pos = this.getSelectedEntryIndex();
        DKCEntry newEntry = new DKCEntry(this);
        this.getListValue().add(pos + 1, newEntry.getConfigurer().getValue());
        this.entries.add(pos + 1, newEntry);
        this.insertConfigControls(newEntry, pos + 1);
        this.setSelectedEntryIndex(pos + 1);
        this.updateControls(pos + 1);
    }

    @Override
    public void deleteEntry(ConfigurableListEntry entry) {
        int listPos = this.entries.indexOf(entry);
        int componentPos = this.listPosToControlsPos(listPos);
        for (int i = 0; i < 6; ++i) {
            this.configControls.remove(componentPos);
        }
        this.entries.remove(entry);
        if (this.getSelectedEntryIndex() > this.entries.size() - 1) {
            this.setSelectedEntryIndex(this.entries.size() - 1);
        }
        this.getListValue().remove(listPos);
        this.updateControls();
    }

    @Override
    public void selectEntry(ConfigurableListEntry entry) {
        this.setSelectedEntryIndex(entry == null ? -1 : this.entries.indexOf(entry));
        this.updateControls();
    }

    @Override
    public void setSelectedEntryIndex(int index) {
        this.selectedEntryIndex = index;
    }

    @Override
    public int getSelectedEntryIndex() {
        return this.selectedEntryIndex;
    }

    @Override
    public void entryChanged(ConfigurableListEntry entry) {
        int pos = this.entries.indexOf(entry);
        if (pos >= 0) {
            this.getListValue().set(pos, entry.getConfigurer().getValue());
            this.fireUpdate();
        }
    }

    @Override
    public JComponent getListController() {
        if (this.controller == null) {
            this.controller = new ConfigurableListController(this);
        }
        return this.controller;
    }

    @Override
    public String getValueString() {
        if (this.getListValue().isEmpty()) {
            return "";
        }
        DynamicKeyCommandConfigurer c = new DynamicKeyCommandConfigurer(this.getTarget());
        SequenceEncoder se = new SequenceEncoder(',');
        for (Object value : this.getListValue()) {
            c.setFrozen(true);
            c.setValue(value);
            c.setFrozen(false);
            se.append(c.getValueString());
        }
        return se.getValue();
    }

    public List<Object> getListValue() {
        return (List)this.getValue();
    }

    @Override
    public void setValue(String s) {
        this.getListValue().clear();
        if (s.length() > 0) {
            DynamicKeyCommandConfigurer c = new DynamicKeyCommandConfigurer(this.getTarget());
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
            while (sd.hasMoreTokens()) {
                ((Configurer)c).setFrozen(true);
                ((Configurer)c).setValue(sd.nextToken());
                ((Configurer)c).setFrozen(false);
                this.getListValue().add(c.getValue());
            }
        }
        this.rebuildControls();
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            o = new ArrayList();
        }
        super.setValue(o);
        this.rebuildControls();
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel((LayoutManager)new MigLayout("gapy 4", "[grow,fill][]"));
            this.panel.setBorder(BorderFactory.createEtchedBorder());
            this.controls = new JPanel((LayoutManager)new MigLayout("hidemode 3,ins 2", "[grow,fill]", "[grow,fill]"));
            this.configControls = new JPanel((LayoutManager)new MigLayout("hidemode 3,ins 0,gapy 4", "[grow 1,fill]rel[grow 1,fill]rel[]rel[grow 4,fill]rel[]", "[center]"));
            this.controls.add((Component)this.configControls, "grow, aligny center");
            this.panel.add((Component)this.controls, "grow");
            this.panel.add((Component)this.getListController(), "growy 0,aligny center");
            this.rebuildControls();
        }
        return this.panel;
    }

    protected void rebuildControls() {
        if (this.controls != null) {
            this.entries.clear();
            this.configControls.removeAll();
            this.buildHeader();
            for (Object value : this.getListValue()) {
                DKCEntry entry = new DKCEntry(this, value);
                this.entries.add(entry);
                this.appendConfigControls(entry);
            }
            this.updateControls();
            this.repack();
        }
    }

    private void updateControls(int focus) {
        this.updateControls();
        this.entries.get(focus).requestFocus();
    }

    private void updateControls() {
        this.configControls.setVisible(!this.getListValue().isEmpty());
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).updateVisibility();
            this.entries.get(i).setHighlighted(i == this.getSelectedEntryIndex());
        }
        this.updateListController();
        this.configControls.revalidate();
        this.repack();
    }

    private void updateListController() {
        this.getListController();
        this.controller.setCanMoveUp(this.getSelectedEntryIndex() > 0);
        this.controller.setCanMoveDown(this.getSelectedEntryIndex() >= 0 && this.getSelectedEntryIndex() < this.entries.size() - 1);
    }

    private void buildHeader() {
        JLabel commandHeader = new JLabel(Resources.getString("Editor.menu_command"));
        Font boldFont = new Font(commandHeader.getFont().getFontName(), 1, commandHeader.getFont().getSize());
        commandHeader.setFont(boldFont);
        this.configControls.add((Component)commandHeader, "growx 0,alignx center");
        JLabel keyHeader = new JLabel(Resources.getString("Editor.keyboard_command"));
        keyHeader.setFont(boldFont);
        this.configControls.add((Component)keyHeader, "growx 0,alignx center");
        JLabel typeLabel = new JLabel(Resources.getString("Editor.PropertyChangeConfigurer.type"));
        typeLabel.setFont(boldFont);
        this.configControls.add((Component)typeLabel, "growx 0,alignx center");
        JLabel promptLabel = new JLabel(Resources.getString(this.isRemote() ? "Editor.PropertyChangeConfigurer.prompt_remote" : "Editor.PropertyChangeConfigurer.prompt"));
        promptLabel.setFont(boldFont);
        this.configControls.add((Component)promptLabel, "growx 0,alignx center,wrap");
        this.configControls.setVisible(false);
    }

    private void appendConfigControls(DKCEntry entry) {
        DynamicKeyCommandConfigurer c = entry.getDkcConfigurer();
        this.getControls();
        this.configControls.add(c.getCommandControls(), "growx");
        this.configControls.add(c.getKeyControls(), "growx");
        this.configControls.add(c.getTypeControls(), "growx");
        this.configControls.add((Component)entry.getPromptPanel(), "growx");
        this.configControls.add((Component)entry.getRemoveButton(), "growx 0,wrap");
        this.configControls.add(c.getValuesControls(), "skip 2,span 2,grow,wrap");
    }

    private void insertConfigControls(DKCEntry entry, int listPos) {
        int controlPos = this.listPosToControlsPos(listPos);
        DynamicKeyCommandConfigurer c = entry.getDkcConfigurer();
        this.getControls();
        this.configControls.add(c.getCommandControls(), "growx", controlPos++);
        this.configControls.add(c.getKeyControls(), "growx", controlPos++);
        this.configControls.add(c.getTypeControls(), "growx 0", controlPos++);
        this.configControls.add(entry.getPromptPanel(), "growx", controlPos++);
        this.configControls.add(entry.getRemoveButton(), "growx 0,wrap", controlPos++);
        this.configControls.add(c.getValuesControls(), "skip 2,span 2,grow,wrap", controlPos);
    }

    private void removeConfigControls(DKCEntry entry) {
        DynamicKeyCommandConfigurer c = entry.getDkcConfigurer();
        this.getControls();
        this.configControls.remove(c.getCommandControls());
        this.configControls.remove(c.getKeyControls());
        this.configControls.remove(c.getTypeControls());
        this.configControls.remove(entry.getPromptPanel());
        this.configControls.remove(entry.getRemoveButton());
        this.configControls.remove(c.getValuesControls());
    }

    private int listPosToControlsPos(int listPos) {
        return 4 + listPos * 6;
    }

    @Override
    public void repack() {
        this.repack(this.panel);
    }

    private static class DKCEntry
    extends AbstractConfigurableListEntry {
        private final DynamicKeyCommandListConfigurer listConfig;
        private NoInsetButton showHideValuesButton;
        private JPanel promptPanel;
        private boolean valuesShowing = false;

        public DKCEntry(DynamicKeyCommandListConfigurer listConfig) {
            this(listConfig, null);
        }

        public DKCEntry(DynamicKeyCommandListConfigurer listConfig, Object value) {
            this(listConfig, value, 0);
        }

        public DKCEntry(DynamicKeyCommandListConfigurer listConfig, Object value, int iconSize) {
            super(listConfig, value, iconSize);
            this.listConfig = listConfig;
        }

        private DynamicKeyCommandConfigurer getDkcConfigurer() {
            return (DynamicKeyCommandConfigurer)this.getConfigurer();
        }

        @Override
        public Configurer buildChildConfigurer(Object value) {
            DynamicKeyCommandConfigurer c = new DynamicKeyCommandConfigurer(this.listConfig.getTarget());
            ((Configurer)c).setFrozen(true);
            ((Configurer)c).setValue(value);
            ((Configurer)c).setFrozen(false);
            return c;
        }

        public JPanel getPromptPanel() {
            if (this.promptPanel == null) {
                this.getDkcConfigurer().getValuesControls().setVisible(false);
                this.promptPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[grow,fill]2[]"));
                this.promptPanel.add(this.getDkcConfigurer().getChangerControls(), "growx,aligny center");
                this.promptPanel.add((Component)this.getShowHideValuesButton(), "aligny center");
            }
            return this.promptPanel;
        }

        @Override
        public void focusGained() {
            this.listConfig.selectEntry(this);
        }

        @Override
        public void setHighlighted(boolean highlighted) {
            this.getConfigurer().setHighlighted(highlighted);
        }

        private void showHideValues() {
            this.valuesShowing = !this.valuesShowing;
            this.getDkcConfigurer().getValuesControls().setVisible(this.valuesShowing);
            this.getParent().repack();
        }

        public JButton getShowHideValuesButton() {
            if (this.showHideValuesButton == null) {
                this.showHideValuesButton = new NoInsetButton("edit-find", 0, "Editor.PropertyChangeConfigurer.showHide_hint");
                this.showHideValuesButton.setVisible(false);
                this.showHideValuesButton.addActionListener(e -> this.showHideValues());
            }
            return this.showHideValuesButton;
        }

        @Override
        public void updateVisibility() {
            boolean show = this.getDkcConfigurer().isEnumType();
            this.getShowHideValuesButton().setVisible(show);
            this.getDkcConfigurer().getValuesControls().setVisible(show && this.valuesShowing);
            this.getParent().repack();
        }
    }
}

