/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameState;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.PredefinedSetup;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.HintTextField;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.SoundConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshPredefinedSetupsDialog
extends JDialog {
    private static final Logger logger = LoggerFactory.getLogger(RefreshPredefinedSetupsDialog.class);
    private static final long serialVersionUID = 1L;
    private JCheckBox refreshPieces;
    private JCheckBox nameCheck;
    private JCheckBox fixGPID;
    private JCheckBox labelerNameCheck;
    private JCheckBox layerNameCheck;
    private JCheckBox rotateNameCheck;
    private JCheckBox testModeOn;
    private JCheckBox deletePieceNoMap;
    private JCheckBox refreshDecks;
    private JCheckBox deleteOldDecks;
    private JCheckBox addNewDecks;
    private JTextField pdsFilterBox;
    private String pdsFilter;
    private JCheckBox reportOff;
    private JCheckBox alertOn;
    private boolean optionsUserMode;
    private static final int FILE_NAME_REPORT_LENGTH = 24;
    private JCheckBox fireHotkey;
    private final Set<String> options = new HashSet<String>();

    public RefreshPredefinedSetupsDialog(Frame owner) throws HeadlessException {
        super(owner, false);
        this.setTitle(Resources.getString("Editor.RefreshPredefinedSetupsDialog.title"));
        this.setModal(true);
        this.initComponents();
    }

    private void initComponents() {
        this.optionsUserMode = true;
        this.setLayout((LayoutManager)new MigLayout("wrap 1", "[fill]"));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1,gapy 4", "[fill]"));
        panel.setBorder(BorderFactory.createEtchedBorder());
        FlowLabel header = new FlowLabel(Resources.getString("GameRefresher.predefined_header"));
        header.setFocusable(false);
        panel.add(header);
        JSeparator sep = new JSeparator(0);
        panel.add(sep);
        JPanel buttonsBox = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
        JButton refreshButton = new JButton(Resources.getString("General.run"));
        refreshButton.addActionListener(e -> this.refreshPredefinedSetups());
        JButton closeButton = new JButton(Resources.getString("General.cancel"));
        JButton helpButton = new JButton(Resources.getString("General.help"));
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "SavedGameUpdater.html"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        helpButton.addActionListener(new ShowHelpAction(hf.getContents(), null));
        closeButton.addActionListener(e -> this.dispose());
        buttonsBox.add((Component)refreshButton, "tag ok,sg 1");
        buttonsBox.add((Component)closeButton, "tag cancel,sg 1");
        buttonsBox.add((Component)helpButton, "tag help,sg 1");
        this.refreshPieces = new JCheckBox(Resources.getString("GameRefresher.refresh_pieces"), true);
        this.refreshPieces.setEnabled(false);
        panel.add(this.refreshPieces);
        this.nameCheck = new JCheckBox(Resources.getString("GameRefresher.use_basic_name"));
        panel.add((Component)this.nameCheck, "gapx 10");
        this.nameCheck.addChangeListener(e -> {
            if (this.optionsUserMode) {
                this.fixGPID.setVisible(this.nameCheck.isSelected());
            }
        });
        this.fixGPID = new JCheckBox(Resources.getString("GameRefresher.fix_gpid"));
        panel.add((Component)this.fixGPID, "gapx 20");
        this.labelerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_labeler_descr"), true);
        panel.add((Component)this.labelerNameCheck, "gapx 10");
        this.layerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_layer_descr"), true);
        panel.add((Component)this.layerNameCheck, "gapx 10");
        this.rotateNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_rotate_descr"), true);
        panel.add((Component)this.rotateNameCheck, "gapx 10");
        this.deletePieceNoMap = new JCheckBox(Resources.getString("GameRefresher.delete_piece_no_map"), true);
        this.refreshDecks = new JCheckBox(Resources.getString("GameRefresher.refresh_decks"), false);
        this.refreshDecks.addChangeListener(e -> {
            if (this.optionsUserMode) {
                this.deleteOldDecks.setVisible(this.refreshDecks.isSelected());
                this.addNewDecks.setVisible(this.refreshDecks.isSelected());
            }
        });
        panel.add(this.refreshDecks);
        this.deleteOldDecks = new JCheckBox(Resources.getString("GameRefresher.delete_old_decks"), false);
        panel.add((Component)this.deleteOldDecks, "gapx 10");
        this.addNewDecks = new JCheckBox(Resources.getString("GameRefresher.add_new_decks"), false);
        panel.add((Component)this.addNewDecks, "gapx 10");
        this.fireHotkey = new JCheckBox(Resources.getString("GameRefresher.fire_global_hotkey"), false);
        this.fireHotkey.addChangeListener(e -> {
            if (this.optionsUserMode) {
                this.reportOff.setVisible(this.fireHotkey.isSelected());
            }
        });
        panel.add(this.fireHotkey);
        this.reportOff = new JCheckBox(Resources.getString("Editor.RefreshPredefinedSetups.reportOff"), false);
        panel.add((Component)this.reportOff, "gapx 10");
        panel.add(sep);
        this.testModeOn = new JCheckBox(Resources.getString("GameRefresher.test_mode"), false);
        JPanel filterPanel = new JPanel((LayoutManager)new MigLayout("ins 0,gapy 4", "[]rel[grow,fill,push]"));
        filterPanel.add((Component)new JLabel(Resources.getString("Editor.RefreshPredefinedSetups.filter_prompt")), "");
        this.pdsFilterBox = new HintTextField(32, Resources.getString("Editor.RefreshPredefinedSetups.filter_hint"));
        filterPanel.add((Component)this.pdsFilterBox, "wrap");
        panel.add((Component)filterPanel, "");
        this.alertOn = new JCheckBox(Resources.getString("Editor.RefreshPredefinedSetups.alertOn"), false);
        panel.add(this.alertOn);
        panel.add((Component)buttonsBox, "grow");
        this.add((Component)panel, "grow");
        this.setLocationRelativeTo(this.getOwner());
        SwingUtils.repack(this);
        SwingUtils.setDefaultButtons(this.getRootPane(), refreshButton, closeButton);
        this.fixGPID.setVisible(this.nameCheck.isSelected());
        this.deleteOldDecks.setVisible(this.refreshDecks.isSelected());
        this.addNewDecks.setVisible(this.refreshDecks.isSelected());
        this.reportOff.setVisible(this.fireHotkey.isSelected());
        panel.setEnabled(false);
    }

    protected void setOptions() {
        this.pdsFilter = this.pdsFilterBox.getText();
        this.options.clear();
        if (this.refreshPieces.isSelected()) {
            this.options.add("RefreshPieces");
            if (this.nameCheck.isSelected()) {
                this.options.add("UseName");
                if (this.fixGPID.isSelected()) {
                    this.options.add("fixGPID");
                }
            }
            if (this.labelerNameCheck.isSelected()) {
                this.options.add("UseLabelerName");
            }
            if (this.layerNameCheck.isSelected()) {
                this.options.add("UseLayerName");
            }
            if (this.rotateNameCheck.isSelected()) {
                this.options.add("UseRotateName");
            }
        }
        if (this.testModeOn.isSelected()) {
            this.options.add("TestMode");
        }
        if (this.deletePieceNoMap.isSelected()) {
            this.options.add("DeleteNoMap");
        }
        if (this.refreshDecks.isSelected()) {
            this.options.add("RefreshDecks");
            if (this.deleteOldDecks.isSelected()) {
                this.options.add("DeleteOldDecks");
            }
            if (this.addNewDecks.isSelected()) {
                this.options.add("AddNewDecks");
            }
        }
        if (this.fireHotkey.isSelected()) {
            this.options.add("UseHotkey");
            if (this.reportOff.isSelected()) {
                this.options.add("SuppressInfoReports");
            }
        }
    }

    public void log(String message) {
        GameModule.getGameModule().warn(message);
        logger.info(message);
    }

    public boolean isTestMode() {
        return this.options.contains("TestMode");
    }

    public boolean isFilterMode() {
        return this.pdsFilter != null && !this.pdsFilter.isBlank();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPredefinedSetups() {
        this.setOptions();
        this.optionsUserMode = false;
        for (Component component : this.getComponents(this)) {
            component.setEnabled(false);
        }
        Pattern filterPattern = null;
        Pattern filterPattern2 = null;
        if (this.isFilterMode()) {
            try {
                filterPattern = Pattern.compile(this.pdsFilter, 2);
                filterPattern2 = Pattern.compile(this.pdsFilter + ".*", 2);
            }
            catch (PatternSyntaxException e) {
                filterPattern2 = filterPattern = Pattern.compile(".*\\Q" + this.pdsFilter + "\\T.*", 2);
                this.log(Resources.getString("Editor.RefreshPredefinedSetups.filter_fallback"));
            }
            this.pdsFilter = this.pdsFilter.toLowerCase();
        }
        GameModule mod = GameModule.getGameModule();
        GameState gs = mod.getGameState();
        DataArchive dataArchive = mod.getDataArchive();
        List<ModuleExtension> moduleExtensionList = mod.getComponentsOf(ModuleExtension.class);
        boolean isRefreshOfExtension = !moduleExtensionList.isEmpty();
        List<PredefinedSetup> modulePdsAndMenus = mod.getAllDescendantComponentsOf(PredefinedSetup.class);
        ArrayList<PredefinedSetup> modulePds = new ArrayList<PredefinedSetup>();
        ArrayList<PredefinedSetup> warningPds = new ArrayList<PredefinedSetup>();
        ArrayList<Integer> warningCount = new ArrayList<Integer>();
        ArrayList<PredefinedSetup> failPds = new ArrayList<PredefinedSetup>();
        for (PredefinedSetup pds : modulePdsAndMenus) {
            if (pds.isMenu() || !pds.isUseFile()) continue;
            String pdsName = pds.getAttributeValueString("name");
            String pdsFile = pds.getFileName();
            if (pdsFile == null || pdsFile.isBlank() || this.pdsFilter != null && (pdsName == null || !pdsName.toLowerCase().contains(this.pdsFilter) && (filterPattern == null || !filterPattern.matcher(pdsName).matches() && !filterPattern2.matcher(pdsName).matches())) && !pdsFile.toLowerCase().contains(this.pdsFilter) && (filterPattern == null || !filterPattern.matcher(pdsFile).matches() && !filterPattern2.matcher(pdsFile).matches())) continue;
            boolean isExtensionPDS = true;
            try {
                isExtensionPDS = !dataArchive.contains(pdsFile);
            }
            catch (IOException e) {
                ErrorDialog.bug(e);
            }
            if (isExtensionPDS != isRefreshOfExtension) continue;
            modulePds.add(pds);
        }
        int pdsCount = this.promptConfirmCount(modulePds);
        if (pdsCount > 0) {
            Cursor oldCursor = this.getCursor();
            Cursor waitCursor = Cursor.getPredefinedCursor(3);
            this.setCursor(waitCursor);
            this.log("|<b>" + Resources.getString("Editor.RefreshPredefinedSetupsDialog.start_refresh", mod.getGameVersion(), isRefreshOfExtension ? " " + Resources.getString("Editor.RefreshPredefinedSetupsDialog.extension") : ""));
            if (this.isTestMode()) {
                this.log("~" + Resources.getString("GameRefresher.refresh_counters_test_mode"));
            }
            if (this.isFilterMode()) {
                this.log("~" + Resources.getString("Editor.RefreshPredefinedSetups.setups_filter", ConfigureTree.noHTML(this.pdsFilter)));
            }
            int i = 0;
            int refreshCount = 0;
            int duplicates = 0;
            String lastErrorFile = null;
            Instant startTime = Instant.now();
            Long memoryInUseAtStart = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
            long himem = 0L;
            String hifile = null;
            for (PredefinedSetup pds : modulePds) {
                long mem;
                int pct = i * 100 / pdsCount;
                this.setTitle(Resources.getString("Editor.RefreshPredefinedSetupsDialog.progress", ++i, pdsCount, pct) + (String)(warningPds.isEmpty() ? "" : "  " + Resources.getString("Editor.RefreshPredefinedSetupsDialog.errors", lastErrorFile, warningPds.size() - 1)));
                this.setCursor(waitCursor);
                String pdsFile = pds.getFileName();
                if (i > 1 && this.pdsFileProcessed(modulePds.subList(0, i - 1), pdsFile)) {
                    ++duplicates;
                    if (!this.options.contains("SuppressInfoReports")) {
                        this.log("----------");
                        this.log(Resources.getString(Resources.getString("Editor.RefreshPredefinedSetupsDialog.skip", pds.getAttributeValueString("name"), pdsFile)));
                    }
                } else {
                    gs.setup(false);
                    mod.setRefreshingSemaphore(true);
                    try {
                        int warnings = pds.refreshWithStatus(this.options);
                        if (warnings > 0) {
                            lastErrorFile = this.fixedLength(pdsFile, 24);
                            warningPds.add(pds);
                            warningCount.add(warnings);
                        }
                        ++refreshCount;
                    }
                    catch (IOException e) {
                        ErrorDialog.bug(e);
                        failPds.add(pds);
                    }
                    finally {
                        mod.setRefreshingSemaphore(false);
                    }
                }
                if ((mem = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L) <= himem) continue;
                himem = mem;
                hifile = pdsFile;
            }
            if (!this.isTestMode()) {
                if (this.alertOn.isSelected()) {
                    SoundConfigurer c = (SoundConfigurer)Prefs.getGlobalPrefs().getOption("wakeUpSound");
                    c.play();
                }
                mod.setDirty(true);
            }
            gs.setup(false);
            Duration duration = Duration.between(startTime, Instant.now());
            this.log("|<b>" + Resources.getString("Editor.RefreshPredefinedSetups.end", refreshCount));
            if (duplicates > 0) {
                this.log(Resources.getString("Editor.RefreshPredefinedSetups.duplicates", duplicates));
            }
            if (!warningPds.isEmpty()) {
                this.log("~" + Resources.getString("Editor.RefreshPredefinedSetups.endWarnHeading", warningPds.size()));
                for (i = 0; i < warningPds.size(); ++i) {
                    this.log("|&nbsp; " + Resources.getString("Editor.RefreshPredefinedSetups.endWarnPds", ((PredefinedSetup)warningPds.get(i)).getAttributeValueString("name"), "<b>" + ((PredefinedSetup)warningPds.get(i)).getFileName() + "</b>", warningCount.get(i)));
                }
            }
            if (!failPds.isEmpty()) {
                this.log("~" + Resources.getString("Editor.RefreshPredefinedSetups.endFailHeading", failPds.size()));
                for (i = 0; i < warningPds.size(); ++i) {
                    this.log("|&nbsp; " + Resources.getString("Editor.RefreshPredefinedSetups.endFailPds", ((PredefinedSetup)failPds.get(i)).getAttributeValueString("name"), "<b>" + ((PredefinedSetup)failPds.get(i)).getFileName()) + "</b>");
                }
            }
            this.log(Resources.getString("Editor.RefreshPredefinedSetups.stats", DateTimeFormatter.ofPattern("HH:mm:ss").format(LocalTime.ofSecondOfDay(duration.getSeconds())), memoryInUseAtStart, himem, hifile));
            this.setCursor(oldCursor);
            mod.getPlayerWindow().setCursor(oldCursor);
        }
        if (pdsCount > 0 && warningPds.isEmpty() && failPds.isEmpty()) {
            this.dispose();
        } else {
            this.setTitle(Resources.getString("Editor.RefreshPredefinedSetupsDialog.title"));
            for (Component component : this.getComponents(this)) {
                component.setEnabled(true);
            }
            this.optionsUserMode = true;
        }
    }

    private boolean pdsFileProcessed(List<PredefinedSetup> modulePds, String file) {
        for (PredefinedSetup pds : modulePds) {
            if (!pds.getFileName().equals(file)) continue;
            return true;
        }
        return false;
    }

    private String fixedLength(String text, int length) {
        return text.length() > length ? text.substring(0, length - 3) + "..." : text;
    }

    private int promptConfirmCount(List<PredefinedSetup> pdsList) {
        if (pdsList == null || pdsList.isEmpty()) {
            JOptionPane.showMessageDialog(this, Resources.getString("Editor.RefreshPredefinedSetups.none_found"), Resources.getString("Editor.RefreshPredefinedSetupsDialog.title"), 0);
            return 0;
        }
        JPanel panel = new JPanel();
        JTextArea display = new JTextArea(16, 60);
        display.setEditable(false);
        JScrollPane scroll = new JScrollPane(display, 20, 30);
        panel.add(scroll);
        int i = 0;
        for (PredefinedSetup pds : pdsList) {
            display.append((i++ > 0 ? System.lineSeparator() : "") + pds.getAttributeValueString("name") + Character.toString(9) + pds.getFileName());
        }
        return JOptionPane.showConfirmDialog(this, panel, Resources.getString("Editor.RefreshPredefinedSetups.confirm_title", Resources.getString(this.isTestMode() ? "Editor.RefreshPredefinedSetups.confirm.test" : "Editor.RefreshPredefinedSetups.confirm.run"), i, this.isFilterMode() ? " " + Resources.getString("Editor.RefreshPredefinedSetups.confirm.filter") : ""), 2, 3) == 0 ? i : 0;
    }

    private Component[] getComponents(Component container) {
        ArrayList<Object> list;
        try {
            list = new ArrayList<Component>(Arrays.asList(((Container)container).getComponents()));
            for (int index = 0; index < list.size(); ++index) {
                Collections.addAll(list, this.getComponents((Component)list.get(index)));
            }
        }
        catch (ClassCastException e) {
            list = new ArrayList();
        }
        return list.toArray(new Component[0]);
    }
}

