/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.launch.ExtensionEditorWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.io.FileUtils;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class RemoveUnusedImagesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final DefaultListModel<String> keepModel = new DefaultListModel();
    private final DefaultListModel<String> dumpModel = new DefaultListModel();
    private final SortedSet<String> keep = new TreeSet<String>();
    private final SortedSet<String> dump = new TreeSet<String>();
    private final JButton ok;
    private final DataArchive archive;
    private final JButton dropAllButton;
    private final JButton keepAllButton;
    private final Map<String, Entry> displayIndex = new HashMap<String, Entry>();
    private final JLabel keepTotalLabel = new JLabel();
    private final JLabel dropTotalLabel = new JLabel();

    public RemoveUnusedImagesDialog(Frame owner) {
        super(owner, Resources.getString("Editor.UnusedImages.remove_unused_images"), true);
        AbstractBuildable parent;
        FlowLabel text = new FlowLabel(Resources.getString("Editor.UnusedImages.unused_1"));
        if (owner instanceof ExtensionEditorWindow) {
            parent = ((ExtensionEditorWindow)owner).getExtension();
            this.archive = ((ExtensionEditorWindow)owner).getExtension().getDataArchive().getWriter();
        } else {
            parent = GameModule.getGameModule();
            this.archive = GameModule.getGameModule().getArchiveWriter();
        }
        Collections.addAll(this.keep, this.archive.getImageNames());
        for (String string : parent.getAllImageNames()) {
            this.keep.remove(string);
            if (ImageUtils.hasImageSuffix(string)) continue;
            this.keep.remove(string + ".gif");
        }
        TreeSet<String> keep2 = new TreeSet<String>(this.keep);
        this.keep.clear();
        for (String file : keep2) {
            Entry entry = new Entry(file, this.archive);
            this.keep.add(entry.getDisplayName());
            this.displayIndex.put(entry.getDisplayName(), entry);
        }
        this.keepModel.addAll(this.keep);
        JList<String> jList = new JList<String>(this.keepModel);
        JScrollPane keepScroll = new JScrollPane(jList);
        keepScroll.setBorder(BorderFactory.createTitledBorder(Resources.getString("Editor.UnusedImages.files_to_keep")));
        JList<String> dropList = new JList<String>(this.dumpModel);
        JScrollPane dropScroll = new JScrollPane(dropList);
        dropScroll.setBorder(BorderFactory.createTitledBorder(Resources.getString("Editor.UnusedImages.files_to_remove")));
        JButton dropButton = new JButton(IconFactory.getIcon("go-next", 1));
        JButton keepButton = new JButton(IconFactory.getIcon("go-previous", 1));
        this.dropAllButton = new JButton(IconFactory.getIcon("go-last", 1));
        this.keepAllButton = new JButton(IconFactory.getIcon("go-first", 1));
        this.dropAllButton.setEnabled(!this.keepModel.isEmpty());
        this.keepAllButton.setEnabled(!this.dumpModel.isEmpty());
        this.dropAllButton.addActionListener(e -> {
            if (keepList.getModel().getSize() > 0) {
                keepList.setSelectionInterval(0, keepList.getModel().getSize() - 1);
            }
            this.updateSelection(keepList, this.keepModel, this.keep, this.dump);
        });
        this.keepAllButton.addActionListener(e -> {
            if (dropList.getModel().getSize() > 0) {
                dropList.setSelectionInterval(0, dropList.getModel().getSize() - 1);
            }
            this.updateSelection(dropList, this.dumpModel, this.dump, this.keep);
        });
        this.ok = new JButton(Resources.getString("Editor.UnusedImages.remove_files"));
        JButton cancel = new JButton(Resources.getString("General.cancel"));
        JButton help = new JButton(Resources.getString("General.help"));
        this.ok.addActionListener(e -> this.removeImages());
        keepButton.addActionListener(e -> this.updateSelection(dropList, this.dumpModel, this.dump, this.keep));
        dropButton.addActionListener(e -> this.updateSelection(keepList, this.keepModel, this.keep, this.dump));
        jList.addListSelectionListener(e -> dropButton.setEnabled(!keepList.isSelectionEmpty()));
        jList.setVisibleRowCount(jList.getModel().getSize());
        dropButton.setEnabled(!jList.isSelectionEmpty());
        dropList.addListSelectionListener(e -> keepButton.setEnabled(!dropList.isSelectionEmpty()));
        keepButton.setEnabled(!dropList.isSelectionEmpty());
        this.ok.setEnabled(!this.dumpModel.isEmpty());
        cancel.addActionListener(e -> this.dispose());
        help.addActionListener(e -> this.help());
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 4, fill", "[]rel[]rel[]", "[]unrel[]unrel[]"));
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)text, "span, wrap");
        panel.add((Component)keepScroll, "grow, push, sizegroup list");
        panel.add((Component)this.dropAllButton, "align center, flowy, split 4");
        panel.add((Component)dropButton, "align center");
        panel.add((Component)keepButton, "align center");
        panel.add((Component)this.keepAllButton, "align center");
        panel.add((Component)dropScroll, "grow, push, sizegroup list, wrap");
        panel.add((Component)this.keepTotalLabel, "center");
        panel.add((Component)this.dropTotalLabel, "skip 1,center,wrap");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fill", "push[]rel[]rel[]push"));
        buttonPanel.add((Component)this.ok, "tag ok,sg 1");
        buttonPanel.add((Component)cancel, "tag cancel,sg 1");
        buttonPanel.add((Component)help, "tag help,sg 1");
        panel.add((Component)buttonPanel, "span 3,grow");
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.add((Component)panel, "grow");
        this.updateButtons();
        SwingUtils.repack(this);
    }

    private void help() {
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "RemoveUnusedImages.html"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        new ShowHelpAction(hf.getContents(), null).actionPerformed(null);
    }

    private void updateSelection(JList<String> srclist, DefaultListModel<String> srcmodel, SortedSet<String> src, SortedSet<String> dst) {
        int[] indices = srclist.getSelectedIndices();
        int lastSelect = indices[indices.length - 1];
        Arrays.stream(indices).forEach(i -> {
            String item = (String)srcmodel.getElementAt(i);
            src.remove(item);
            dst.add(item);
        });
        this.keepModel.removeAllElements();
        this.dumpModel.removeAllElements();
        this.keepModel.addAll(this.keep);
        this.dumpModel.addAll(this.dump);
        srclist.setSelectedIndex(Math.max(0, Math.min(lastSelect, srcmodel.getSize()) - 1));
        this.updateButtons();
    }

    private void updateButtons() {
        this.ok.setEnabled(!this.dumpModel.isEmpty());
        this.dropAllButton.setEnabled(!this.keepModel.isEmpty());
        this.keepAllButton.setEnabled(!this.dumpModel.isEmpty());
        long keepTotal = 0L;
        long dropTotal = 0L;
        for (String keepFile : this.keep) {
            keepTotal += this.displayIndex.get(keepFile).getSize();
        }
        for (String keepFile : this.dump) {
            dropTotal += this.displayIndex.get(keepFile).getSize();
        }
        this.keepTotalLabel.setText("(" + FileUtils.byteCountToDisplaySize(keepTotal) + ")");
        this.dropTotalLabel.setText("(" + FileUtils.byteCountToDisplaySize(dropTotal) + ")");
    }

    private void removeImages() {
        for (String uName : this.dump) {
            String u = this.displayIndex.get(uName).getFileName();
            GameModule.getGameModule().warn("- " + Resources.getString("Editor.UnusedImages.removing", uName));
            this.archive.getWriter().removeImage(u);
        }
        if (!this.dump.isEmpty()) {
            GameModule.getGameModule().setDirty(true);
        }
        this.dispose();
    }

    private static class Entry {
        private final String fileName;
        private final String displayName;
        private final long size;

        private static long extractSize(String fileName, DataArchive archive) {
            try {
                return archive.getArchive().getCompressedSize("images/" + fileName);
            }
            catch (IOException ignored) {
                return -1L;
            }
        }

        public Entry(String fileName, DataArchive archive) {
            this.fileName = fileName;
            this.size = Entry.extractSize(fileName, archive);
            this.displayName = fileName + " (" + FileUtils.byteCountToDisplaySize(this.size) + ")";
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public long getSize() {
            return this.size;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

