/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class Pivot
extends Decorator
implements TranslatablePiece {
    public static final String ID = "pivot;";
    public static final String DEGREES = "_Degrees";
    protected int pivotX;
    protected int pivotY;
    protected double angle;
    protected double angle2;
    protected String command;
    protected String command2;
    protected NamedKeyStroke key;
    protected NamedKeyStroke key2;
    protected boolean fixedAngle;
    protected KeyCommand[] commands;
    protected KeyCommand pivotCommand;
    protected KeyCommand pivot2Command;
    protected FreeRotator rotator;
    protected String description;
    private static final double PI_180 = Math.PI / 180;

    public Pivot() {
        this(ID, null);
    }

    public Pivot(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.Pivot.trait_description", this.description);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Pivot.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Pivot.html");
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.command = st.nextToken(Resources.getString("Editor.Pivot.default_pivot_command"));
        this.key = st.nextNamedKeyStroke(null);
        this.pivotX = st.nextInt(0);
        this.pivotY = st.nextInt(0);
        this.fixedAngle = st.nextBoolean(true);
        this.angle = st.nextDouble(90.0);
        this.description = st.nextToken("");
        this.command2 = st.nextToken("");
        this.key2 = st.nextNamedKeyStroke(null);
        this.angle2 = st.nextDouble(270.0);
        this.commands = null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.pivotCommand = new KeyCommand(this.command, this.key, Pivot.getOutermost(this), (TranslatablePiece)this);
            this.pivot2Command = new KeyCommand(this.command2, this.key2, Pivot.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.command.length() > 0 && this.key != null && !this.key.isNull() ? (this.command2.length() > 0 && this.key2 != null && !this.key2.isNull() ? new KeyCommand[]{this.pivotCommand, this.pivot2Command} : new KeyCommand[]{this.pivotCommand}) : (this.command2.length() > 0 && this.key2 != null && !this.key2.isNull() ? new KeyCommand[]{this.pivot2Command} : KeyCommand.NONE);
            this.rotator = (FreeRotator)Pivot.getDecorator(this, FreeRotator.class);
            this.pivotCommand.setEnabled(this.rotator != null);
            this.pivot2Command.setEnabled(this.rotator != null);
        }
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.command).append(this.key).append(this.pivotX).append(this.pivotY).append(this.fixedAngle).append(this.angle).append(this.description).append(this.command2).append(this.key2).append(this.angle2);
        return ID + se.getValue();
    }

    private Command doInteractive(Command c) {
        c = Pivot.putOldProperties(this);
        double oldAngle = this.rotator.getAngleInRadians();
        Point2D.Double pivot2D = new Point2D.Double(this.pivotX, this.pivotY);
        AffineTransform t = AffineTransform.getRotateInstance(oldAngle);
        t.transform(pivot2D, pivot2D);
        this.rotator.beginInteractiveRotate();
        this.rotator.setPivot(this.getPosition().x + (int)Math.round(((Point2D)pivot2D).getX()), this.getPosition().y + (int)Math.round(((Point2D)pivot2D).getY()));
        return c;
    }

    private Command doFixedAngle(Command c, double ang) {
        ChangeTracker t = new ChangeTracker(this);
        double oldAngle = this.rotator.getAngle();
        Point oldPos = this.getPosition();
        Point piv = new Point(oldPos.x + this.pivotX, oldPos.y + this.pivotY);
        AffineTransform.getRotateInstance(-oldAngle * (Math.PI / 180), oldPos.x, oldPos.y).transform(piv, piv);
        this.rotator.setAngle(oldAngle - ang);
        double newAngle = this.rotator.getAngle();
        if (this.getMap() != null) {
            c = Pivot.putOldProperties(this);
            Point pos = this.getPosition();
            this.pivotPoint(pos, -oldAngle * (Math.PI / 180), -newAngle * (Math.PI / 180));
            GamePiece outer = Pivot.getOutermost(this);
            if (!Boolean.TRUE.equals(outer.getProperty("IgnoreGrid"))) {
                pos = this.getMap().snapTo(pos);
            }
            outer.setProperty("Moved", Boolean.TRUE);
            c = c.append(t.getChangeCommand());
            MoveTracker moveTracker = new MoveTracker(outer);
            this.getMap().placeOrMerge(outer, pos);
            c = c.append(moveTracker.getMoveCommand());
            MovementReporter r = new MovementReporter(c);
            if (GlobalOptions.getInstance().autoReportEnabled()) {
                Command reportCommand = r.getReportCommand();
                if (reportCommand != null) {
                    reportCommand.execute();
                }
                c = c.append(reportCommand);
            }
            c = c.append(r.markMovedPieces());
            c = this.rotator.rotateCargo(c, piv, newAngle - oldAngle);
            this.getMap().ensureVisible(this.getMap().selectionBoundsOf(outer));
        } else {
            c = t.getChangeCommand();
        }
        return c;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command c = null;
        if (this.pivotCommand.matches(stroke)) {
            if (this.fixedAngle) {
                c = this.doFixedAngle(c, this.angle);
            } else if (this.getMap() != null) {
                c = this.doInteractive(c);
            }
        } else if (this.fixedAngle && this.pivot2Command.matches(stroke)) {
            c = this.doFixedAngle(c, this.angle2);
        }
        if (c != null && this.getMap() != null && this.getMap().getMoveKey() != null) {
            c = c.append(Pivot.getOutermost(this).keyEvent(this.getMap().getMoveKey()));
        }
        return c;
    }

    private void pivotPoint(Point p, double oldAngle, double newAngle) {
        Point2D.Double pivot2D = new Point2D.Double(this.pivotX, this.pivotY);
        AffineTransform t = AffineTransform.getRotateInstance(oldAngle);
        t.transform(pivot2D, pivot2D);
        t = AffineTransform.getRotateInstance(newAngle - oldAngle, ((Point2D)pivot2D).getX(), ((Point2D)pivot2D).getY());
        Point2D.Float newPos2D = new Point2D.Float(0.0f, 0.0f);
        t.transform(newPos2D, newPos2D);
        p.x += (int)Math.round(((Point2D)newPos2D).getX());
        p.y += (int)Math.round(((Point2D)newPos2D).getY());
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getInner().getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, Resources.getString("Editor.Pivot.pivot_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Pivot)) {
            return false;
        }
        Pivot c = (Pivot)o;
        if (!Objects.equals(this.command, c.command)) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.pivotX, c.pivotX)) {
            return false;
        }
        if (!Objects.equals(this.pivotY, c.pivotY)) {
            return false;
        }
        if (!Objects.equals(this.fixedAngle, c.fixedAngle)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.angle, c.angle)) {
            return false;
        }
        if (!Objects.equals(this.command2, c.command2)) {
            return false;
        }
        if (!Objects.equals(this.key2, c.key2)) {
            return false;
        }
        return Objects.equals(this.angle2, c.angle2);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return List.of(this.key, this.key2);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command, this.command2);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer command;
        private final NamedHotKeyConfigurer key;
        private final StringConfigurer command2;
        private final NamedHotKeyConfigurer key2;
        private final IntConfigurer xOff;
        private final IntConfigurer yOff;
        private final DoubleConfigurer angle;
        private final DoubleConfigurer angle2;
        private final JLabel angleLabel;
        private final JLabel angle2Label;
        private final JLabel command2Label;
        private final JLabel key2Label;
        private final BooleanConfigurer fixedAngle;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer desc;

        public Ed(Pivot p) {
            this.desc = new StringConfigurer(p.description);
            this.desc.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.desc);
            this.command = new StringConfigurer(p.command);
            this.command.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.command);
            this.key = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.keyboard_command", (Configurer)this.key);
            this.controls.add(new JLabel(Resources.getString("Editor.Pivot.pivot_point")));
            JPanel b = new JPanel((LayoutManager)new MigLayout("ins 0", "[]2[]2[]"));
            this.xOff = new IntConfigurer(p.pivotX);
            b.add(this.xOff.getControls());
            b.add(new JLabel(","));
            this.yOff = new IntConfigurer(p.pivotY);
            b.add(this.yOff.getControls());
            this.controls.add(b);
            this.fixedAngle = new BooleanConfigurer(p.fixedAngle);
            this.controls.add("Editor.Pivot.pivot_through_fixed_angle", (Configurer)this.fixedAngle);
            this.angleLabel = new JLabel(Resources.getString("Editor.Pivot.angle"));
            this.angle = new DoubleConfigurer(p.angle);
            this.controls.add(this.angleLabel);
            this.controls.add(this.angle.getControls());
            this.command2 = new StringConfigurer(p.command2);
            this.command2.setHintKey("Editor.menu_command_hint");
            this.command2Label = new JLabel(Resources.getString("Editor.Pivot.menu_command_2"));
            this.controls.add(this.command2Label);
            this.controls.add(this.command2.getControls());
            this.key2 = new NamedHotKeyConfigurer(p.key2);
            this.key2Label = new JLabel(Resources.getString("Editor.Pivot.keyboard_command_2"));
            this.controls.add(this.key2Label);
            this.controls.add(this.key2.getControls());
            this.angle2Label = new JLabel(Resources.getString("Editor.Pivot.angle_2"));
            this.angle2 = new DoubleConfigurer(p.angle2);
            this.controls.add(this.angle2Label);
            this.controls.add(this.angle2.getControls());
            this.angle.getControls().setVisible(p.fixedAngle);
            this.angleLabel.setVisible(p.fixedAngle);
            this.command2.getControls().setVisible(p.fixedAngle);
            this.command2Label.setVisible(p.fixedAngle);
            this.key2.getControls().setVisible(p.fixedAngle);
            this.key2Label.setVisible(p.fixedAngle);
            this.angle2.getControls().setVisible(p.fixedAngle);
            this.angle2Label.setVisible(p.fixedAngle);
            this.fixedAngle.addPropertyChangeListener(evt -> {
                this.angle.getControls().setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.angle2.getControls().setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.angleLabel.setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.angle2Label.setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.command2.getControls().setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.command2Label.setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.key2.getControls().setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
                this.key2Label.setVisible(Boolean.TRUE.equals(this.fixedAngle.getValue()));
            });
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.command.getValueString()).append(this.key.getValueString()).append(this.xOff.getValueString()).append(this.yOff.getValueString()).append(Boolean.TRUE.equals(this.fixedAngle.getValue())).append(this.angle.getValueString()).append(this.desc.getValueString()).append(this.command2.getValueString()).append(this.key2.getValueString()).append(this.angle2.getValueString());
            return Pivot.ID + se.getValue();
        }
    }
}

