/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.properties.EnumeratedPropertyPrompt;
import VASSAL.build.module.properties.IncrementProperty;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySetter;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.properties.RemoteEnumeratedPropertyPrompt;
import VASSAL.build.module.properties.RemoteIncrementProperty;
import VASSAL.build.module.properties.RemotePropertyChanger;
import VASSAL.build.module.properties.RemotePropertyPrompt;
import VASSAL.build.module.properties.RemotePropertySetter;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DynamicKeyCommandListConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.GlobalCommandTargetConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.counters.GlobalSetter;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.RangeFilter;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;

public class SetPieceProperty
extends DynamicProperty
implements RecursionLimiter.Loopable {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String ID = "setpieceprop;";
    protected String description;
    protected GlobalCommandTarget target;
    protected GlobalSetter globalSetter;
    protected PropertyExpression propertiesFilter;
    protected boolean restrictRange;
    protected boolean fixedRange;
    protected int range;
    protected String rangeProperty = "";
    protected boolean overrideConstraints;
    protected Decorator dec;
    private String propName;
    private RemotePropertyChanger changer = null;
    private String newValue = null;
    private boolean cancelled;
    private DynamicProperty currentDPTarget = null;

    public SetPieceProperty() {
        this(ID, null);
    }

    public SetPieceProperty(String type, GamePiece p) {
        super(type, p);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.SetPieceProperty.trait_description", this.key, this.description) + this.getCommandsList();
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.SetPieceProperty.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public void mySetType(String s) {
        if (this.target == null) {
            this.target = new GlobalCommandTarget(GlobalCommandTarget.GKCtype.COUNTER);
        }
        if (this.globalSetter == null) {
            this.globalSetter = new GlobalSetter(this);
        }
        if (this.propertiesFilter == null) {
            this.propertiesFilter = new PropertyExpression();
        }
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        sd.nextToken();
        this.key = sd.nextToken("name");
        this.decodeConstraints(sd.nextToken(""));
        this.keyCommandListConfig.setValue(sd.nextToken(""));
        this.keyCommands = this.keyCommandListConfig.getListValue().toArray(new DynamicProperty.DynamicKeyCommand[0]);
        this.menuCommands = (KeyCommand[])Arrays.stream(this.keyCommands).filter(kc -> !StringUtils.isEmpty((CharSequence)kc.getName())).toArray(KeyCommand[]::new);
        this.description = sd.nextToken("");
        this.target.decode(sd.nextToken(""));
        this.target.setGKCtype(GlobalCommandTarget.GKCtype.COUNTER);
        this.target.setCurPiece(this);
        this.propertiesFilter.setExpression(sd.nextToken(""));
        this.restrictRange = sd.nextBoolean(false);
        this.range = sd.nextInt(1);
        this.fixedRange = sd.nextBoolean(true);
        this.rangeProperty = sd.nextToken("");
        this.globalSetter.setSelectFromDeckExpression(sd.nextToken("-1"));
        this.overrideConstraints = sd.nextBoolean(false);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.key);
        se.append(this.encodeConstraints());
        se.append(this.keyCommandListConfig.getValueString());
        se.append(this.description);
        se.append(this.target.encode());
        se.append(this.propertiesFilter);
        se.append(this.restrictRange);
        se.append(this.range);
        se.append(this.fixedRange);
        se.append(this.rangeProperty);
        se.append(this.globalSetter.getSelectFromDeckExpression());
        se.append(this.overrideConstraints);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetState(String state) {
    }

    @Override
    public Object getProperty(Object key) {
        if ("KeyCommands".equals(key)) {
            return this.getKeyCommands();
        }
        if ("Inner".equals(key)) {
            return this.piece;
        }
        if ("Outer".equals(key)) {
            return this.dec;
        }
        if ("visibleState".equals(key)) {
            return this.myGetState() + String.valueOf(this.piece.getProperty(key));
        }
        return this.piece.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("KeyCommands".equals(key)) {
            return this.getProperty(key);
        }
        if ("Inner".equals(key)) {
            return this.getProperty(key);
        }
        if ("Outer".equals(key)) {
            return this.getProperty(key);
        }
        if ("visibleState".equals(key)) {
            return this.getProperty(key);
        }
        return this.piece.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Inner".equals(key)) {
            this.setInner((GamePiece)val);
        } else if ("Outer".equals(key)) {
            this.dec = (Decorator)val;
        } else {
            this.piece.setProperty(key, val);
        }
    }

    @Override
    public List<String> getPropertyNames() {
        return Collections.emptyList();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SetPieceProperty.html");
    }

    public Command makeSetTargetCommand(GamePiece p) {
        Command comm = new NullCommand();
        if (this.cancelled) {
            return comm;
        }
        while (p instanceof Decorator) {
            DynamicProperty currentDP;
            if (p.getClass() == DynamicProperty.class && this.propName.equals((currentDP = (DynamicProperty)p).getKey())) {
                if (this.newValue == null || !(this.changer instanceof PropertyPrompt)) {
                    this.currentDPTarget = currentDP;
                    String userValue = this.changer.getNewValue(currentDP, this, SetPieceProperty.getOutermost(this));
                    if (userValue == null) {
                        this.cancelled = true;
                        return comm;
                    }
                    this.newValue = userValue;
                }
                ChangeTracker ct = new ChangeTracker(currentDP);
                currentDP.setValue(this.newValue);
                comm = comm.append(ct.getChangeCommand());
                break;
            }
            p = ((Decorator)p).getInner();
        }
        return comm;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        GamePiece outer = SetPieceProperty.getOutermost(this);
        this.globalSetter.setPropertySource(outer);
        Command comm = new NullCommand();
        for (DynamicProperty.DynamicKeyCommand keyCommand : this.keyCommands) {
            if (!keyCommand.matches(stroke)) continue;
            this.propName = new FormattedString(this.key).getText((PropertySource)SetPieceProperty.getOutermost(this), (Auditable)this, "Editor.SetPieceProperty.property_name");
            this.changer = this.createRemotePropertyChanger(keyCommand.propChanger);
            this.newValue = null;
            this.cancelled = false;
            AuditTrail audit = AuditTrail.create((Auditable)this, this.propertiesFilter.getExpression(), Resources.getString("Editor.SetPieceProperty.matching_properties"));
            PieceFilter filter = this.propertiesFilter.getFilter((PropertySource)outer, (Auditable)this, audit);
            if (this.restrictRange) {
                int r = this.range;
                if (!this.fixedRange) {
                    String rangeValue = (String)SetPieceProperty.getOutermost(this).getProperty(this.rangeProperty);
                    try {
                        r = Integer.parseInt(rangeValue);
                    }
                    catch (NumberFormatException e) {
                        SetPieceProperty.reportDataError(this, Resources.getString("Error.non_number_error"), "range[" + this.rangeProperty + "]=" + rangeValue, e);
                    }
                }
                filter = new BooleanAndPieceFilter(filter, new RangeFilter(this.getMap(), this.getPosition(), r));
            }
            comm = comm.append(this.globalSetter.apply(Map.getMapList().toArray(new Map[0]), filter, this.target, audit));
            return comm;
        }
        return comm;
    }

    public RemotePropertyChanger createRemotePropertyChanger(PropertyChanger changer) {
        if (changer instanceof PropertySetter) {
            return new RemotePropertySetter((PropertySetter)changer);
        }
        if (changer instanceof IncrementProperty) {
            return new RemoteIncrementProperty((IncrementProperty)changer);
        }
        if (changer instanceof EnumeratedPropertyPrompt) {
            return new RemoteEnumeratedPropertyPrompt((EnumeratedPropertyPrompt)changer);
        }
        if (changer instanceof PropertyPrompt) {
            return new RemotePropertyPrompt((PropertyPrompt)changer);
        }
        return null;
    }

    @Override
    public int getMaximumValue() {
        return this.overrideConstraints || this.currentDPTarget == null ? super.getMaximumValue() : this.currentDPTarget.getMaximumValue();
    }

    @Override
    public int getMinimumValue() {
        return this.overrideConstraints || this.currentDPTarget == null ? super.getMinimumValue() : this.currentDPTarget.getMinimumValue();
    }

    @Override
    public boolean isNumeric() {
        return this.overrideConstraints || this.currentDPTarget == null ? super.isNumeric() : this.currentDPTarget.isNumeric();
    }

    @Override
    public boolean isWrap() {
        return this.overrideConstraints || this.currentDPTarget == null ? super.isWrap() : this.currentDPTarget.isWrap();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof SetPieceProperty)) {
            return false;
        }
        SetPieceProperty c = (SetPieceProperty)o;
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.encodeConstraints(), c.encodeConstraints())) {
            return false;
        }
        if (!Objects.equals(this.keyCommandListConfig.getValueString(), c.keyCommandListConfig.getValueString())) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.target, c.target)) {
            return false;
        }
        if (!Objects.equals(this.propertiesFilter, c.propertiesFilter)) {
            return false;
        }
        if (!Objects.equals(this.restrictRange, c.restrictRange)) {
            return false;
        }
        if (!Objects.equals(this.range, c.range)) {
            return false;
        }
        if (!Objects.equals(this.fixedRange, c.fixedRange)) {
            return false;
        }
        if (!Objects.equals(this.rangeProperty, c.rangeProperty)) {
            return false;
        }
        if (!Objects.equals(this.overrideConstraints, c.overrideConstraints)) {
            return false;
        }
        return Objects.equals(this.globalSetter.getSelectFromDeckExpression(), c.globalSetter.getSelectFromDeckExpression());
    }

    protected static class Ed
    implements PieceEditor {
        protected StringConfigurer descConfig;
        protected FormattedExpressionConfigurer nameConfig;
        protected BooleanConfigurer overrideConfig;
        protected JLabel numericLabel;
        protected BooleanConfigurer numericConfig;
        protected JLabel minLabel;
        protected IntConfigurer minConfig;
        protected JLabel maxLabel;
        protected IntConfigurer maxConfig;
        protected JLabel wrapLabel;
        protected BooleanConfigurer wrapConfig;
        protected DynamicKeyCommandListConfigurer keyCommandListConfig;
        protected TranslatingStringEnumConfigurer levelConfig;
        protected FormattedExpressionConfigurer attachNameConfig;
        protected FormattedExpressionConfigurer attachIndexConfig;
        protected TraitConfigPanel controls;
        protected GlobalCommandTargetConfigurer targetConfig;
        protected PropertyExpressionConfigurer propertyMatch;
        protected PropertyExpressionConfigurer clearMatchingMatch;
        protected MassKeyCommand.DeckPolicyConfig deckPolicy;
        protected BooleanConfigurer restrictRange;
        protected BooleanConfigurer fixedRange;
        protected JLabel fixedRangeLabel;
        protected IntConfigurer range;
        protected JLabel rangeLabel;
        protected StringConfigurer rangeProperty;
        protected JLabel rangePropertyLabel;
        protected JLabel targetLabel;
        protected JLabel propertyLabel;
        protected JLabel deckLabel;
        protected JLabel restrictLabel;

        public Ed(SetPieceProperty m) {
            this.keyCommandListConfig = new DynamicKeyCommandListConfigurer(null, Resources.getString("Editor.DynamicProperty.commands"), m);
            this.keyCommandListConfig.setValue(new ArrayList<DynamicProperty.DynamicKeyCommand>(Arrays.asList(m.keyCommands)));
            this.controls = new TraitConfigPanel();
            this.descConfig = new StringConfigurer(m.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descConfig);
            this.nameConfig = new FormattedExpressionConfigurer(m.getKey(), m);
            this.nameConfig.setHintKey("Editor.SetPieceProperty.property_name_hint");
            this.controls.add("Editor.SetPieceProperty.property_name", (Configurer)this.nameConfig);
            this.overrideConfig = new BooleanConfigurer(m.overrideConstraints);
            this.controls.add("Editor.SetPieceProperty.override_constraints", (Configurer)this.overrideConfig);
            this.numericLabel = new JLabel(Resources.getString("Editor.DynamicProperty.is_numeric"));
            this.numericConfig = new BooleanConfigurer(m.isNumeric());
            this.controls.add(this.numericLabel, (Configurer)this.numericConfig);
            this.minLabel = new JLabel(Resources.getString("Editor.GlobalProperty.minimum_value"));
            this.minConfig = new IntConfigurer(m.getMinimumValue());
            this.controls.add(this.minLabel, (Configurer)this.minConfig);
            this.maxLabel = new JLabel(Resources.getString("Editor.GlobalProperty.maximum_value"));
            this.maxConfig = new IntConfigurer(m.getMaximumValue());
            this.controls.add(this.maxLabel, (Configurer)this.maxConfig);
            this.wrapLabel = new JLabel(Resources.getString("Editor.DynamicProperty.wrap"));
            this.wrapConfig = new BooleanConfigurer(m.isWrap());
            this.controls.add(this.wrapLabel, (Configurer)this.wrapConfig);
            this.targetConfig = new GlobalCommandTargetConfigurer(m.target, m);
            this.targetLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.pre_select"));
            this.controls.add(this.targetLabel, (Configurer)this.targetConfig);
            this.propertyMatch = new PropertyExpressionConfigurer(m.propertiesFilter, (GamePiece)m);
            this.propertyLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.matching_properties"));
            this.controls.add(this.propertyLabel, (Configurer)this.propertyMatch);
            this.deckPolicy = new MassKeyCommand.DeckPolicyConfig(false, m);
            this.deckPolicy.setValue(m.globalSetter.getSelectFromDeckExpression());
            this.deckLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.deck_policy"));
            this.controls.add(this.deckLabel, (Configurer)this.deckPolicy);
            this.restrictRange = new BooleanConfigurer(m.restrictRange);
            this.restrictLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.restrict_range"));
            this.controls.add(this.restrictLabel, (Configurer)this.restrictRange);
            this.fixedRange = new BooleanConfigurer(m.fixedRange);
            this.fixedRangeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.fixed_range"));
            this.controls.add(this.fixedRangeLabel, (Configurer)this.fixedRange);
            this.range = new IntConfigurer(m.range);
            this.rangeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.range"));
            this.controls.add(this.rangeLabel, (Configurer)this.range);
            this.rangeProperty = new StringConfigurer(m.rangeProperty);
            this.rangeProperty.setHintKey("Editor.GlobalKeyCommand.range_property_hint");
            this.rangePropertyLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.range_property"));
            this.controls.add(this.rangePropertyLabel, (Configurer)this.rangeProperty);
            this.controls.add("Editor.DynamicProperty.key_commands", (Configurer)this.keyCommandListConfig);
            PropertyChangeListener nl = evt -> {
                boolean isOverride = this.overrideConfig.booleanValue();
                boolean isNumeric = this.numericConfig.booleanValue();
                this.numericLabel.setVisible(isOverride);
                this.numericConfig.getControls().setVisible(isOverride);
                this.minConfig.getControls().setVisible(isOverride && isNumeric);
                this.minLabel.setVisible(isOverride && isNumeric);
                this.maxConfig.getControls().setVisible(isOverride && isNumeric);
                this.maxLabel.setVisible(isOverride && isNumeric);
                this.wrapConfig.getControls().setVisible(isOverride && isNumeric);
                this.wrapLabel.setVisible(isOverride && isNumeric);
                this.keyCommandListConfig.repack();
            };
            this.overrideConfig.addPropertyChangeListener(nl);
            this.numericConfig.addPropertyChangeListener(nl);
            this.numericConfig.fireUpdate();
            PropertyChangeListener pl = evt -> {
                boolean isRange = Boolean.TRUE.equals(this.restrictRange.getValue());
                boolean isFixed = Boolean.TRUE.equals(this.fixedRange.getValue());
                this.range.getControls().setVisible(isRange && isFixed);
                this.rangeLabel.setVisible(isRange && isFixed);
                this.fixedRange.getControls().setVisible(isRange);
                this.fixedRangeLabel.setVisible(isRange);
                this.rangeProperty.getControls().setVisible(isRange && !isFixed);
                this.rangePropertyLabel.setVisible(isRange && !isFixed);
                Decorator.repack(this.range);
            };
            this.restrictRange.addPropertyChangeListener(pl);
            this.fixedRange.addPropertyChangeListener(pl);
            this.fixedRange.fireUpdate();
            pl.propertyChange(null);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        protected String encodeConstraints() {
            return new SequenceEncoder(',').append(this.numericConfig.getValueString()).append(this.minConfig.getValueString()).append(this.maxConfig.getValueString()).append(this.wrapConfig.getValueString()).getValue();
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString());
            se.append(this.encodeConstraints());
            se.append(this.keyCommandListConfig.getValueString());
            se.append(this.descConfig.getValueString());
            se.append(this.targetConfig.getValueString());
            se.append(this.propertyMatch.getValueString());
            se.append(this.restrictRange.getValueString());
            se.append(this.range.getValueString());
            se.append(this.fixedRange.getValueString());
            se.append(this.rangeProperty.getValueString());
            se.append(this.deckPolicy.getValueString());
            se.append(this.overrideConfig.getValueString());
            return SetPieceProperty.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

