/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.AbstractFolder;
import VASSAL.build.Buildable;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.menu.MenuScroller;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class UsePrototype
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "prototype;";
    private String prototypeName;
    private String lastCachedPrototype;
    private GamePiece prototype;
    private PropertySource properties;
    private String type;

    public UsePrototype() {
        this(ID, null);
    }

    public UsePrototype(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.UsePrototype.trait_description", this.prototypeName);
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.UsePrototype.trait_description");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("UsePrototype.html");
    }

    @Override
    public void mySetType(String type) {
        this.type = type;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type.substring(ID.length()), ';');
        this.prototypeName = st.nextToken("");
        if (st.hasMoreTokens()) {
            final Properties p = new Properties();
            SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), ',');
            while (st2.hasMoreTokens()) {
                SequenceEncoder.Decoder st3 = new SequenceEncoder.Decoder(st2.nextToken(), '=');
                if (!st3.hasMoreTokens()) continue;
                String key = st3.nextToken();
                if (!st3.hasMoreTokens()) continue;
                String value = st3.nextToken();
                p.setProperty(key, value);
            }
            this.properties = new PropertySource(){
                final /* synthetic */ UsePrototype this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object getProperty(Object key) {
                    return p.getProperty(String.valueOf(key));
                }

                @Override
                public Object getLocalizedProperty(Object key) {
                    return this.getProperty(key);
                }
            };
        }
        this.lastCachedPrototype = null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    protected KeyCommand[] getKeyCommands() {
        return (KeyCommand[])this.getExpandedInner().getProperty("KeyCommands");
    }

    @Override
    public void setInner(GamePiece p) {
        super.setInner(p);
        this.lastCachedPrototype = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buildPrototype() {
        PrototypeDefinition def = PrototypesContainer.getPrototype(this.prototypeName);
        if (def != null) {
            try {
                RecursionLimiter.startExecution(this);
                GamePiece expandedPrototype = def.getPiece(this.properties);
                String type = expandedPrototype.getType();
                if (type.equals(this.lastCachedPrototype)) return;
                this.lastCachedPrototype = type.intern();
                this.prototype = PieceCloner.getInstance().clonePiece(expandedPrototype);
                Decorator outer = (Decorator)UsePrototype.getInnermost(this.prototype).getProperty("Outer");
                if (outer != null) {
                    outer.setInner(this.piece);
                    this.prototype.setProperty("Outer", this);
                    return;
                }
                this.prototype = null;
                return;
            }
            catch (RecursionLimitException e) {
                RecursionLimiter.infiniteLoop(e);
                this.prototype = null;
                return;
            }
            finally {
                RecursionLimiter.endExecution();
            }
        } else {
            this.prototype = null;
        }
    }

    public GamePiece getExpandedInner() {
        this.buildPrototype();
        return this.prototype != null ? this.prototype : this.piece;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        return this.type;
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        return this.getExpandedInner().keyEvent(stroke);
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getExpandedInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getExpandedInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getExpandedInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getExpandedInner().getShape();
    }

    public String getPrototypeName() {
        return this.prototypeName;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof UsePrototype)) {
            return false;
        }
        UsePrototype c = (UsePrototype)o;
        return Objects.equals(this.prototypeName, c.prototypeName);
    }

    @Override
    public PieceEditor getEditor() {
        return new Editor(this);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.prototypeName);
    }

    public static class Editor
    implements PieceEditor {
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer nameConfig;

        public Editor(UsePrototype up) {
            this.nameConfig = new StringConfigurer(up.type.substring(UsePrototype.ID.length()));
            this.controls.add("Editor.UsePrototype.prototype_name", (Configurer)this.nameConfig, "split 2");
            JButton selectButton = new JButton(Resources.getString("General.select"));
            selectButton.addActionListener(e -> this.select());
            this.controls.add((Component)selectButton, "growx 0");
        }

        private JMenu subMenu(AbstractFolder target) {
            JMenu menu = new JMenu(target.getConfigureName());
            for (Buildable b : target.getBuildables()) {
                if (b instanceof AbstractFolder) {
                    JMenu sub = this.subMenu((AbstractFolder)b);
                    if (sub.getItemCount() <= 0) continue;
                    menu.add(sub);
                    continue;
                }
                if (!(b instanceof PrototypeDefinition)) continue;
                JMenuItem item = new JMenuItem(((PrototypeDefinition)b).getConfigureName());
                item.addActionListener(ev -> this.nameConfig.setValue(((PrototypeDefinition)b).getConfigureName()));
                menu.add(item);
            }
            return menu;
        }

        private void select() {
            PrototypesContainer protos = PrototypesContainer.findInstance();
            if (protos == null) {
                return;
            }
            JPopupMenu protoMenu = new JPopupMenu();
            for (Buildable b : protos.getBuildables()) {
                if (b instanceof AbstractFolder) {
                    JMenu menu = this.subMenu((AbstractFolder)b);
                    if (menu.getItemCount() <= 0) continue;
                    protoMenu.add(menu);
                    continue;
                }
                if (!(b instanceof PrototypeDefinition)) continue;
                JMenuItem item = new JMenuItem(((PrototypeDefinition)b).getConfigureName());
                item.addActionListener(ev -> this.nameConfig.setValue(((PrototypeDefinition)b).getConfigureName()));
                protoMenu.add(item);
            }
            MenuScroller.setScrollerFor(protoMenu, 20, 100);
            protoMenu.show(this.getControls(), 0, 0);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            return UsePrototype.ID + this.nameConfig.getValueString();
        }
    }
}

