/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GameModuleAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GameModuleAction.class);
    protected Component comp;
    protected boolean actionCancelled;
    protected List<Runnable> actions = new ArrayList<Runnable>();

    public GameModuleAction(String name, Component comp) {
        super(name);
        this.comp = comp;
    }

    protected String getMessage(Exception err) {
        Object msg = err.getClass().getSimpleName();
        if (err.getMessage() != null) {
            msg = (String)msg + ":  " + err.getMessage();
        }
        return msg;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.performAction(e);
            if (!this.actionCancelled) {
                this.runActions();
            }
        }
        catch (Exception e1) {
            this.reportError(e1);
        }
    }

    protected abstract void performAction(ActionEvent var1) throws Exception;

    protected void reportError(Exception ex) {
        logger.error("", (Throwable)ex);
        JOptionPane.showMessageDialog(this.comp, this.getMessage(ex));
    }

    public void addAction(Runnable r) {
        this.actions.add(r);
    }

    protected void runActions() {
        for (Runnable r : this.actions) {
            r.run();
        }
    }
}

