/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.property;

import VASSAL.property.Property;
import VASSAL.property.PropertyListener;
import VASSAL.property.PropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConcurrentPropertySupport
implements PropertySupport {
    protected final CopyOnWriteArrayList<PropertyListener<Object>> listeners = new CopyOnWriteArrayList();
    protected final ConcurrentMap<Property<?>, List<PropertyListener<?>>> plisteners = new ConcurrentHashMap();

    @Override
    public void addPropertyListener(PropertyListener<Object> l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(l);
    }

    @Override
    public void removePropertyListener(PropertyListener<Object> l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(l);
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public List<PropertyListener<Object>> getPropertyListeners() {
        return this.listeners.isEmpty() ? Collections.emptyList() : new ArrayList<PropertyListener<Object>>(this.listeners);
    }

    @Override
    public <T> void addPropertyListener(Property<T> prop, PropertyListener<? super T> l) {
        CopyOnWriteArrayList<PropertyListener<T>> empty = new CopyOnWriteArrayList<PropertyListener<T>>();
        CopyOnWriteArrayList<PropertyListener<T>> list = this.plisteners.putIfAbsent(prop, empty);
        if (list == null) {
            list = empty;
        }
        list.add(l);
    }

    @Override
    public <T> void removePropertyListener(Property<T> prop, PropertyListener<? super T> l) {
        List list = (List)this.plisteners.get(prop);
        if (list != null) {
            list.remove(l);
        }
    }

    @Override
    public <T> List<PropertyListener<? super T>> getPropertyListeners(Property<T> prop) {
        List list = (List)this.plisteners.get(prop);
        return list == null || list.isEmpty() ? Collections.emptyList() : new ArrayList(list);
    }

    @Override
    public <T> boolean hasListeners(Property<T> prop) {
        List list = (List)this.plisteners.get(prop);
        return list != null && !list.isEmpty();
    }

    @Override
    public <T> void fireChanged(Object src, Property<T> prop, T oldVal, T newVal) {
        if (oldVal == newVal || oldVal != null && oldVal.equals(newVal)) {
            return;
        }
        for (PropertyListener<Object> l : this.listeners) {
            l.propertyChanged(src, prop, oldVal, newVal);
        }
        List list = (List)this.plisteners.get(prop);
        if (list != null) {
            for (PropertyListener l : list) {
                l.propertyChanged(src, prop, oldVal, newVal);
            }
        }
    }
}

