/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRCUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Logger log = LoggerFactory.getLogger(CRCUtils.class);

    public static long getCRC(List<File> files) {
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[8192];
        for (File file : files) {
            try {
                CRCUtils.buildCRC(file, crc, buffer);
            }
            catch (IOException e) {
                log.error("Error reading file " + file.getAbsolutePath() + " to generate CRC: " + e.getMessage());
                return 0L;
            }
        }
        return crc.getValue();
    }

    private static void buildCRC(File file, CRC32 crc, byte[] buffer) throws IOException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            CRCUtils.buildCRC(in, crc, buffer);
        }
    }

    private static void buildCRC(InputStream in, CRC32 crc, byte[] buffer) throws IOException {
        int count;
        while ((count = in.read(buffer)) >= 0) {
            crc.update(buffer, 0, count);
        }
    }
}

