/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SourceOpDiskCacheBitmapImpl
extends AbstractTileOpImpl
implements SourceOp {
    protected final String name;
    protected final int hash;
    protected final int tileX;
    protected final int tileY;
    protected double scale;
    protected final ImageTileSource tileSrc;

    public SourceOpDiskCacheBitmapImpl(String name, int tileX, int tileY, double scale) {
        this(name, tileX, tileY, scale, GameModule.getGameModule().getImageTileSource());
    }

    public SourceOpDiskCacheBitmapImpl(String name, int tileX, int tileY, double scale, ImageTileSource tileSrc) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (tileX < 0) {
            throw new IllegalArgumentException();
        }
        if (tileY < 0) {
            throw new IllegalArgumentException();
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (tileSrc == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.tileX = tileX;
        this.tileY = tileY;
        this.scale = scale;
        this.tileSrc = tileSrc;
        this.hash = new HashCodeBuilder().append((Object)name).append(tileX).append(tileY).append(scale).toHashCode();
    }

    @Override
    public List<VASSAL.tools.opcache.Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws ImageIOException {
        return this.tileSrc.getTile(this.name, this.tileX, this.tileY, this.scale);
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.getImageSize();
        }
    }

    protected Dimension getImageSize() {
        try {
            return this.tileSrc.getTileSize(this.name, this.tileX, this.tileY, this.scale);
        }
        catch (ImageIOException e) {
            if (!Op.handleException(e)) {
                ErrorDialog.bug(e);
            }
            return new Dimension();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SourceOpDiskCacheBitmapImpl s = (SourceOpDiskCacheBitmapImpl)o;
        return this.name.equals(s.name) && this.tileX == s.tileX && this.tileY == s.tileY && this.scale == s.scale;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ",tileX=" + this.tileX + ",tileY=" + this.tileY + ",scale=" + this.scale + "]";
    }
}

