/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceTileOpSVGImpl;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.List;

public class SourceOpSVGImpl
extends AbstractTiledOpImpl
implements SourceOp,
SVGOp {
    protected final String name;
    protected final int hash;
    protected final DataArchive archive;

    public SourceOpSVGImpl(String name) {
        this(name, GameModule.getGameModule().getDataArchive());
    }

    public SourceOpSVGImpl(String name, DataArchive archive) {
        if (name == null || name.length() == 0 || archive == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.archive = archive;
        this.hash = name.hashCode() ^ archive.hashCode();
    }

    @Override
    public List<VASSAL.tools.opcache.Op<?>> getSources() {
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public BufferedImage eval() throws ImageIOException {
        try (InputStream in = this.archive.getInputStream(this.name);){
            BufferedImage bufferedImage;
            try (BufferedInputStream bin = new BufferedInputStream(in);){
                SVGRenderer renderer = new SVGRenderer(this.archive.getURL(this.name), (InputStream)bin);
                bufferedImage = renderer.render();
            }
            return bufferedImage;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new ImageNotFoundException(this.name, (Throwable)e);
        }
        catch (IOException e) {
            throw new ImageIOException(this.name, (Throwable)e);
        }
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.getImageSize();
        }
    }

    protected Dimension getImageSize() {
        Dimension dimension;
        block13: {
            InputStream in = this.archive.getInputStream(this.name);
            try {
                dimension = SVGImageUtils.getImageSize(this.name, in);
                if (in == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ImageIOException e) {
                        throw e;
                    }
                    catch (FileNotFoundException | NoSuchFileException e) {
                        throw new ImageNotFoundException(this.name, (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new ImageIOException(this.name, (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!Op.handleException(e)) {
                        ErrorDialog.bug(e);
                    }
                    return new Dimension();
                }
            }
            in.close();
        }
        return dimension;
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new SourceTileOpSVGImpl(this, tileX, tileY);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SourceOpSVGImpl s = (SourceOpSVGImpl)o;
        return this.archive == s.archive && this.name.equals(s.name);
    }

    public int hashCode() {
        return this.hash;
    }
}

