/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.AttachmentManager;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.counters.Attachment;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.tools.BugUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    Iterator<String> tok;
    String commandLine;
    int commandIndex = 0;
    List<String> commands = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(Console.class);

    private void show(String s) {
        GameModule.getGameModule().warn(s);
    }

    private boolean matches(String s1, String s2) {
        return this.matches(s1, s2, 2);
    }

    private boolean matches(String s1, String s2, int min) {
        if (s2.isEmpty() || s2.length() > s1.length() || s2.length() < min && s1.length() > s2.length()) {
            return false;
        }
        if (s2.length() < min) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.substring(0, s2.length()).equalsIgnoreCase(s2);
    }

    private String nextString(String def) {
        return this.tok.hasNext() ? this.tok.next() : def;
    }

    private int nextInt(int def) {
        try {
            return this.tok.hasNext() ? Integer.parseInt(this.tok.next()) : def;
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private void browseFileOrFolder(File file) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(file);
        }
        catch (IOException e) {
            log.error("File Not Found", (Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            log.error("Illegal argument", (Throwable)iae);
        }
    }

    private boolean doErrorLog() {
        String option = this.nextString("");
        if (this.matches("show", option)) {
            String errorLog = BugUtils.getErrorLog();
            String delims2 = "[\n]+";
            String[] lines = errorLog.split("[\n]+");
            if (lines.length > 0) {
                int start;
                int end = lines.length - 1;
                for (int line = start = (linesToShow = this.nextInt(0)) <= 0 ? 0 : Math.max(0, end - linesToShow + 1); line <= end; ++line) {
                    this.show(lines[line]);
                }
            }
        } else if (this.matches("write", option)) {
            int where = this.commandLine.toLowerCase().indexOf("write");
            if (where > 0 && this.commandLine.length() > where + 6) {
                log.info(this.commandLine.substring(where + 6));
            }
        } else if (this.matches("folder", option)) {
            this.browseFileOrFolder(Info.getConfDir());
        } else if (this.matches("noecho", option)) {
            GameModule.setErrorLogToChat(false);
            this.show("Errorlog Echo: OFF");
        } else if (this.matches("echo", option)) {
            GameModule.setErrorLogToChat(true);
            this.show("Errorlog Echo: ON");
        } else if (this.matches("open", option)) {
            this.browseFileOrFolder(Info.getErrorLogPath());
        } else if (this.matches("wipe", option)) {
            File errorLog = Info.getErrorLogPath();
            try {
                Files.newOutputStream(errorLog.toPath(), new OpenOption[0]).close();
                this.show("Wiped errorlog");
            }
            catch (IOException e) {
                this.show("Failed to wipe errorlog");
            }
        } else if (this.matches("?", option) || this.matches("help", option) || "".equals(option)) {
            this.show("Usage:");
            this.show("  /errorlog echo         - Echoes new errorlog info in chat log");
            this.show("  /errorlog folder       - Opens folder containing errorlog");
            this.show("  /errorlog noecho       - Disables echoing of errorlog info in chat log");
            this.show("  /errorlog open         - Opens errorlog in OS");
            this.show("  /errorlog show [n]     - Show last n lines of errorlog");
            this.show("  /errorlog wipe         - Wipe the errorlog file");
            this.show("  /errorlog write [text] - Write text into the errorlog file");
        } else {
            this.show("Unknown command.");
            this.show("Use '/errorlog help' for usage info.");
        }
        return true;
    }

    private boolean doAttachments() {
        AttachmentManager am = GameModule.getGameModule().getGameState().getAttachmentManager();
        String compareName = "";
        boolean useSelected = false;
        boolean activeOnly = false;
        boolean autoOnly = false;
        boolean nonAutoOnly = false;
        String option = this.nextString("");
        if (this.matches("?", option) || this.matches("help", option)) {
            this.show("Usage:");
            this.show("  /attachments [attachname] [selected] [active] [auto] [nonauto] - show current attachments");
            this.show("  [attachname] - Optional, if included, only show attachments with name attachname");
            this.show("  [selected]   - Optional, if included, only show attachments for currently selected pieces");
            this.show("  [active]     - Optional, if included, only show active attachments");
            this.show("  [auto]       - Optional, if included, only show auto attachments");
            this.show("  [nonauto]    - Optional, if included, only show non-auto attachments");
            return true;
        }
        while (!option.isEmpty()) {
            if (this.matches("selected", option, 8) && !useSelected) {
                useSelected = true;
            } else if (this.matches("active", option, 5) && !activeOnly) {
                activeOnly = true;
            } else if (this.matches("auto", option, 4) && !autoOnly) {
                autoOnly = true;
            } else if (this.matches("nonauto", option, 7) && !nonAutoOnly) {
                nonAutoOnly = true;
            } else {
                compareName = option;
            }
            option = this.nextString("");
        }
        if (autoOnly && nonAutoOnly) {
            autoOnly = false;
            nonAutoOnly = false;
        }
        StringBuilder sb = new StringBuilder();
        if (compareName.isEmpty()) {
            sb.append("All Attachments");
        } else {
            sb.append("Attachment ").append(compareName);
        }
        sb.append(useSelected ? ", Selected units only" : ", All units").append(activeOnly ? ", Active only" : "").append(autoOnly ? ", Auto only" : "").append(nonAutoOnly ? ", Non-auto only" : "").append(':');
        this.show(sb.toString());
        if (useSelected) {
            for (GamePiece piece : KeyBuffer.getBuffer().asList()) {
                for (GamePiece a : Decorator.getDecorators(piece, Attachment.class)) {
                    Attachment attach = (Attachment)a;
                    if (!compareName.isEmpty() && !compareName.equals(attach.getAttachName()) || activeOnly && attach.getAttachCount() <= 0 || autoOnly && !attach.isAutoAttach() || nonAutoOnly && attach.isAutoAttach()) continue;
                    this.show(this.describeAttachment(attach));
                }
            }
        } else {
            for (String attachName : am.getAttachmentList()) {
                if (!compareName.isEmpty() && !compareName.equals(attachName)) continue;
                String heading = "Attachment [" + attachName + "] used by " + am.getAttachmentList(attachName).size() + " pieces:";
                boolean headingShown = false;
                if (!activeOnly) {
                    this.show(heading);
                    headingShown = true;
                }
                for (Attachment attach : am.getAttachmentList(attachName)) {
                    if (!compareName.isEmpty() && !compareName.equals(attach.getAttachName()) || activeOnly && attach.getAttachCount() <= 0 || autoOnly && !attach.isAutoAttach() || nonAutoOnly && attach.isAutoAttach()) continue;
                    if (!headingShown) {
                        this.show(heading);
                        headingShown = true;
                    }
                    this.show(".." + this.describeAttachment(attach));
                }
            }
        }
        return true;
    }

    private String describeAttachment(Attachment attach) {
        GamePiece piece = Decorator.getOutermost(attach);
        StringBuilder sb = new StringBuilder();
        sb.append("Piece [").append(piece.getProperty("BasicName")).append("] Attachment [").append(attach.getAttachName()).append("] ").append(attach.isAutoAttach() ? "(auto)" : "").append(" has ").append(attach.getContents().size()).append(" attachments: ");
        for (GamePiece atp : attach.getContents()) {
            sb.append('[').append(atp.getProperty("BasicName")).append(" (").append(atp.getProperty("CurrentMap"));
            if (atp.equals(piece)) {
                sb.append(",self");
            }
            sb.append(")] ");
        }
        return sb.toString();
    }

    private boolean doProperty() {
        boolean useSelected;
        String option;
        String first = this.nextString("");
        if (first.toLowerCase().startsWith("sel")) {
            option = this.nextString("");
            useSelected = true;
        } else {
            option = first;
            useSelected = false;
        }
        String property = this.nextString("");
        if (this.matches("?", option) || this.matches("help", option)) {
            this.show("Usage:");
            this.show("  /property [selected] show [property]        - show global property value");
            this.show("  /property [selected] set [property] [value] - set global property new value");
            this.show("  If optional keyword 'selected' included, show or set is for property of selected piece(s). ");
            this.show("  NOTE: many piece trait properties cannot be set (e.g. 'ObscuredToOthers', 'Invisible'), and the attempt to set them will simply fail quietly. ");
        } else if (this.matches("show", option) || this.matches("set", option)) {
            GameModule gm = GameModule.getGameModule();
            if (useSelected) {
                List<GamePiece> selected = KeyBuffer.getBuffer().asList();
                if (selected != null) {
                    for (GamePiece piece : selected) {
                        Object obj = piece.getProperty(property);
                        if (this.matches("set", option) && obj != null) {
                            String to = this.nextString("");
                            if (obj instanceof String) {
                                piece.setProperty(property, to);
                            } else if (obj instanceof Integer) {
                                piece.setProperty(property, NumberUtils.toInt((String)to));
                            } else if (obj instanceof Boolean) {
                                piece.setProperty(property, BooleanUtils.toBoolean((String)to));
                            }
                        }
                        String val = obj != null ? obj.toString() : "(null)";
                        this.show(piece.getName() + " [" + property + "]: " + val);
                    }
                }
            } else {
                MutableProperty.Impl propValue = (MutableProperty.Impl)gm.getMutableProperty(property);
                if (this.matches("show", option)) {
                    if (propValue != null) {
                        this.show("[" + property + "]: " + propValue.getPropertyValue());
                    } else {
                        String propVal = String.valueOf(gm.getProperty(property));
                        if (propVal != null) {
                            this.show("[" + property + "]: " + propVal);
                        }
                    }
                } else if (this.matches("set", option) && propValue != null) {
                    propValue.setPropertyValue(this.nextString(""));
                    this.show("[" + property + "]: " + propValue.getPropertyValue());
                }
            }
        }
        return true;
    }

    private boolean doHelp() {
        String topic = this.nextString("");
        if (topic.isEmpty()) {
            this.show("VASSAL console commands:");
            this.show("  /errorlog    - commands for opening/clearing/altering errorlog");
            this.show("  /help        - shows list of commands");
            this.show("  /property    - commands for reading/writing global properties");
            this.show("  /attachments - commands to display current attachments");
        } else {
            this.tok = Pattern.compile(" +").splitAsStream("help").iterator();
            if (this.matches("errorlog", topic)) {
                return this.doErrorLog();
            }
            if (this.matches("property", topic)) {
                return this.doProperty();
            }
            if (this.matches("attachments", topic)) {
                return this.doAttachments();
            }
            this.show("Unknown help topic");
        }
        return true;
    }

    public String commandsUp() {
        if (this.commands.isEmpty() || this.commandIndex <= 0) {
            return null;
        }
        --this.commandIndex;
        return this.commands.get(this.commandIndex);
    }

    public String commandsDown() {
        if (this.commands.isEmpty() || this.commandIndex >= this.commands.size() - 1) {
            return null;
        }
        ++this.commandIndex;
        return this.commands.get(this.commandIndex);
    }

    public String commandsTop() {
        if (this.commands.isEmpty()) {
            return null;
        }
        this.commandIndex = 0;
        return this.commands.get(this.commandIndex);
    }

    public String commandsBottom() {
        if (this.commands.isEmpty()) {
            return null;
        }
        this.commandIndex = this.commands.size() - 1;
        return this.commands.get(this.commandIndex);
    }

    public boolean consoleHook(String s, String commandLine, Iterator<String> tok, String command) {
        return false;
    }

    public boolean exec(String s, String style, boolean html_allowed) {
        if (s.isEmpty() || s.charAt(0) != '/') {
            return false;
        }
        if (this.commands.isEmpty() || !s.equals(this.commands.get(Math.max(0, Math.min(this.commands.size() - 1, this.commandIndex))))) {
            this.commands.add(s);
        }
        this.commandIndex = this.commands.size();
        this.commandLine = s.substring(1);
        this.show(s);
        this.tok = Pattern.compile(" +").splitAsStream(this.commandLine).iterator();
        String command = this.nextString("");
        if (this.matches("help", command) || this.matches("?", command)) {
            return this.doHelp();
        }
        if (this.matches("errorlog", command)) {
            return this.doErrorLog();
        }
        VASSAL.command.Logger log = GameModule.getGameModule().getLogger();
        if (log instanceof BasicLogger && (((BasicLogger)log).isMultiPlayer() || GameModule.getGameModule().isMultiPlayer())) {
            this.show("|<b>Console commands that view or affect game state not allowed in multiplayer games.</b>");
            return false;
        }
        if (this.matches("attachments", command)) {
            return this.doAttachments();
        }
        if (this.matches("property", command)) {
            return this.doProperty();
        }
        if (!this.consoleHook(s, this.commandLine, this.tok, command)) {
            this.show("Unknown command. Use /help for list of commands.");
            return false;
        }
        return true;
    }
}

