/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.DieManager;
import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.RollSet;
import VASSAL.preferences.Prefs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class MultiRoll
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JButton rollButton = new JButton("Roll");
    private final JButton canButton = new JButton("Cancel");
    private final JButton emailButton = new JButton("Change Email Address");
    private JDialog me;
    private JPanel serverPanel;
    private JLabel serverLabel;
    private JPanel emailPanel;
    private JLabel emailLabel;
    private JPanel descPanel;
    private JTextField descText;
    private JPanel topPanel;
    private JPanel buttonPanel;
    private JPanel detailPanel;
    protected int lastSelectedRow;
    protected int lastSelectedCol;
    private String description = "";
    protected RollRow[] rollRows;
    public static final int COL_IDX = 0;
    public static final int COL_ROLL = 1;
    public static final int COL_DESC = 2;
    public static final int COL_NDICE = 3;
    public static final int COL_NSIDES = 4;
    public static final int COL_ADD = 5;
    public static final int COL_TOTAL = 6;
    public static final int NUMCOLS = 7;
    public static final int MAX_ROLLS = 10;
    public static final int ROW_HEIGHT = 20;
    public static final int COL1_WIDTH = 31;
    public static final int COL2_WIDTH = 30;
    public static final int COL3_WIDTH = 137;
    public static final int COL4_WIDTH = 50;
    public static final int COL5_WIDTH = 50;
    public static final int COL6_WIDTH = 25;
    public static final int COL7_WIDTH = 35;
    protected DieManager dieManager;
    protected DieRoll[] rolls = new DieRoll[10];
    protected boolean[] useDie = new boolean[10];
    protected String verification = "";
    protected boolean rollCancelled = false;
    protected boolean singleRoll;
    private static final String EMAIL_OFF = "Off";

    protected MultiRoll() {
        super(GameModule.getGameModule().getPlayerWindow());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultiRoll.this.rollCancelled = true;
                MultiRoll.this.setVisible(false);
            }
        });
    }

    public MultiRoll(DieManager d, int dfltNDice, int dfltNSides) {
        this();
        this.dieManager = d;
        for (int i = 0; i < 10; ++i) {
            this.rolls[i] = new DieRoll("", dfltNDice, dfltNSides);
        }
        this.initConfig(dfltNDice, dfltNSides);
        this.clearDie();
    }

    private void clearDie() {
        for (int i = 0; i < 10; ++i) {
            this.useDie[i] = false;
        }
    }

    public boolean wasCancelled() {
        return this.rollCancelled;
    }

    public void setDescription(String s) {
        this.description = s;
        this.descText.setText(s);
    }

    public String getDescription() {
        return this.description;
    }

    public RollSet getRollSet() {
        ArrayList<DieRoll> l = new ArrayList<DieRoll>();
        for (int i = 0; i < 10; ++i) {
            if (!this.useDie[i]) continue;
            l.add(this.rolls[i]);
        }
        DieRoll[] rolls = l.toArray(new DieRoll[0]);
        return new RollSet(this.getDescription(), rolls);
    }

    @Override
    public void setVisible(boolean b) {
        this.setServerHeader();
        this.setEmailHeader();
        super.setVisible(b);
    }

    private void initConfig(int nd, int ns) {
        this.setModal(true);
        this.setTitle("Multi Roller");
        this.setSize(380, 206);
        this.setBackground(Color.gray);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 3));
        this.serverPanel = new JPanel();
        this.serverLabel = new JLabel();
        this.setServerHeader();
        this.serverPanel.add(this.serverLabel);
        this.topPanel.add(this.serverPanel);
        this.emailPanel = new JPanel();
        this.emailLabel = new JLabel();
        this.setEmailHeader();
        this.emailPanel.add(this.emailLabel);
        this.topPanel.add(this.emailPanel);
        this.descPanel = new JPanel();
        JLabel descLabel = new JLabel("Roll Description");
        this.descText = new JTextField(20);
        this.descText.setText(GameModule.getGameModule().getChatter().getInputField().getText());
        this.descText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MultiRoll.this.description = MultiRoll.this.descText.getText();
            }
        });
        this.descPanel.add(descLabel);
        this.descPanel.add(this.descText);
        this.topPanel.add(this.descPanel);
        this.detailPanel = new JPanel();
        this.detailPanel.setLayout(new BoxLayout(this.detailPanel, 3));
        this.detailPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.detailPanel.add(new HeaderRow());
        this.rollRows = new RollRow[10];
        for (int i = 0; i < 10; ++i) {
            this.rollRows[i] = new RollRow(i, nd, ns);
            this.detailPanel.add(this.rollRows[i]);
        }
        this.topPanel.add(this.detailPanel);
        this.buttonPanel = new JPanel();
        this.rollButton.addActionListener(e -> {
            this.rollCancelled = false;
            int dieCount = 0;
            for (int i = 0; i < 10; ++i) {
                dieCount += this.useDie[i] ? 1 : 0;
            }
            if (dieCount == 0) {
                JOptionPane.showMessageDialog(this.me, "No dice selected for Roll.", "Roll Cancelled", 0);
                return;
            }
            this.setVisible(false);
        });
        this.canButton.addActionListener(e -> {
            this.rollCancelled = true;
            this.setVisible(false);
        });
        this.emailButton.addActionListener(e -> this.updateEmailAddress());
        this.buttonPanel.add(this.rollButton);
        this.buttonPanel.add(this.canButton);
        this.buttonPanel.add(this.emailButton);
        this.add((Component)this.topPanel, "First");
        this.add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    protected void setServerHeader() {
        this.serverLabel.setText("Server: " + this.dieManager.getServer().getName());
    }

    protected void setEmailHeader() {
        Prefs prefs = GameModule.getGameModule().getPrefs();
        String label = Boolean.TRUE.equals(prefs.getValue("useemail")) ? (String)prefs.getValue("secondaryemail") : EMAIL_OFF;
        this.emailLabel.setText("Email: " + label);
    }

    protected void updateEmailAddress() {
        Prefs prefs = GameModule.getGameModule().getPrefs();
        String[] aBook = (String[])prefs.getValue("addressbook");
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(EMAIL_OFF);
        menuItem.addActionListener(this);
        popup.add(menuItem);
        for (String s : aBook) {
            menuItem = new JMenuItem(s);
            menuItem.addActionListener(this);
            popup.add(menuItem);
        }
        popup.show(this.emailButton, this.emailButton.getX(), this.emailButton.getY());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String address = e.getActionCommand();
        Prefs prefs = GameModule.getGameModule().getPrefs();
        if (address.equals(EMAIL_OFF)) {
            prefs.setValue("useemail", Boolean.FALSE);
        } else {
            prefs.setValue("secondaryemail", address);
            prefs.setValue("useemail", Boolean.TRUE);
        }
        this.setEmailHeader();
    }

    protected static class HeaderRow
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public HeaderRow() {
            Border raisedbevel;
            Border myBorder = raisedbevel = BorderFactory.createRaisedBevelBorder();
            JLabel col1 = new JLabel("Roll");
            col1.setPreferredSize(new Dimension(31, 20));
            col1.setHorizontalAlignment(0);
            col1.setBorder(myBorder);
            JLabel col3 = new JLabel("Details");
            col3.setPreferredSize(new Dimension(137, 20));
            col3.setBorder(myBorder);
            JLabel col4 = new JLabel("nDice");
            col4.setBorder(myBorder);
            col4.setHorizontalAlignment(0);
            col4.setPreferredSize(new Dimension(50, 20));
            JLabel col5 = new JLabel("nSides");
            col5.setBorder(myBorder);
            col5.setHorizontalAlignment(0);
            col5.setPreferredSize(new Dimension(50, 20));
            JLabel col6 = new JLabel("add");
            col6.setBorder(myBorder);
            col6.setPreferredSize(new Dimension(25, 20));
            JLabel col7 = new JLabel("Total");
            col7.setBorder(myBorder);
            col7.setPreferredSize(new Dimension(35, 20));
            this.add(col1);
            this.add(col3);
            this.add(col4);
            this.add(col5);
            this.add(col6);
            this.add(col7);
        }
    }

    class RollRow
    extends JPanel {
        private static final long serialVersionUID = 1L;
        int myRow;
        boolean selected;
        String description;
        int nDice;
        int nSides;
        int plus;
        boolean reportTotal;
        Dimension rowDim = new Dimension(40, 20);
        StateButton col1;
        JCheckBox col2;
        JCheckBox col7;
        JComboBox col4;
        JComboBox col5;
        JTextField col3;
        JTextField col6;
        Border blackline = BorderFactory.createLineBorder(Color.black);
        Border raisedetched = BorderFactory.createEtchedBorder(0);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border myBorder = this.raisedbevel;

        @Override
        public void setEnabled(boolean enabled) {
            this.col3.setEnabled(enabled);
            this.col4.setEnabled(enabled);
            this.col5.setEnabled(enabled);
            this.col6.setEnabled(enabled);
            this.col7.setEnabled(enabled);
        }

        public RollRow(int row, int nd, int ns) {
            this.myRow = row;
            this.col1 = new StateButton(Integer.toString(row + 1));
            this.col1.setPreferredSize(new Dimension(31, 20));
            this.col1.setState(MultiRoll.this.useDie[this.myRow]);
            this.col1.addActionListener(e -> {
                this.col1.switchState();
                MultiRoll.this.useDie[this.myRow] = this.col1.getState();
                this.setEnabled(this.col1.getState());
            });
            this.col3 = new JTextField(12);
            this.col3.setBorder(this.myBorder);
            this.col3.setPreferredSize(new Dimension(137, 20));
            this.col3.setText(MultiRoll.this.rolls[this.myRow].getDescription());
            this.col3.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ RollRow this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.this$1.MultiRoll.this.rolls[this.this$1.myRow].setDescription(this.this$1.col3.getText());
                }
            });
            this.col3.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ RollRow this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!this.this$1.col3.hasFocus()) {
                        this.this$1.col3.selectAll();
                    }
                }
            });
            this.col3.setEnabled(false);
            int[] allowableDice = MultiRoll.this.dieManager.getServer().getnDiceList();
            String[] diceData = new String[allowableDice.length];
            int defaultNDIdx = 0;
            for (int i = 0; i < diceData.length; ++i) {
                diceData[i] = Integer.toString(allowableDice[i]);
                if (nd != allowableDice[i]) continue;
                defaultNDIdx = i;
            }
            this.col4 = new JComboBox<String>(diceData);
            this.col4.setSelectedIndex(defaultNDIdx);
            this.col4.setPreferredSize(new Dimension(50, 20));
            this.col4.addActionListener(e -> {
                JComboBox cb = (JComboBox)e.getSource();
                MultiRoll.this.rolls[this.myRow].setNumDice(Integer.parseInt((String)cb.getSelectedItem()));
            });
            this.col4.setEnabled(false);
            int[] allowableSides = MultiRoll.this.dieManager.getServer().getnSideList();
            String[] sideData = new String[allowableSides.length];
            int defaultNSIdx = 0;
            for (int i = 0; i < sideData.length; ++i) {
                sideData[i] = Integer.toString(allowableSides[i]);
                if (ns != allowableSides[i]) continue;
                defaultNSIdx = i;
            }
            this.col5 = new JComboBox<String>(sideData);
            this.col5.setSelectedIndex(defaultNSIdx);
            this.col5.setPreferredSize(new Dimension(50, 20));
            this.col5.addActionListener(e -> {
                JComboBox cb = (JComboBox)e.getSource();
                MultiRoll.this.rolls[this.myRow].setNumSides(Integer.parseInt((String)cb.getSelectedItem()));
            });
            this.col5.setEnabled(false);
            this.col6 = new JTextField(2);
            this.col6.setBorder(this.myBorder);
            this.col6.setPreferredSize(new Dimension(25, 20));
            this.col6.setText(Integer.toString(MultiRoll.this.rolls[this.myRow].getPlus()));
            this.col6.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ RollRow this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    try {
                        this.this$1.MultiRoll.this.rolls[this.this$1.myRow].setPlus(Integer.parseInt(this.this$1.col3.getText()));
                    }
                    catch (NumberFormatException ev) {
                        this.this$1.MultiRoll.this.rolls[this.this$1.myRow].setPlus(0);
                    }
                }
            });
            this.col6.setEnabled(false);
            this.col7 = new JCheckBox();
            this.col7.setBorder(this.myBorder);
            this.col7.setPreferredSize(new Dimension(35, 20));
            this.col7.setHorizontalAlignment(0);
            this.col7.setSelected(MultiRoll.this.rolls[this.myRow].isReportTotal());
            this.col7.addItemListener(e -> MultiRoll.this.rolls[this.myRow].setReportTotal(e.getStateChange() == 1));
            this.col7.setEnabled(false);
            this.add(this.col1);
            this.add(this.col3);
            this.add(this.col4);
            this.add(this.col5);
            this.add(this.col6);
            this.add(this.col7);
        }
    }

    protected static class StateButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        boolean state = false;

        StateButton(String s, boolean b) {
            super(s);
            this.setHorizontalAlignment(0);
            this.setState(b);
        }

        StateButton(String s) {
            this(s, false);
        }

        public void setState(boolean b) {
            this.state = b;
            if (this.state) {
                this.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            }
        }

        public boolean getState() {
            return this.state;
        }

        public void switchState() {
            this.setState(!this.state);
        }
    }
}

