/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.deck;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.map.deck.AbstractDeckKeyCommand;
import VASSAL.build.module.map.deck.SortParameter;
import VASSAL.build.module.map.deck.SortParameterArrayConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.counters.Deck;
import VASSAL.counters.KeyCommand;
import VASSAL.i18n.Resources;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class DeckSortKeyCommand
extends AbstractDeckKeyCommand {
    public static final String SORT_PARAMETERS = "sortParameters";
    private List<SortParameter> sortParameters;
    private NamedKeyStrokeListener sortListener;

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DeckSortKeyCommand.component_type");
    }

    public List<SortParameter> getSortParameters() {
        if (this.sortParameters == null) {
            this.sortParameters = new ArrayList<SortParameter>();
            this.sortParameters.add(new SortParameter("Property", false, false));
        }
        return this.sortParameters;
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{SORT_PARAMETERS});
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.DeckSortKeyCommand.sort_by")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{SortParameterConfig.class});
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SORT_PARAMETERS.equals(key)) {
            if (value instanceof String) {
                value = SortParameterArrayConfigurer.decode((String)((Object)value));
            }
            this.sortParameters = value;
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SORT_PARAMETERS.equals(key)) {
            return SortParameterArrayConfigurer.encode(this.sortParameters);
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public List<KeyCommand> getKeyCommands(final Deck deck) {
        return List.of(new KeyCommand(this, this.getConfigureName(), NamedKeyStroke.NULL_KEYSTROKE, deck){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ DeckSortKeyCommand this$0;
            {
                this.this$0 = this$0;
                super(name, key, target);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.doSort(deck);
            }
        });
    }

    private void doSort(Deck deck) {
        GameModule.getGameModule().sendAndLog(deck.sort(this.sortParameters, this.reportFormat, this.getConfigureName()));
        deck.repaintMap();
    }

    @Override
    public void registerListeners(Deck deck) {
        if (this.sortListener == null && this.keyStroke != null && !this.keyStroke.isNull()) {
            this.sortListener = new NamedKeyStrokeListener(e -> this.doSort(deck));
            this.sortListener.setKeyStroke(this.keyStroke);
            GameModule.getGameModule().addKeyStrokeListener(this.sortListener);
        }
    }

    @Override
    public void deregisterListeners() {
        if (this.sortListener != null) {
            GameModule.getGameModule().removeKeyStrokeListener(this.sortListener);
            this.sortListener = null;
        }
    }

    public static class SortParameterConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new SortParameterArrayConfigurer(key, name, ((DeckSortKeyCommand)c).getSortParameters());
        }
    }
}

