/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.Parameter;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.DynamicProperty;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ParameterConfigurer
extends Configurer {
    protected StringConfigurer propertyNameConfig = new StringConfigurer("");
    protected FormattedExpressionConfigurer valueConfig;
    protected JPanel controls;

    public ParameterConfigurer() {
        this(null);
    }

    public ParameterConfigurer(Parameter parameter) {
        super("", "", parameter);
        this.propertyNameConfig.setHint(Resources.getString("Editor.ParameterConfigurer.name_hint"));
        this.propertyNameConfig.addPropertyChangeListener(e -> this.updateValue());
        this.valueConfig = new FormattedExpressionConfigurer("");
        this.valueConfig.setHint(Resources.getString("Editor.ParameterConfigurer.value_hint"));
        this.valueConfig.addPropertyChangeListener(e -> this.updateValue());
    }

    @Override
    public String getValueString() {
        return this.getParameterValue().encode();
    }

    public Parameter getParameterValue() {
        return (Parameter)this.getValue();
    }

    @Override
    public void setFrozen(boolean val) {
        super.setFrozen(val);
        this.valueConfig.setFrozen(val);
        this.propertyNameConfig.setFrozen(val);
    }

    @Override
    public void setValue(Object value) {
        if (!this.noUpdate && value instanceof Parameter && this.valueConfig != null) {
            Parameter param = (Parameter)value;
            this.valueConfig.setValue(param.getValue());
            this.propertyNameConfig.setValue(param.getPropertyName());
        }
        super.setValue(value);
    }

    public DynamicProperty.DynamicKeyCommand getKeyCommand() {
        return (DynamicProperty.DynamicKeyCommand)this.getValue();
    }

    @Override
    public void setValue(String s) {
        Parameter param = new Parameter(s);
        this.propertyNameConfig.setValue(param.getPropertyName());
        this.valueConfig.setValue(param.getValue());
        this.noUpdate = true;
        this.setValue(param);
        this.noUpdate = false;
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.buildControls();
        }
        return this.controls;
    }

    public void updateValue() {
        this.noUpdate = true;
        this.setValue(new Parameter(this.propertyNameConfig.getValueString(), this.valueConfig.getValueString()));
        this.noUpdate = false;
    }

    protected void buildControls() {
        this.controls = new JPanel((LayoutManager)new MigLayout("ins panel,gapy 4,hidemode 3", "[]rel[][]rel[]"));
        this.controls.setBorder(BorderFactory.createEtchedBorder());
        JLabel label = new JLabel(Resources.getString("Editor.property_name"));
        label.setLabelFor(this.propertyNameConfig.getControls());
        this.controls.add(label);
        this.controls.add(this.propertyNameConfig.getControls(), "grow");
        label = new JLabel(Resources.getString("Editor.value"));
        label.setLabelFor(this.valueConfig.getControls());
        this.controls.add(label);
        this.controls.add(this.valueConfig.getControls(), "grow,wrap");
    }

    public Component getPropertyNameControls() {
        return this.propertyNameConfig.getControls();
    }

    public Component getValueControls() {
        return this.valueConfig.getControls();
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.propertyNameConfig.setHighlighted(highlighted);
        this.valueConfig.setHighlighted(highlighted);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.propertyNameConfig.addFocusListener(listener);
        this.valueConfig.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.propertyNameConfig.removeFocusListener(listener);
        this.valueConfig.removeFocusListener(listener);
    }

    @Override
    public void requestFocus() {
        if (this.propertyNameConfig != null) {
            this.propertyNameConfig.requestFocus();
        }
    }

    @Override
    public void setContext(AbstractBuildable context) {
        super.setContext(context);
        this.propertyNameConfig.setContext(context);
        this.valueConfig.setContext(context);
    }

    @Override
    public void setContextLevel(Configurer.ContextLevel contextLevel) {
        super.setContextLevel(contextLevel);
        this.propertyNameConfig.setContextLevel(contextLevel);
        this.valueConfig.setContextLevel(contextLevel);
    }
}

