/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;

    public ScrollPane() {
        this(null, 20, 30);
    }

    public ScrollPane(Component view) {
        this(view, 20, 30);
    }

    public ScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public ScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        MouseWheelListener[] listeners;
        for (MouseWheelListener value : listeners = this.getMouseWheelListeners()) {
            this.removeMouseWheelListener(value);
        }
        for (MouseWheelListener wheelListener : listeners = this.viewport.getMouseWheelListeners()) {
            this.viewport.removeMouseWheelListener(wheelListener);
        }
        for (MouseWheelListener mouseWheelListener : listeners = this.verticalScrollBar.getMouseWheelListeners()) {
            this.verticalScrollBar.removeMouseWheelListener(mouseWheelListener);
        }
        for (MouseWheelListener listener : listeners = this.horizontalScrollBar.getMouseWheelListeners()) {
            this.horizontalScrollBar.removeMouseWheelListener(listener);
        }
        this.viewport.addMouseWheelListener(e -> {
            if (e.getScrollAmount() == 0) {
                return;
            }
            if (e.getScrollType() == 0 && !e.isAltDown() && !SwingUtils.isSelectionToggle(e)) {
                JScrollBar bar;
                JScrollBar jScrollBar = bar = e.isShiftDown() ? this.horizontalScrollBar : this.verticalScrollBar;
                if (bar == null || !bar.isVisible()) {
                    return;
                }
                GameModule.getGameModule().setSuppressAutoCenterUpdate(false);
                bar.setValue(bar.getValue() + e.getUnitsToScroll() * bar.getUnitIncrement());
            }
        });
        if (view != null) {
            view.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    int scrollDirection = 0;
                    if (e.getButton() == 4) {
                        scrollDirection = -1;
                    } else if (e.getButton() == 5) {
                        scrollDirection = 1;
                    }
                    if (!ScrollPane.this.horizontalScrollBar.isVisible()) {
                        return;
                    }
                    GameModule.getGameModule().setSuppressAutoCenterUpdate(false);
                    ScrollPane.this.horizontalScrollBar.setValue(ScrollPane.this.horizontalScrollBar.getValue() + scrollDirection * ScrollPane.this.horizontalScrollBar.getUnitIncrement());
                }
            });
        }
        this.verticalScrollBar.addMouseWheelListener(e -> {
            if (e.getScrollAmount() == 0) {
                return;
            }
            if (e.getScrollType() == 0) {
                GameModule.getGameModule().setSuppressAutoCenterUpdate(false);
                this.verticalScrollBar.setValue(this.verticalScrollBar.getValue() + e.getUnitsToScroll() * this.verticalScrollBar.getUnitIncrement());
            }
        });
        this.horizontalScrollBar.addMouseWheelListener(e -> {
            if (e.getScrollAmount() == 0) {
                return;
            }
            if (e.getScrollType() == 0) {
                GameModule.getGameModule().setSuppressAutoCenterUpdate(false);
                this.horizontalScrollBar.setValue(this.horizontalScrollBar.getValue() + e.getUnitsToScroll() * this.horizontalScrollBar.getUnitIncrement());
            }
        });
    }
}

