/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.IOException;
import org.litesoft.p2pchat.IllegalArgument;

public class PeerInfo {
    private String zID = "";
    private String zChatName;
    private String zAddresses;
    private Integer zPort = null;
    private String[] zOldChatNames = null;
    private static final String NO_CHATNAME = "(?)";
    private int failureCount = 0;
    private String zNetworkPw = "";

    public PeerInfo(String pChatName, String pAddresses) {
        this.zChatName = pChatName != null ? pChatName : NO_CHATNAME;
        this.zAddresses = pAddresses;
        IllegalArgument.ifNull("Addresses", this.zAddresses);
    }

    public PeerInfo(String pChatName, String pAddresses, int pPort) {
        this(pChatName, pAddresses);
        this.zPort = pPort;
    }

    public PeerInfo(String pChatName, String pAddresses, int pPort, String pNetworkPw) {
        this(pChatName, pAddresses, pPort);
        this.zNetworkPw = pNetworkPw;
    }

    public void updateWith(PeerInfo pPeerInfo) {
        if (pPeerInfo != null) {
            this.setChatName(pPeerInfo.getChatName());
            this.setAddresses(pPeerInfo.getAddresses());
            this.setPort(pPeerInfo.getPort());
            this.setNetworkPw(pPeerInfo.getNetworkPw());
        }
    }

    public static PeerInfo deFormat(String pFormatted) {
        String networkPw;
        String portStr;
        IllegalArgument.ifNull("Formatted", pFormatted);
        int colonAt = pFormatted.indexOf(58);
        int spaceAt = pFormatted.indexOf(32);
        if (colonAt == -1) {
            return null;
        }
        String chatName = null;
        if (spaceAt == -1) {
            spaceAt = pFormatted.length();
        } else {
            chatName = pFormatted.substring(spaceAt + 1);
        }
        String addresses = pFormatted.substring(0, colonAt);
        String rest = pFormatted.substring(colonAt + 1, spaceAt);
        int slashAt = rest.indexOf(47);
        if (slashAt == -1) {
            portStr = rest;
            networkPw = "";
        } else {
            portStr = rest.substring(0, slashAt);
            networkPw = rest.substring(slashAt + 1);
        }
        int port = 0;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException shouldNotHappenSoWeIgnoreThisMessage) {
            return null;
        }
        return new PeerInfo(chatName, addresses, port, networkPw);
    }

    public boolean isAddressable() {
        return this.zAddresses != null && this.zPort != null;
    }

    public String getID() {
        return this.zID;
    }

    public void setID(String pID) {
        this.zID = pID;
        IllegalArgument.ifNull("ID", this.zID);
    }

    public String getChatName() {
        return this.zChatName;
    }

    public String[] getOldChatNames() {
        return this.zOldChatNames;
    }

    public synchronized String getPrevChatName() {
        return this.zOldChatNames == null ? null : this.zOldChatNames[0];
    }

    public synchronized void setChatName(String pChatName) {
        if (pChatName != null && !pChatName.equals(this.zChatName)) {
            if (this.zChatName != null && !this.zChatName.equals(NO_CHATNAME)) {
                if (this.zOldChatNames == null) {
                    this.zOldChatNames = new String[1];
                } else {
                    String[] temp = new String[this.zOldChatNames.length + 1];
                    System.arraycopy(this.zOldChatNames, 0, temp, 1, this.zOldChatNames.length);
                    this.zOldChatNames = temp;
                }
                this.zOldChatNames[0] = this.zChatName;
            }
            this.zChatName = pChatName;
        }
    }

    public String getAddresses() {
        return this.zAddresses;
    }

    public void setAddresses(String pAddresses) {
        this.zAddresses = pAddresses;
        IllegalArgument.ifNull("Addresses", this.zAddresses);
    }

    public int getPort() {
        return this.zPort == null ? 0 : this.zPort;
    }

    public void setPort(int pPort) {
        this.zPort = pPort;
    }

    public String format() {
        return this.zAddresses + ":" + this.zPort + "/" + this.zNetworkPw + " " + this.zChatName;
    }

    public void setNetworkPw(String pw) {
        this.zNetworkPw = pw;
    }

    public String getNetworkPw() {
        return this.zNetworkPw;
    }

    public int hashCode() {
        int retval = 0;
        if (this.zAddresses != null) {
            retval += this.zAddresses.hashCode();
        }
        if (this.zPort != null) {
            retval += this.zPort.hashCode();
        }
        return retval;
    }

    public boolean equals(String pAddresses, Integer pPort) {
        if (this.zAddresses != pAddresses) {
            if (this.zAddresses == null) {
                return false;
            }
            if (!this.zAddresses.equals(pAddresses)) {
                return false;
            }
        }
        if (this.zPort != pPort) {
            if (this.zPort == null) {
                return false;
            }
            if (!this.zPort.equals(pPort)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(PeerInfo pOther) {
        return pOther == null ? false : this.equals(pOther.zAddresses, pOther.zPort);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeerInfo) {
            return this.equals((PeerInfo)obj);
        }
        return false;
    }

    public String toString() {
        String retval = this.zID + " " + this.zChatName + " " + this.zAddresses + ":" + (this.zPort != null ? this.zPort.toString() : "?");
        String[] oldnames = this.getOldChatNames();
        if (oldnames != null) {
            for (int i = 0; i < oldnames.length; ++i) {
                retval = retval + " -> " + oldnames[i];
            }
        }
        return retval;
    }

    public int incrementFailureCount() {
        return ++this.failureCount;
    }

    public void setFailureReason(IOException failureReason) {
    }
}

