/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.i18n.Resources;
import VASSAL.launch.LaunchRequestException;
import VASSAL.tools.io.ArgEncoding;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LaunchRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Mode mode;
    public File module;
    public File game;
    public File extension;
    public File importFile;
    public boolean builtInModule;
    public List<String> autoext;
    public long key;

    public LaunchRequest() {
        this(null, null);
    }

    public LaunchRequest(Mode mode) {
        this(mode, null, null);
    }

    public LaunchRequest(Mode mode, File module) {
        this(mode, module, null);
    }

    public LaunchRequest(Mode mode, File module, File other) {
        this.mode = mode;
        this.module = module;
        if (mode == Mode.EDIT_EXT) {
            this.extension = other;
        } else {
            this.game = other;
        }
    }

    public LaunchRequest(LaunchRequest lr) {
        this.mode = lr.mode;
        this.module = lr.module;
        this.game = lr.game;
        this.extension = lr.extension;
        this.importFile = lr.importFile;
        this.builtInModule = lr.builtInModule;
        if (lr.autoext != null) {
            this.autoext = new ArrayList<String>(lr.autoext);
        }
    }

    public String[] toArgs() {
        boolean needsEncoding;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("--" + String.valueOf((Object)this.mode));
        if (this.builtInModule) {
            args.add("--auto");
        }
        if (this.autoext != null) {
            StringBuilder sb = new StringBuilder("--auto-extensions=");
            Iterator<String> i = this.autoext.iterator();
            sb.append(i.next());
            while (i.hasNext()) {
                sb.append(',').append(i.next());
            }
            args.add(sb.toString().replace(' ', '_'));
        }
        boolean bl = needsEncoding = this.module != null && ArgEncoding.requires(this.module.getPath()) || this.game != null && ArgEncoding.requires(this.game.getPath()) || this.extension != null && ArgEncoding.requires(this.extension.getPath()) || this.importFile != null && ArgEncoding.requires(this.importFile.getPath());
        if (needsEncoding) {
            args.add("--encoded-args");
        }
        args.add("--");
        int enc_start = args.size();
        if (this.module != null) {
            args.add(this.module.getPath());
            if (this.game != null) {
                args.add(this.game.getPath());
            } else if (this.extension != null) {
                args.add(this.extension.getPath());
            }
        } else if (this.importFile != null) {
            args.add(this.importFile.getPath());
        }
        if (needsEncoding) {
            for (int i = enc_start; i < args.size(); ++i) {
                args.set(i, ArgEncoding.encode((String)args.get(i)));
            }
        }
        return args.toArray(new String[0]);
    }

    private static String helpMeSpock() {
        return Resources.getString("LaunchRequest.usage") + ":\n  VASSAL -c\n  VASSAL -e [option]... module\n  VASSAL -i [option]... module\n  VASSAL -l [option]... module|save|log...\n  VASSAL -n [option]...\n  VASSAL -m\n  VASSAL -h\n  VASSAL --edit-extension [option]... module|extension...\n  VASSAL --new-extension [option]...\n\n" + Resources.getString("LaunchRequest.options") + ":\n  -a, --auto          TODO\n  -c, --chatlog       " + Resources.getString("LaunchRequest.chatlog") + "\n  -e, --edit          " + Resources.getString("LaunchRequest.edit") + "\n  -h, --help          " + Resources.getString("LaunchRequest.help") + "\n  -i, --import        " + Resources.getString("LaunchRequest.import") + "\n  -l, --load          " + Resources.getString("LaunchRequest.load") + "\n  -m, --manage        " + Resources.getString("LaunchRequest.manage") + "\n  -n, --new           " + Resources.getString("LaunchRequest.new") + "\n  --auto-extensions   TODO\n  --edit-extension    " + Resources.getString("LaunchRequest.extension") + "\n  --new-extension     " + Resources.getString("LaunchRequest.new_extension") + "\n  --version           " + Resources.getString("LaunchRequest.version") + "\n  --                  " + Resources.getString("LaunchRequest.terminate") + "\n\n" + Resources.getString("LaunchRequest.default") + "\n\n";
    }

    public static LaunchRequest parseArgs(String[] args) throws LaunchRequestException {
        int c;
        LaunchRequest lr = new LaunchRequest();
        int AUTO_EXT = 2;
        int EDIT_EXT = 3;
        int NEW_EXT = 4;
        int PORT = 5;
        int VERSION = 6;
        int TRANSLATE = 7;
        int UPDATE_MOD = 8;
        int UPDATE_EXT = 9;
        int UPDATE_GAME = 10;
        int STANDALONE = 11;
        int ENCARGS = 12;
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("auto", 0, null, 97), new LongOpt("chatlog", 0, null, 99), new LongOpt("edit", 0, null, 101), new LongOpt("help", 0, null, 104), new LongOpt("import", 0, null, 105), new LongOpt("load", 0, null, 108), new LongOpt("manage", 0, null, 109), new LongOpt("new", 0, null, 110), new LongOpt("auto-extensions", 1, null, 2), new LongOpt("edit-extension", 0, null, 3), new LongOpt("new-extension", 0, null, 4), new LongOpt("port", 1, null, 5), new LongOpt("version", 0, null, 6), new LongOpt("translate", 0, null, 7), new LongOpt("update-module", 0, null, 8), new LongOpt("update-extension", 0, null, 9), new LongOpt("update-game", 0, null, 10), new LongOpt("standalone", 0, null, 11), new LongOpt("encoded-args", 0, null, 12)};
        Getopt g = new Getopt("VASSAL", args, ":aehilmn", longOpts);
        g.setOpterr(false);
        boolean encargs = false;
        block34: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 2: {
                    if (lr.autoext == null) {
                        lr.autoext = new ArrayList<String>();
                    }
                    for (String ext : g.getOptarg().split(",")) {
                        lr.autoext.add(ext.replace("_", " "));
                    }
                    continue block34;
                }
                case 3: {
                    LaunchRequest.setMode(lr, Mode.EDIT_EXT);
                    continue block34;
                }
                case 4: {
                    LaunchRequest.setMode(lr, Mode.NEW_EXT);
                    continue block34;
                }
                case 5: {
                    continue block34;
                }
                case 6: {
                    System.err.println("VASSAL " + Info.getVersion());
                    System.exit(0);
                    continue block34;
                }
                case 7: {
                    LaunchRequest.setMode(lr, Mode.TRANSLATE);
                    continue block34;
                }
                case 8: {
                    LaunchRequest.setMode(lr, Mode.UPDATE_MOD);
                    continue block34;
                }
                case 9: {
                    LaunchRequest.setMode(lr, Mode.UPDATE_EXT);
                    continue block34;
                }
                case 10: {
                    LaunchRequest.setMode(lr, Mode.UPDATE_GAME);
                    continue block34;
                }
                case 11: {
                    continue block34;
                }
                case 12: {
                    encargs = true;
                    continue block34;
                }
                case 97: {
                    lr.builtInModule = true;
                    continue block34;
                }
                case 99: {
                    GameModule.setErrorLogToChat(true);
                    continue block34;
                }
                case 101: {
                    LaunchRequest.setMode(lr, Mode.EDIT);
                    continue block34;
                }
                case 104: {
                    System.err.print(LaunchRequest.helpMeSpock());
                    System.exit(0);
                    continue block34;
                }
                case 105: {
                    LaunchRequest.setMode(lr, Mode.IMPORT);
                    continue block34;
                }
                case 108: {
                    LaunchRequest.setMode(lr, Mode.LOAD);
                    continue block34;
                }
                case 109: {
                    LaunchRequest.setMode(lr, Mode.MANAGE);
                    continue block34;
                }
                case 110: {
                    LaunchRequest.setMode(lr, Mode.NEW);
                    continue block34;
                }
                case 58: {
                    LaunchRequest.die("LaunchRequest.missing_argument", args[g.getOptind() - 1]);
                    continue block34;
                }
                case 63: {
                    LaunchRequest.die("LaunchRequest.unrecognized_option", new String[]{g.getOptopt() == 0 ? args[g.getOptind() - 1] : "-" + String.valueOf((char)g.getOptopt())});
                    continue block34;
                }
            }
            throw new IllegalStateException();
        }
        int i = g.getOptind();
        if (lr.mode == null) {
            lr.mode = i < args.length ? Mode.LOAD : Mode.MANAGE;
        }
        switch (lr.mode.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                while (i < args.length) {
                    File file;
                    AbstractMetaData data;
                    if ((data = MetaDataFactory.buildMetaData(file = ArgEncoding.decode(encargs, args[i++]))) instanceof ModuleMetaData) {
                        if (lr.module != null) {
                            LaunchRequest.die("LaunchRequest.only_one", "module");
                        }
                        lr.module = file;
                        continue;
                    }
                    if (data instanceof ExtensionMetaData) {
                        if (lr.extension != null) {
                            LaunchRequest.die("", new String[0]);
                        }
                        lr.extension = file;
                        continue;
                    }
                    if (data instanceof SaveMetaData) {
                        if (lr.game != null) {
                            LaunchRequest.die("LaunchRequest.only_one", "saved game or log");
                        }
                        lr.game = file;
                        continue;
                    }
                    LaunchRequest.die("LaunchRequest.unknown_file_type", file.toString());
                }
                if (lr.builtInModule || lr.module != null || lr.game != null) break;
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case 3: {
                if (i < args.length) {
                    lr.importFile = ArgEncoding.decode(encargs, args[i++]);
                    break;
                }
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case 2: 
            case 6: {
                if (i < args.length) {
                    File file;
                    AbstractMetaData data;
                    if ((data = MetaDataFactory.buildMetaData(file = ArgEncoding.decode(encargs, args[i++]))) instanceof ModuleMetaData) {
                        lr.module = file;
                        break;
                    }
                    if (data instanceof ExtensionMetaData || data instanceof SaveMetaData) break;
                    LaunchRequest.die("LaunchRequest.unknown_file_type", file.toString());
                    break;
                }
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case 5: {
                while (i < args.length) {
                    File file;
                    AbstractMetaData data;
                    if ((data = MetaDataFactory.buildMetaData(file = ArgEncoding.decode(encargs, args[i++]))) instanceof ModuleMetaData) {
                        if (lr.module != null) {
                            LaunchRequest.die("LaunchRequest.only_one", "module");
                        }
                        lr.module = file;
                        continue;
                    }
                    if (data instanceof ExtensionMetaData) {
                        if (lr.extension != null) {
                            LaunchRequest.die("", new String[0]);
                        }
                        lr.extension = file;
                        continue;
                    }
                    if (data instanceof SaveMetaData) continue;
                    LaunchRequest.die("LaunchRequest.unknown_file_type", file.toString());
                }
                if (lr.module == null) {
                    LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                }
                if (lr.extension != null) break;
                LaunchRequest.die("LaunchRequest.missing_extension", new String[0]);
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 8: {
                if (i < args.length) {
                    lr.module = ArgEncoding.decode(encargs, args[i++]);
                    break;
                }
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case 9: {
                if (i < args.length) {
                    lr.extension = ArgEncoding.decode(encargs, args[i++]);
                    break;
                }
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case 10: {
                if (i < args.length) {
                    lr.game = ArgEncoding.decode(encargs, args[i++]);
                    break;
                }
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
            }
        }
        if (i < args.length) {
            LaunchRequest.die("LaunchRequest.excess_args", args[i]);
        }
        if (lr.builtInModule) {
            if (lr.mode != Mode.LOAD) {
                LaunchRequest.die("LaunchRequest.only_in_mode", "--auto", Mode.LOAD.toString());
            }
            if (lr.module != null) {
                LaunchRequest.die("LaunchRequest.excess_args", args[i]);
            }
        }
        if (lr.autoext != null) {
            if (lr.mode != Mode.LOAD) {
                LaunchRequest.die("LaunchRequest.only_in_mode", "--auto-extensions", Mode.LOAD.toString());
            }
            if (lr.module != null) {
                LaunchRequest.die("LaunchRequest.excess_args", args[i]);
            }
        }
        return lr;
    }

    protected static void setMode(LaunchRequest lr, Mode mode) throws LaunchRequestException {
        if (lr.mode != null) {
            LaunchRequest.die("LaunchRequest.only_one", "mode");
        }
        lr.mode = mode;
    }

    protected static void die(String key, String ... vals) throws LaunchRequestException {
        throw new LaunchRequestException(key, vals);
    }

    static enum Mode {
        MANAGE("manage"),
        LOAD("load"),
        EDIT("edit"),
        IMPORT("import"),
        NEW("new"),
        EDIT_EXT("edit-extension"),
        NEW_EXT("new-extension"),
        TRANSLATE("translate"),
        UPDATE_MOD("update-module"),
        UPDATE_EXT("update-extension"),
        UPDATE_GAME("update-game");

        private final String prettyName;

        private Mode(String prettyName) {
            this.prettyName = prettyName;
        }

        public String toString() {
            return this.prettyName;
        }
    }
}

