/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;

public class DialogUtils {
    private static final Set<Object> disabled = Collections.synchronizedSet(new HashSet());
    private static final ExecutorService ex = Executors.newSingleThreadExecutor();

    private DialogUtils() {
    }

    public static boolean isDisabled(Object key) {
        return disabled.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDisabled(Object key, boolean disable) {
        Set<Object> set = disabled;
        synchronized (set) {
            boolean wasDisabled = DialogUtils.isDisabled(key);
            if (wasDisabled) {
                if (!disable) {
                    disabled.remove(key);
                }
            } else if (disable) {
                disabled.add(key);
            }
            return wasDisabled;
        }
    }

    public static Future<?> enqueue(Runnable runnable) {
        return ex.submit(() -> {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException e) {
                ErrorDialog.bug(e);
            }
        });
    }
}

