/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.counters.Deck;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFinder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MapCenterer
extends AbstractBuildable
implements MouseListener {
    private Map map;
    private PieceFinder finder;

    @Override
    public void addTo(Buildable b) {
        this.finder = this.createPieceFinder();
        this.map = (Map)b;
        this.map.addLocalMouseListener(this);
    }

    protected PieceFinder createPieceFinder() {
        return new PieceFinder.PieceInStack(){

            @Override
            public Object visitDeck(Deck d) {
                Point pos = d.getPosition();
                Point p = new Point(this.pt.x - pos.x, this.pt.y - pos.y);
                return d.getShape().contains(p) ? d : null;
            }
        };
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String attName) {
        return null;
    }

    @Override
    public void setAttribute(String attName, Object value) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtils.isContextMouseButtonDown(e)) {
            EventFilter filter;
            GamePiece found = this.map.findPiece(e.getPoint(), this.finder);
            if (found != null && (filter = (EventFilter)found.getProperty("selectEventFilter")) != null && filter.rejectEvent(e)) {
                found = null;
            }
            if (found == null) {
                Map.View m = (Map.View)e.getSource();
                m.getMap().centerAt(e.getPoint());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return true;
    }
}

