/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Mat;
import VASSAL.counters.MatCargo;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.AuditableException;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class SendToLocation
extends Decorator
implements TranslatablePiece {
    public static final String ID = "sendto;";
    private static final String _0 = "0";
    public static final String BACK_MAP = "backMap";
    public static final String BACK_POINT = "backPoint";
    public static final String DEST_GRIDLOCATION = "G";
    public static final String DEST_LOCATION = "L";
    public static final String DEST_ZONE = "Z";
    public static final String DEST_REGION = "R";
    public static final String DEST_COUNTER = "A";
    public static final String DEST_COUNTER_CYCLE = "C";
    public static final String DEST_COUNTER_NEAREST = "N";
    public static final String[] DEST_OPTIONS = new String[]{"G", "L", "Z", "R", "A", "C", "N"};
    public static final String[] DEST_KEYS = new String[]{"Editor.SendToLocation.grid_location_on_selected_map", "Editor.SendToLocation.location_on_selected_map", "Editor.SendToLocation.zone_on_selected_map", "Editor.SendToLocation.region_on_selected_map", "Editor.SendToLocation.another_counter_selected_by_properties_any", "Editor.SendToLocation.another_counter_selected_by_properties_cycle", "Editor.SendToLocation.another_counter_selected_by_properties_nearest"};
    protected KeyCommand[] command;
    protected String commandName;
    protected String backCommandName;
    protected NamedKeyStroke key;
    protected NamedKeyStroke backKey;
    protected FormattedString mapId = new FormattedString("");
    protected FormattedString boardName = new FormattedString("");
    protected FormattedString x = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString y = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected FormattedString gridLocation = new FormattedString("");
    protected KeyCommand sendCommand;
    protected KeyCommand backCommand;
    protected String description;
    protected String destination;
    protected FormattedString zone = new FormattedString("");
    protected FormattedString region = new FormattedString("");
    protected PropertyExpression propertyFilter = new PropertyExpression("");
    private Map map;

    public SendToLocation() {
        this(ID, null);
    }

    public SendToLocation(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken("");
        this.key = st.nextNamedKeyStroke(null);
        this.mapId.setFormat(st.nextToken(""));
        this.boardName.setFormat(st.nextToken(""));
        this.x.setFormat(st.nextToken(_0));
        this.y.setFormat(st.nextToken(_0));
        this.backCommandName = st.nextToken("");
        this.backKey = st.nextNamedKeyStroke(null);
        this.xIndex.setFormat(st.nextToken(_0));
        this.yIndex.setFormat(st.nextToken(_0));
        this.xOffset.setFormat(st.nextToken("1"));
        this.yOffset.setFormat(st.nextToken("1"));
        this.description = st.nextToken("");
        this.destination = st.nextToken(DEST_LOCATION.substring(0, 1));
        if (this.destination.length() == 0) {
            this.destination = DEST_LOCATION.substring(0, 1);
        }
        this.zone.setFormat(st.nextToken(""));
        this.region.setFormat(st.nextToken(""));
        this.propertyFilter.setExpression(st.nextToken(""));
        this.gridLocation.setFormat(st.nextToken(""));
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.mapId.getFormat()).append(this.boardName.getFormat()).append(this.x.getFormat()).append(this.y.getFormat()).append(this.backCommandName).append(this.backKey).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description).append(this.destination).append(this.zone.getFormat()).append(this.region.getFormat()).append(this.propertyFilter.getExpression()).append(this.gridLocation.getFormat());
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.sendCommand = new KeyCommand(this.commandName, this.key, SendToLocation.getOutermost(this), (TranslatablePiece)this);
            this.backCommand = new KeyCommand(this.backCommandName, this.backKey, SendToLocation.getOutermost(this), (TranslatablePiece)this);
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            if (this.commandName.length() > 0 && this.key != null && !this.key.isNull()) {
                l.add(this.sendCommand);
            }
            if (this.backCommandName.length() > 0 && this.backKey != null && !this.backKey.isNull()) {
                l.add(this.backCommand);
            }
            this.command = l.toArray(KeyCommand.NONE);
        }
        for (KeyCommand c : this.command) {
            if (c.getName().equals(this.backCommandName)) {
                c.setEnabled(this.getMap() != null && this.getProperty(BACK_MAP) != null && this.getProperty(BACK_POINT) != null);
                continue;
            }
            Point p = this.getSendLocation();
            c.setEnabled(this.getMap() != null && p != null && (this.map != this.getMap() || !p.equals(this.getPosition())));
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        Map backMap = (Map)this.getProperty(BACK_MAP);
        if (backMap != null) {
            se.append(backMap.getIdentifier());
        } else {
            se.append("");
        }
        Point backPoint = (Point)this.getProperty(BACK_POINT);
        if (backPoint != null) {
            se.append(backPoint.x).append(backPoint.y);
        } else {
            se.append("").append("");
        }
        return se.getValue();
    }

    public static Destination getSendLocation(PropertySource source, Auditable auditSource, String destination, FormattedString mapId, FormattedString boardName, FormattedString zone, FormattedString region, FormattedString gridLocation, FormattedString x, FormattedString y, PropertyExpression propertyFilter, Map sourceMap, Point startPosition) {
        Map map = null;
        Point dest = null;
        if (destination.equals(DEST_COUNTER.substring(0, 1)) || destination.equals(DEST_COUNTER_CYCLE.substring(0, 1)) || destination.equals(DEST_COUNTER_NEAREST.substring(0, 1))) {
            ArrayList<GamePiece> targets = new ArrayList<GamePiece>();
            for (GamePiece piece : GameModule.getGameModule().getGameState().getAllPieces()) {
                if (piece instanceof Stack) {
                    Stack s = (Stack)piece;
                    for (GamePiece gamePiece : s.asList()) {
                        if (!propertyFilter.accept(source, gamePiece) || targets.contains(gamePiece)) continue;
                        targets.add(gamePiece);
                        if (!destination.equals(DEST_COUNTER.substring(0, 1))) continue;
                        break;
                    }
                    if (!destination.equals(DEST_COUNTER.substring(0, 1)) || targets.isEmpty()) continue;
                    break;
                }
                if (!propertyFilter.accept(source, piece) || targets.contains(piece)) continue;
                targets.add(piece);
                if (!destination.equals(DEST_COUNTER.substring(0, 1))) continue;
                break;
            }
            if (!targets.isEmpty()) {
                GamePiece target = null;
                if (destination.equals(DEST_COUNTER.substring(0, 1))) {
                    target = (GamePiece)targets.get(0);
                } else {
                    double dist = Double.MAX_VALUE;
                    int startIndex = 0;
                    for (int index = 0; index < targets.size(); ++index) {
                        double myDist;
                        if (((GamePiece)targets.get(index)).getMap() != sourceMap || (myDist = ((GamePiece)targets.get(index)).getPosition().distance(startPosition)) >= dist) continue;
                        dist = myDist;
                        startIndex = index;
                    }
                    if (destination.equals(DEST_COUNTER_CYCLE.substring(0, 1))) {
                        for (int counter = 0; counter < targets.size(); ++counter) {
                            int index = (startIndex + counter + 1) % targets.size();
                            if (((GamePiece)targets.get(index)).getMap() == sourceMap && startPosition.equals(((GamePiece)targets.get(index)).getPosition())) continue;
                            target = (GamePiece)targets.get(index);
                            break;
                        }
                    } else {
                        target = (GamePiece)targets.get(startIndex);
                    }
                }
                if (target != null && (map = target.getMap()) != null) {
                    dest = target.getPosition();
                }
            }
        } else {
            if (mapId != null) {
                map = Map.getMapById(mapId.getText(source, auditSource, "Editor.SendToLocation.map"));
            }
            if (map == null) {
                map = sourceMap;
            }
            if (map != null) {
                switch (destination.charAt(0)) {
                    case 'G': {
                        Board b = map.getBoardByName(boardName.getText(source, auditSource, "Editor.SendToLocation.board"));
                        if (b == null) break;
                        AuditTrail gridAudit = AuditTrail.create(auditSource, gridLocation, Resources.getString("Editor.SendToLocation.grid_location"));
                        try {
                            MapGrid g = b.getGrid();
                            if (g != null) {
                                dest = g.getLocation(gridLocation.getText(source, auditSource, gridAudit));
                                if (dest == null) break;
                                dest.translate(b.bounds().x, b.bounds().y);
                                break;
                            }
                            if (auditSource instanceof EditablePiece) {
                                SendToLocation.reportDataError((EditablePiece)auditSource, Resources.getString("Error.no_grid_assigned"), map.getMapName(), new AuditableException(auditSource, gridAudit));
                                break;
                            }
                            if (!(auditSource instanceof AbstractConfigurable)) break;
                            ErrorDialog.dataWarning(new BadDataReport((AbstractConfigurable)auditSource, Resources.getString("Error.no_grid_assigned"), map.getMapName(), (Throwable)new AuditableException(auditSource, gridAudit)));
                        }
                        catch (MapGrid.BadCoords e) {
                            if (auditSource instanceof EditablePiece) {
                                SendToLocation.reportDataError((EditablePiece)auditSource, Resources.getString("Error.not_found", Resources.getString("Editor.SendToLocation.grid_location")), map.getMapName(), new AuditableException(auditSource, gridAudit));
                                break;
                            }
                            if (!(auditSource instanceof AbstractConfigurable)) break;
                            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.not_found", Resources.getString("Editor.SendToLocation.grid_location")), map.getMapName(), new AuditableException(auditSource, gridAudit)));
                        }
                        break;
                    }
                    case 'L': {
                        int yValue;
                        int xValue;
                        if (auditSource instanceof EditablePiece) {
                            xValue = x.getTextAsInt(source, Resources.getString("Editor.x_position"), (EditablePiece)auditSource);
                            yValue = y.getTextAsInt(source, Resources.getString("Editor.y_position"), (EditablePiece)auditSource);
                        } else if (auditSource instanceof AbstractConfigurable) {
                            xValue = x.getTextAsInt(source, Resources.getString("Editor.x_position"), (AbstractConfigurable)auditSource);
                            yValue = y.getTextAsInt(source, Resources.getString("Editor.y_position"), (AbstractConfigurable)auditSource);
                        } else {
                            xValue = 0;
                            yValue = 0;
                        }
                        dest = new Point(xValue, yValue);
                        Board b = map.getBoardByName(boardName.getText(source, auditSource, "Editor.SendToLocation.board"));
                        if (b == null) break;
                        dest.translate(b.bounds().x, b.bounds().y);
                        break;
                    }
                    case 'Z': {
                        AuditTrail zoneAudit = AuditTrail.create(auditSource, zone, Resources.getString("Editor.SendToLocation.zone_name"));
                        String zoneName = zone.getText(source, auditSource, zoneAudit);
                        Zone z = map.findZone(zoneName);
                        if (z == null) {
                            if (auditSource instanceof EditablePiece) {
                                SendToLocation.reportDataError((EditablePiece)auditSource, Resources.getString("Error.not_found", "Zone"), zone.debugInfo(zoneName, "Zone"), new AuditableException(auditSource, zoneAudit));
                                break;
                            }
                            if (!(auditSource instanceof AbstractConfigurable)) break;
                            ErrorDialog.dataWarning(new BadDataReport((AbstractConfigurable)auditSource, Resources.getString("Error.not_found", "Zone"), zone.debugInfo(zoneName, "Zone"), (Throwable)new AuditableException(auditSource, zoneAudit)));
                            break;
                        }
                        Rectangle r = z.getBounds();
                        Rectangle r2 = z.getBoard().bounds();
                        dest = new Point(r2.x + r.x + r.width / 2, r2.y + r.y + r.height / 2);
                        break;
                    }
                    case 'R': {
                        AuditTrail regionAudit = AuditTrail.create(auditSource, region, Resources.getString("Editor.SendToLocation.region_name"));
                        String regionName = region.getText(source, auditSource, regionAudit);
                        Region r = map.findRegion(regionName);
                        if (r == null) {
                            if (auditSource instanceof EditablePiece) {
                                SendToLocation.reportDataError((EditablePiece)auditSource, Resources.getString("Error.not_found", "Region"), region.debugInfo(regionName, "Region"), new AuditableException(auditSource, regionAudit));
                                break;
                            }
                            if (!(auditSource instanceof AbstractConfigurable)) break;
                            ErrorDialog.dataWarning(new BadDataReport((AbstractConfigurable)auditSource, Resources.getString("Error.not_found", "Zone"), region.debugInfo(regionName, "Zone"), (Throwable)new AuditableException(auditSource, regionAudit)));
                            break;
                        }
                        Rectangle r2 = r.getBoard().bounds();
                        dest = new Point(r.getOrigin().x + r2.x, r.getOrigin().y + r2.y);
                    }
                }
            }
        }
        return new Destination(map, dest);
    }

    private Point getSendLocation() {
        GamePiece outer = SendToLocation.getOutermost(this);
        FormattedStringExpression props = new FormattedStringExpression(this.propertyFilter.getExpression());
        PropertyExpression pf = new PropertyExpression(props.tryEvaluate((PropertySource)outer, (Auditable)this, "Editor.SendToLocation.getSendLocation"));
        Destination dest = SendToLocation.getSendLocation(outer, this, this.destination, this.mapId, this.boardName, this.zone, this.region, this.gridLocation, this.x, this.y, pf, this.getMap(), this.getPosition());
        this.map = dest.map;
        if (dest.point != null) {
            dest.point = this.offsetDestination(dest.point.x, dest.point.y, outer);
        }
        return dest.point;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Mat mat;
        String matName;
        this.myGetKeyCommands();
        boolean send = this.sendCommand.matches(stroke);
        if (!send && !this.backCommand.matches(stroke)) {
            return null;
        }
        GamePiece outer = SendToLocation.getOutermost(this);
        List<GamePiece> contents = null;
        List<Point> offsets = null;
        Command c = null;
        Point dest = null;
        Map oldMap = outer.getMap();
        if (GameModule.getGameModule().isMatSupport() && (matName = (String)outer.getProperty("MatName")) != null && !"".equals(matName) && (mat = (Mat)SendToLocation.getDecorator(outer, Mat.class)) != null) {
            Point basePt = outer.getPosition();
            contents = mat.getContents();
            offsets = mat.getOffsets(basePt.x, basePt.y);
        }
        if (send) {
            dest = this.getSendLocation();
            if (this.map != null && dest != null) {
                if (this.map == this.getMap() && dest.equals(this.getPosition())) {
                    return null;
                }
                ChangeTracker tracker = new ChangeTracker(this);
                this.setProperty(BACK_MAP, this.getMap());
                this.setProperty(BACK_POINT, this.getPosition());
                c = tracker.getChangeCommand();
                c = this.prepareMove(c, GlobalOptions.getInstance().isSendToLocationMoveTrails());
                if (!Boolean.TRUE.equals(outer.getProperty("IgnoreGrid"))) {
                    dest = this.map.snapTo(dest);
                }
                c = c.append(this.map.placeOrMerge(outer, dest));
                if (oldMap != null && oldMap != this.map) {
                    oldMap.repaint();
                }
                this.map.repaint();
                c = this.finishMove(c, true, true, GlobalOptions.getInstance().isSendToLocationMoveTrails());
            }
        } else {
            Map backMap = (Map)this.getProperty(BACK_MAP);
            Point backPoint = (Point)this.getProperty(BACK_POINT);
            ChangeTracker tracker = new ChangeTracker(this);
            this.setProperty(BACK_MAP, null);
            this.setProperty(BACK_POINT, null);
            c = tracker.getChangeCommand();
            if (backMap != null && backPoint != null) {
                c = this.prepareMove(c, GlobalOptions.getInstance().isSendToLocationMoveTrails());
                c = c.append(backMap.placeOrMerge(outer, backPoint));
                dest = backPoint;
                c = this.finishMove(c, true, true, GlobalOptions.getInstance().isSendToLocationMoveTrails());
                if (oldMap != null && oldMap != backMap) {
                    oldMap.repaint();
                }
                backMap.repaint();
            }
        }
        if (c != null && GameModule.getGameModule().isMatSupport() && offsets != null && dest != null) {
            for (int i = 0; i < contents.size(); ++i) {
                GamePiece piece = contents.get(i);
                MatCargo cargo = (MatCargo)SendToLocation.getDecorator(piece, MatCargo.class);
                if (cargo == null) continue;
                Point pt = new Point(dest);
                pt.x += offsets.get((int)i).x;
                pt.y += offsets.get((int)i).y;
                c = piece.prepareMove(c, GlobalOptions.getInstance().isSendToLocationMoveTrails());
                c = c.append(this.map.placeOrMerge(piece, pt));
                c = piece.finishMove(c, true, false, GlobalOptions.getInstance().isSendToLocationMoveTrails());
            }
        }
        return c;
    }

    protected Point offsetDestination(int x, int y, GamePiece outer) {
        int xPos = x + this.parse("xIndex", this.xIndex, outer) * this.parse("xOffset", this.xOffset, outer);
        int yPos = y + this.parse("yIndex", this.yIndex, outer) * this.parse("yOffset", this.yOffset, outer);
        return new Point(xPos, yPos);
    }

    private int parse(String desc, FormattedString s, GamePiece outer) {
        int i = 0;
        String val = s.getText((PropertySource)outer, _0, (Auditable)this, AuditTrail.create((Auditable)this, s.getFormat(), desc));
        try {
            i = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), s.debugInfo(val, desc), e);
        }
        return i;
    }

    @Override
    public void mySetState(String newState) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(newState, ';');
        String mapId = st.nextToken("");
        if (mapId.length() > 0) {
            this.setProperty(BACK_MAP, Map.getMapById(mapId));
        }
        String x = st.nextToken("");
        String y = st.nextToken("");
        if (x.length() > 0 && y.length() > 0) {
            try {
                this.setProperty(BACK_POINT, new Point(Integer.parseInt(x), Integer.parseInt(y)));
            }
            catch (NumberFormatException e) {
                SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), "Back Point=(" + x + "," + y + ")", e);
            }
        }
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object d = Resources.getString("Editor.SendToLocation.trait_description");
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        d = (String)d + this.getCommandDesc(this.commandName, this.key);
        return d;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.SendToLocation.trait_description");
    }

    @Override
    public String getDescriptionField() {
        return this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SendToLocation.html");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.commandName, this.backCommandName}, new String[]{this.getCommandDescription(this.description, Resources.getString("Editor.SendToLocation.send_command_description")), this.getCommandDescription(this.description, Resources.getString("Editor.SendToLocation.back_command_description"))});
    }

    @Override
    public boolean testEquals(Object o) {
        String id2;
        if (!(o instanceof SendToLocation)) {
            return false;
        }
        SendToLocation c = (SendToLocation)o;
        if (!Objects.equals(this.commandName, c.commandName)) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.mapId, c.mapId)) {
            return false;
        }
        if (!Objects.equals(this.boardName, c.boardName)) {
            return false;
        }
        if (!Objects.equals(this.x, c.x)) {
            return false;
        }
        if (!Objects.equals(this.y, c.y)) {
            return false;
        }
        if (!Objects.equals(this.backCommandName, c.backCommandName)) {
            return false;
        }
        if (!Objects.equals(this.backKey, c.backKey)) {
            return false;
        }
        if (!Objects.equals(this.xIndex, c.xIndex)) {
            return false;
        }
        if (!Objects.equals(this.yIndex, c.yIndex)) {
            return false;
        }
        if (!Objects.equals(this.xOffset, c.xOffset)) {
            return false;
        }
        if (!Objects.equals(this.yOffset, c.yOffset)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.destination, c.destination)) {
            return false;
        }
        if (!Objects.equals(this.zone, c.zone)) {
            return false;
        }
        if (!Objects.equals(this.region, c.region)) {
            return false;
        }
        if (!Objects.equals(this.propertyFilter, c.propertyFilter)) {
            return false;
        }
        if (!Objects.equals(this.gridLocation, c.gridLocation)) {
            return false;
        }
        Map backMap = (Map)this.getProperty(BACK_MAP);
        String id1 = backMap == null ? "" : backMap.getIdentifier();
        Map backMapc = (Map)c.getProperty(BACK_MAP);
        String string = id2 = backMapc == null ? "" : backMapc.getIdentifier();
        if (!Objects.equals(id1, id2)) {
            return false;
        }
        Point bp1 = (Point)this.getProperty(BACK_POINT);
        Point bp2 = (Point)c.getProperty(BACK_POINT);
        return Objects.equals(bp1, bp2);
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.destination.equals(DEST_COUNTER.substring(0, 1)) || this.destination.equals(DEST_COUNTER_CYCLE.substring(0, 1)) || this.destination.equals(DEST_COUNTER_NEAREST.substring(0, 1))) {
            l.add(this.propertyFilter.getExpression());
        } else {
            l.add(this.mapId.getFormat());
            switch (this.destination.charAt(0)) {
                case 'G': {
                    l.add(this.boardName.getFormat());
                    l.add(this.gridLocation.getFormat());
                    break;
                }
                case 'L': {
                    l.add(this.boardName.getFormat());
                    l.add(this.x.getFormat());
                    l.add(this.y.getFormat());
                    break;
                }
                case 'Z': {
                    l.add(this.zone.getFormat());
                    break;
                }
                case 'R': {
                    l.add(this.region.getFormat());
                }
            }
        }
        return l;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.commandName);
    }

    public static class Destination {
        public Map map;
        public Point point;

        Destination(Map map, Point point) {
            this.map = map;
            this.point = point;
        }
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameInput;
        protected StringConfigurer backNameInput;
        protected NamedHotKeyConfigurer keyInput;
        protected NamedHotKeyConfigurer backKeyInput;
        protected FormattedStringConfigurer mapIdInput;
        protected FormattedStringConfigurer boardNameInput;
        protected JLabel xInputLabel;
        protected FormattedStringConfigurer xInput;
        protected JLabel yInputLabel;
        protected FormattedStringConfigurer yInput;
        @Deprecated(since="2020-12-11", forRemoval=true)
        protected JLabel advancedLabel;
        @Deprecated(since="2020-12-11", forRemoval=true)
        protected BooleanConfigurer advancedInput;
        protected JLabel xAdvancedLabel;
        protected JLabel yAdvancedLabel;
        protected FormattedStringConfigurer xIndexInput;
        protected FormattedStringConfigurer xOffsetInput;
        protected FormattedStringConfigurer yIndexInput;
        protected FormattedStringConfigurer yOffsetInput;
        protected StringConfigurer descInput;
        protected StringEnumConfigurer destInput;
        protected TranslatingStringEnumConfigurer newDestInput;
        protected JLabel propertyLabel;
        protected PropertyExpressionConfigurer propertyInput;
        protected JLabel zoneLabel;
        protected FormattedStringConfigurer zoneInput;
        protected JLabel regionLabel;
        protected FormattedStringConfigurer regionInput;
        protected TraitConfigPanel controls = new TraitConfigPanel();
        protected JLabel mapLabel;
        protected JPanel mapControls;
        protected JLabel boardLabel;
        protected JPanel boardControls;
        protected JPanel advancedControls;
        protected JPanel yAdvancedControls;
        protected JLabel gridLabel;
        protected StringConfigurer gridLocationInput;

        public Ed(SendToLocation p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.nameInput = new StringConfigurer(p.commandName);
            this.nameInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.nameInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.keyboard_command", (Configurer)this.keyInput);
            this.backNameInput = new StringConfigurer(p.backCommandName);
            this.backNameInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.SendToLocation.send_back_command_name", (Configurer)this.backNameInput);
            this.backKeyInput = new NamedHotKeyConfigurer(p.backKey);
            this.controls.add("Editor.SendToLocation.send_back_keyboard_command", (Configurer)this.backKeyInput);
            this.newDestInput = new TranslatingStringEnumConfigurer(DEST_OPTIONS, DEST_KEYS);
            this.newDestInput.setValue(SendToLocation.DEST_LOCATION);
            for (String destOption : DEST_OPTIONS) {
                if (!destOption.substring(0, 1).equals(p.destination)) continue;
                this.newDestInput.setValue(destOption);
            }
            this.newDestInput.addPropertyChangeListener(arg0 -> this.updateVisibility());
            this.controls.add("Editor.SendToLocation.destination", (Configurer)this.newDestInput);
            this.mapLabel = new JLabel(Resources.getString("Editor.SendToLocation.map"));
            this.mapControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[]"));
            JPanel mapPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow]", "push[]push"));
            this.mapIdInput = new FormattedExpressionConfigurer(p.mapId.getFormat(), p);
            this.mapIdInput.setHintKey("Editor.SendToLocation.map_hint");
            mapPanel.add(this.mapIdInput.getControls(), "grow");
            this.mapControls.add((Component)mapPanel, "grow");
            JButton select = new JButton(Resources.getString("Editor.select"));
            select.addActionListener(e -> this.selectMap());
            this.mapControls.add(select);
            JButton clear = new JButton(Resources.getString("Editor.clear"));
            clear.addActionListener(e -> this.clearMap());
            this.mapControls.add(clear);
            this.controls.add(this.mapLabel, this.mapControls);
            this.boardLabel = new JLabel(Resources.getString("Editor.SendToLocation.board"));
            this.boardControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[]"));
            this.boardNameInput = new FormattedExpressionConfigurer(p.boardName.getFormat(), p);
            this.boardNameInput.setHintKey("Editor.SendToLocation.board_hint");
            JPanel boardPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow]", "push[]push"));
            boardPanel.add(this.boardNameInput.getControls(), "grow");
            this.boardControls.add((Component)boardPanel, "grow");
            select = new JButton(Resources.getString("Editor.select"));
            select.addActionListener(e -> this.selectBoard());
            clear = new JButton(Resources.getString("Editor.clear"));
            clear.addActionListener(e -> this.clearBoard());
            this.boardControls.add(select);
            this.boardControls.add(clear);
            this.controls.add(this.boardLabel, this.boardControls);
            this.xInputLabel = new JLabel(Resources.getString("Editor.x_position"));
            this.xInput = new FormattedExpressionConfigurer(p.x.getFormat(), p);
            this.controls.add(this.xInputLabel, (Configurer)this.xInput);
            this.yInputLabel = new JLabel(Resources.getString("Editor.y_position"));
            this.yInput = new FormattedExpressionConfigurer(p.y.getFormat(), p);
            this.controls.add(this.yInputLabel, (Configurer)this.yInput);
            this.zoneLabel = new JLabel(Resources.getString("Editor.SendToLocation.zone_name"));
            this.zoneInput = new FormattedExpressionConfigurer(p.zone.getFormat(), p);
            this.zoneInput.setHintKey("Editor.SendToLocation.zone_hint");
            this.controls.add(this.zoneLabel, (Configurer)this.zoneInput);
            this.regionLabel = new JLabel(Resources.getString("Editor.SendToLocation.region_name"));
            this.regionInput = new FormattedExpressionConfigurer(p.region.getFormat(), p);
            this.regionInput.setHintKey("Editor.SendToLocation.region_hint");
            this.controls.add(this.regionLabel, (Configurer)this.regionInput);
            this.propertyLabel = new JLabel(Resources.getString("Editor.property_match_label"));
            this.propertyInput = new PropertyExpressionConfigurer(p.propertyFilter, (GamePiece)p);
            this.controls.add(this.propertyLabel, (Configurer)this.propertyInput);
            this.gridLabel = new JLabel(Resources.getString("Editor.SendToLocation.grid_location"));
            this.gridLocationInput = new StringConfigurer(p.gridLocation.getFormat());
            this.gridLocationInput.setHintKey("Editor.SendToLocation.grid_location_hint");
            this.controls.add(this.gridLabel, (Configurer)this.gridLocationInput);
            this.xAdvancedLabel = new JLabel(Resources.getString("Editor.SendToLocation.additional_x_offset"));
            this.advancedControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[grow,fill]"));
            this.xIndexInput = new FormattedExpressionConfigurer(p.xIndex.getFormat(), p);
            this.advancedControls.add(this.xIndexInput.getControls(), "grow");
            this.advancedControls.add(new JLabel(Resources.getString("Editor.SendToLocation.times")));
            this.xOffsetInput = new FormattedExpressionConfigurer(p.xOffset.getFormat(), p);
            this.advancedControls.add(this.xOffsetInput.getControls(), "grow");
            this.controls.add(this.xAdvancedLabel, this.advancedControls);
            this.yAdvancedLabel = new JLabel(Resources.getString("Editor.SendToLocation.additional_y_offset"));
            this.yAdvancedControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[grow,fill]"));
            this.yIndexInput = new FormattedExpressionConfigurer(p.yIndex.getFormat(), p);
            this.yAdvancedControls.add(this.yIndexInput.getControls(), "grow");
            this.yAdvancedControls.add(new JLabel(Resources.getString("Editor.SendToLocation.times")));
            this.yOffsetInput = new FormattedExpressionConfigurer(p.yOffset.getFormat(), p);
            this.yAdvancedControls.add(this.yOffsetInput.getControls(), "grow");
            this.controls.add(this.yAdvancedLabel, this.yAdvancedControls);
            this.updateVisibility();
        }

        private void updateVisibility() {
            String destOption = this.newDestInput.getValueString();
            this.xInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.xInputLabel.setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.yInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.yInputLabel.setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            boolean destCounter = destOption.equals(SendToLocation.DEST_COUNTER) || destOption.equals(SendToLocation.DEST_COUNTER_CYCLE) || destOption.equals(SendToLocation.DEST_COUNTER_NEAREST);
            this.mapControls.setVisible(!destCounter);
            this.mapLabel.setVisible(!destCounter);
            this.boardControls.setVisible(destOption.equals(SendToLocation.DEST_LOCATION) || destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            this.boardLabel.setVisible(destOption.equals(SendToLocation.DEST_LOCATION) || destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            this.zoneInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_ZONE));
            this.zoneLabel.setVisible(destOption.equals(SendToLocation.DEST_ZONE));
            this.regionInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_REGION));
            this.regionLabel.setVisible(destOption.equals(SendToLocation.DEST_REGION));
            this.propertyInput.getControls().setVisible(destCounter);
            this.propertyLabel.setVisible(destCounter);
            this.gridLocationInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            this.gridLabel.setVisible(destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            Decorator.repack(this.controls);
        }

        private void clearBoard() {
            this.boardNameInput.setValue("");
        }

        private void clearMap() {
            this.mapIdInput.setValue("");
        }

        private void selectBoard() {
            ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Board.class);
            d.setVisible(true);
            if (d.getTarget() != null) {
                Board b = (Board)d.getTarget();
                this.boardNameInput.setValue(b.getName());
            }
        }

        private void selectMap() {
            ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Map.class);
            d.setVisible(true);
            if (d.getTarget() != null) {
                Map map = (Map)d.getTarget();
                this.mapIdInput.setValue(map.getMapName());
            }
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.mapIdInput.getValueString()).append(this.boardNameInput.getValueString()).append(this.xInput.getValueString()).append(this.yInput.getValueString()).append(this.backNameInput.getValueString()).append(this.backKeyInput.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString()).append(this.newDestInput.getValueString().charAt(0)).append(this.zoneInput.getValueString()).append(this.regionInput.getValueString()).append(this.propertyInput.getValueString()).append(this.gridLocationInput.getValueString());
            return SendToLocation.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

