/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.i18n.LocaleConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.i18n.VassalResourceBundle;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ReadErrorDialog;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Locale;
import java.util.Properties;

public class Translation
extends AbstractConfigurable
implements Comparable<Translation> {
    public static final String LOCALE = "locale";
    protected Locale locale = new Locale(Locale.getDefault().getLanguage());
    protected boolean dirty = false;
    protected Properties localProperties;

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.Translation.locale")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{LocalePrompt.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{LOCALE};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (LOCALE.equals(key)) {
            return LocaleConfigurer.localeToString(this.locale);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (LOCALE.equals(key)) {
            this.locale = LocaleConfigurer.stringToLocale((String)value);
            this.setConfigureName(this.locale.getDisplayName());
        }
    }

    protected String getDescription() {
        return this.locale.getDisplayName(Locale.getDefault());
    }

    public String getLanguageCode() {
        return this.locale.getLanguage();
    }

    @Override
    public String getConfigureName() {
        return this.getDescription();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
        Localization.getInstance().removeTranslation(this);
    }

    @Override
    public void addTo(Buildable parent) {
        Localization.getInstance().addTranslation(this);
        if (!GameModule.getGameModule().isLocalizationEnabled()) {
            try {
                this.loadProperties();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setProperty(String key, String value) {
        if (value == null || value.length() == 0) {
            this.getProperties().remove(key);
        } else {
            this.getProperties().setProperty(key, value);
        }
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String translate(String key) {
        return this.getProperties().getProperty(key);
    }

    protected void loadProperties() throws IOException {
        GameModule g;
        if (this.localProperties == null) {
            this.localProperties = new Properties();
        }
        if ((g = GameModule.getGameModule()) != null) {
            DataArchive mda = g.getDataArchive();
            try (InputStream inner = mda.getInputStream(this.getBundleFileName());
                 BufferedInputStream in = new BufferedInputStream(inner);){
                this.localProperties.load(in);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                this.dirty = false;
                return;
            }
        }
        this.dirty = false;
    }

    protected VassalResourceBundle getBundle() throws IOException {
        DataArchive mda = GameModule.getGameModule().getDataArchive();
        try (InputStream inner = mda.getInputStream(this.getBundleFileName());){
            VassalResourceBundle vassalResourceBundle;
            try (BufferedInputStream in = new BufferedInputStream(inner);){
                vassalResourceBundle = new VassalResourceBundle(in);
            }
            return vassalResourceBundle;
        }
    }

    public void reloadProperties() throws IOException {
        this.localProperties = new Properties();
        this.loadProperties();
    }

    protected void saveProperties() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getProperties().store(out, Resources.getString("Editor.Translation.module_translation"));
        ArchiveWriter writer = GameModule.getGameModule().getArchiveWriter();
        if (writer != null) {
            writer.addFile(this.getBundleFileName(), out.toByteArray());
            this.dirty = false;
        }
    }

    public Properties getProperties() {
        if (this.localProperties == null) {
            try {
                this.loadProperties();
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, this.getBundleFileName());
                this.localProperties = new Properties();
            }
        }
        return this.localProperties;
    }

    public String getBundleName() {
        return "Module_" + this.locale.getLanguage() + (String)(this.locale.getCountry().length() > 0 ? "_" + this.locale.getCountry() : "");
    }

    public String getBundleFileName() {
        return this.getBundleName() + ".properties";
    }

    public boolean equals(Object obj) {
        return obj instanceof Translation && this.compareTo((Translation)obj) == 0;
    }

    @Override
    public int compareTo(Translation o) {
        return this.getDescription().compareTo(o.getDescription());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static class LocalePrompt
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new LocaleConfigurer(key, name, "");
        }
    }
}

