/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.tilecache.TileUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

class TileTask
implements Callable<Void> {
    protected final BufferedImage src;
    protected final File dst;
    protected final int tx;
    protected final int ty;
    protected final int tw;
    protected final int th;
    protected final int dw;
    protected final int dh;

    public TileTask(BufferedImage src, File dst, int tx, int ty, int tw, int th, int dw, int dh) {
        this.src = src;
        this.dst = dst;
        this.tx = tx;
        this.ty = ty;
        this.tw = tw;
        this.th = th;
        this.dw = dw;
        this.dh = dh;
    }

    @Override
    public Void call() throws IOException {
        BufferedImage tile = this.sliceTile();
        TileUtils.write(tile, this.dst);
        return null;
    }

    protected BufferedImage sliceTile() {
        int atw = Math.min(this.tw, this.dw - this.tx * this.tw);
        int ath = Math.min(this.th, this.dh - this.ty * this.th);
        int type = this.src.getType();
        BufferedImage tile = new BufferedImage(atw, ath, type);
        Graphics2D g = tile.createGraphics();
        g.drawImage(this.src, 0, 0, atw, ath, this.tx * this.tw, this.ty * this.th, this.tx * this.tw + atw, this.ty * this.th + ath, null);
        g.dispose();
        return tile;
    }
}

