/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.search.ImageSearchTarget;
import VASSAL.tools.ComponentPathBuilder;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionElement
implements Buildable,
ImageSearchTarget {
    public static final String TARGET = "target";
    private Buildable extension;
    private Configurable[] targetPath;

    public ExtensionElement() {
    }

    public ExtensionElement(Buildable extension, Configurable[] targetPath) {
        this.extension = extension;
        this.targetPath = targetPath;
    }

    @Override
    public void add(Buildable child) {
        this.extension = child;
    }

    @Override
    public void build(Element e) {
        try {
            this.targetPath = ComponentPathBuilder.getInstance().getPath(e.getAttribute(TARGET));
        }
        catch (ComponentPathBuilder.PathFormatException e1) {
            throw new ExtensionsLoader.LoadExtensionException(e1.getMessage());
        }
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.extension = Builder.create((Element)n);
            break;
        }
    }

    public Buildable getExtension() {
        return this.extension;
    }

    public Configurable[] getTargetPath() {
        return this.targetPath;
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        el.setAttribute(TARGET, ComponentPathBuilder.getInstance().getId(this.targetPath));
        el.appendChild(this.extension.getBuildElement(doc));
        return el;
    }

    @Override
    public void addTo(Buildable parent) {
        GameModule target = this.targetPath.length == 0 ? GameModule.getGameModule() : this.targetPath[this.targetPath.length - 1];
        this.extension.addTo(target);
        target.add(this.extension);
    }

    @Override
    public SortedSet<String> getAllImageNames() {
        TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.extension instanceof ImageSearchTarget) {
            ((ImageSearchTarget)((Object)this.extension)).addImageNamesRecursively(s);
        }
        return s;
    }

    @Override
    public void addImageNamesRecursively(Collection<String> s) {
        if (this.extension instanceof ImageSearchTarget) {
            ((ImageSearchTarget)((Object)this.extension)).addImageNamesRecursively(s);
        }
    }

    @Override
    public SortedSet<String> getLocalImageNames() {
        TreeSet<String> s = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.extension instanceof ImageSearchTarget) {
            ((ImageSearchTarget)((Object)this.extension)).addLocalImageNames(s);
        }
        return s;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.extension instanceof ImageSearchTarget) {
            ((ImageSearchTarget)((Object)this.extension)).addLocalImageNames(s);
        }
    }
}

