/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ImageItem;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.LayoutConfigurer;
import VASSAL.build.module.gamepieceimage.Visualizable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GamePieceLayout
extends AbstractConfigurable
implements Visualizable {
    protected static final String NAME = "name";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String BORDER = "border";
    protected static final String ITEMS = "layout";
    protected static final String N = "Top";
    protected static final String S = "Bottom";
    protected static final String E = "Right";
    protected static final String W = "Left";
    protected static final String NE = "Top Right";
    protected static final String NW = "Top Left";
    protected static final String SE = "Bottom Right";
    protected static final String SW = "Bottom Left";
    protected static final String CENTER = "Center";
    protected static final int POS_L = 15;
    protected static final int POS_R = 85;
    protected static final int POS_T = 15;
    protected static final int POS_B = 85;
    protected static final int POS_C = 50;
    protected static final String BORDER_PLAIN = "Plain";
    protected static final String BORDER_FANCY = "Fancy";
    protected static final String BORDER_3D = "3D";
    protected static final String BORDER_NONE = "None";
    public static final String[] LOCATIONS = new String[]{"Center", "Top", "Bottom", "Right", "Left", "Top Right", "Top Left", "Bottom Right", "Bottom Left"};
    public static final String[] LOCATION_I18N_KEYS = new String[]{"Editor.center", "Editor.top", "Editor.bottom", "Editor.right", "Editor.left", "Editor.top_right", "Editor.top_left", "Editor.bottom_right", "Editor.bottom_left"};
    public static final int[] X_POS = new int[]{50, 50, 50, 85, 15, 85, 15, 85, 15};
    public static final int[] Y_POS = new int[]{50, 15, 85, 50, 50, 15, 15, 85, 85};
    protected static final Map<String, String> compass = new HashMap<String, String>();
    protected int width = 54;
    protected int height = 54;
    protected String border = "3D";
    protected GamePieceImage imageDefn;
    protected Image visImage;
    protected List<Item> items = new ArrayList<Item>();

    public static String getDisplayLocation(String location) {
        for (int i = 0; i < LOCATIONS.length; ++i) {
            if (!LOCATIONS[i].equals(location)) continue;
            return Resources.getString(LOCATION_I18N_KEYS[i]);
        }
        return location;
    }

    public static String getCompassPoint(String location) {
        return compass.get(location);
    }

    public Point getPosition(Item item) {
        int y;
        int x;
        String s = GamePieceLayout.getCompassPoint(item.getLocation());
        Dimension d = item.getSize();
        switch (s.charAt(s.length() - 1)) {
            case 'E': {
                x = this.getLayoutWidth() - d.width;
                break;
            }
            case 'W': {
                x = 0;
                break;
            }
            default: {
                x = this.getLayoutWidth() / 2 - d.width / 2;
            }
        }
        switch (s.charAt(0)) {
            case 'N': {
                y = 0;
                break;
            }
            case 'S': {
                y = this.getLayoutHeight() - d.height;
                break;
            }
            default: {
                y = this.getLayoutHeight() / 2 - d.height / 2;
            }
        }
        return new Point(x + item.getXoffset(), y + item.getYoffset());
    }

    public GamePieceLayout() {
        this.name = "";
        this.imageDefn = new GamePieceImage(this);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.GamePieceLayout.counter_width"), Resources.getString("Editor.GamePieceLayout.counter_height"), Resources.getString("Editor.GamePieceLayout.counter_style"), ""};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, Integer.class, BorderConfig.class, LayoutConfig.class};
    }

    public boolean isColoredBorder() {
        return this.border.equals(BORDER_PLAIN) || this.border.equals(BORDER_FANCY);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, WIDTH, HEIGHT, BORDER, ITEMS};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
        } else if (WIDTH.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.setWidth((Integer)value);
        } else if (HEIGHT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.setHeight((Integer)value);
        } else if (BORDER.equals(key)) {
            this.border = (String)value;
        } else if (ITEMS.equals(key)) {
            this.decodeItemList((String)value);
        }
        this.invalidate();
        LayoutConfig.refresh();
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (WIDTH.equals(key)) {
            return Integer.toString(this.getLayoutWidth());
        }
        if (HEIGHT.equals(key)) {
            return Integer.toString(this.getLayoutHeight());
        }
        if (BORDER.equals(key)) {
            return this.border;
        }
        if (ITEMS.equals(key)) {
            return this.encodeItemList();
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayouts.html");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{GamePieceImage.class};
    }

    @Override
    public void addTo(Buildable parent) {
        this.setAllAttributesUntranslatable();
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GamePieceLayout.component_type");
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getLayoutWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getLayoutHeight() {
        return this.height;
    }

    public String getBorder() {
        return this.border;
    }

    public List<Item> getItems() {
        return this.items;
    }

    protected int getItemCount() {
        return this.items.size();
    }

    protected Item getItem(int n) {
        return this.items.get(n);
    }

    protected Item getItem(String name) {
        for (Item item : this.items) {
            if (!item.getConfigureName().equals(name)) continue;
            return item;
        }
        return null;
    }

    protected void removeItem(int n) {
        this.items.remove(n);
    }

    public void addItem(Item i) {
        this.items.add(i);
    }

    public void moveItem(int from, int to) {
        Item temp = this.items.get(to);
        this.items.set(to, this.items.get(from));
        this.items.set(from, temp);
    }

    @Override
    public Image getVisualizerImage() {
        if (this.visImage == null) {
            this.rebuildVisualizerImage();
        }
        return this.visImage;
    }

    public Image buildImage(GamePieceImage defn) {
        BufferedImage image = ImageUtils.createCompatibleTranslucentImage(Math.max(this.width, 1), Math.max(this.height, 1));
        Graphics2D g = image.createGraphics();
        Color bgColor = defn.getBgColor().getColor();
        g.setColor(bgColor);
        if (this.getBorder().equals(BORDER_3D)) {
            if (bgColor != null) {
                g.fill3DRect(0, 0, this.width, this.height, true);
            }
        } else {
            if (bgColor != null) {
                g.fillRect(0, 0, this.width, this.height);
            }
            if (this.getBorder().equals(BORDER_PLAIN) || this.getBorder().equals(BORDER_FANCY)) {
                Color bg = bgColor == null ? Color.WHITE : bgColor;
                g.setColor(defn.getBorderColor().getColor());
                g.setStroke(new BasicStroke(1.0f, 1, 1));
                g.drawRect(0, 0, this.width - 1, this.height - 1);
                if (this.getBorder().equals(BORDER_FANCY)) {
                    Color lt = new Color(bg.getRed() / 2, bg.getGreen() / 2, bg.getBlue() / 2);
                    Color dk = new Color(bg.getRed() + (255 - bg.getRed()) / 2, bg.getGreen() + (255 - bg.getGreen()) / 2, bg.getBlue() + (255 - bg.getBlue()) / 2);
                    g.setColor(dk);
                    g.drawLine(1, 1, this.width - 3, 1);
                    g.drawLine(1, 2, 1, this.height - 3);
                    g.setColor(lt);
                    g.drawLine(this.width - 2, 2, this.width - 2, this.height - 2);
                    g.drawLine(2, this.height - 2, this.width - 3, this.height - 2);
                }
            }
        }
        for (Item item : this.items) {
            if (item == null) continue;
            item.draw(g, defn);
        }
        g.dispose();
        return image;
    }

    public void refresh() {
        this.invalidate();
        LayoutConfig.refresh();
    }

    protected void invalidate() {
        for (GamePieceImage i : this.getComponentsOf(GamePieceImage.class)) {
            i.rebuildVisualizerImage();
        }
    }

    protected void decodeItemList(String string) {
        this.items.clear();
        if (string.length() > 0) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(string, ',');
            while (sd.hasMoreTokens()) {
                Item item = Item.decode(this, sd.nextToken());
                this.addItem(item);
            }
        }
    }

    protected String encodeItemList() {
        String[] list = new String[this.getItemCount()];
        int i = 0;
        for (Item item : this.items) {
            list[i++] = item.encode();
        }
        SequenceEncoder se = new SequenceEncoder('#');
        se.append(list);
        return se.getValue();
    }

    @Override
    public int getVisualizerHeight() {
        return this.getLayoutHeight();
    }

    @Override
    public int getVisualizerWidth() {
        return this.getLayoutWidth();
    }

    @Override
    public void rebuildVisualizerImage() {
        this.visImage = this.buildImage(this.imageDefn);
    }

    public void setImageDefn(GamePieceImage d) {
        this.imageDefn = d;
    }

    public GamePieceImage getGenericDefn(String defnName) {
        for (Buildable b : this.getBuildables()) {
            GamePieceImage gpi;
            if (!(b instanceof GamePieceImage) || !(gpi = (GamePieceImage)b).getConfigureName().equals(defnName)) continue;
            return gpi;
        }
        return null;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        for (Item item : this.items) {
            if (!(item instanceof ImageItem)) continue;
            s.add(((ImageItem)item).getAttributeValueString("image"));
        }
    }

    static {
        compass.put(N, "N");
        compass.put(S, "S");
        compass.put(E, "E");
        compass.put(W, "W");
        compass.put(NE, "NE");
        compass.put(NW, "NW");
        compass.put(SE, "SE");
        compass.put(SW, "SW");
        compass.put(CENTER, "CENTER");
    }

    public static class BorderConfig
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{GamePieceLayout.BORDER_PLAIN, GamePieceLayout.BORDER_FANCY, GamePieceLayout.BORDER_3D, GamePieceLayout.BORDER_NONE};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.GamePieceLayout.plain_border", "Editor.GamePieceLayout.fancy_border", "Editor.GamePieceLayout.3D_border", "Editor.GamePieceLayout.no_border"};
        }
    }

    public static class LayoutConfig
    implements ConfigurerFactory {
        protected static LayoutConfigurer configurer;

        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            configurer = new LayoutConfigurer(key, name, (GamePieceLayout)c);
            return configurer;
        }

        public static void refresh() {
            if (configurer != null) {
                configurer.repack();
            }
        }
    }
}

