/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameState;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class StackMetrics
extends AbstractConfigurable {
    protected int exSepX;
    protected int exSepY;
    protected int unexSepX;
    protected int unexSepY;
    protected boolean disabled;
    protected KeyStroke topKey = KeyStroke.getKeyStroke(38, 0);
    protected KeyStroke bottomKey = KeyStroke.getKeyStroke(40, 0);
    protected KeyStroke upKey = KeyStroke.getKeyStroke(39, 0);
    protected KeyStroke downKey = KeyStroke.getKeyStroke(37, 0);
    protected PieceFilter unselectedVisible;
    protected PieceFilter selectedVisible;
    protected Color blankColor;
    public static final String EXSEP_X = "exSepX";
    public static final String EXSEP_Y = "exSepY";
    public static final String UNEXSEP_X = "unexSepX";
    public static final String UNEXSEP_Y = "unexSepY";
    public static final String DISABLED = "disabled";
    public static final String TOP_KEY = "top";
    public static final String BOTTOM_KEY = "bottom";
    public static final String UP_KEY = "up";
    public static final String DOWN_KEY = "down";
    public static final String COLOR = "color";
    public static final int DEFAULT_EXSEP_X = 6;
    public static final int DEFAULT_EXSEP_Y = 18;
    public static final int DEFAULT_UNEXSEP_X = 2;
    public static final int DEFAULT_UNEXSEP_Y = 4;
    protected Map map;
    private final VisibilityCondition cond = () -> !this.disabled;

    @Override
    public void setAttribute(String name, Object value) {
        if (EXSEP_X.equals(name)) {
            if (value instanceof String) {
                try {
                    this.exSepX = Integer.parseInt((String)value);
                }
                catch (NumberFormatException NaN) {
                    this.exSepX = 6;
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.bad_preference", EXSEP_X, "StackMetrics"), (String)value, NaN));
                }
            } else if (value != null) {
                this.exSepX = (Integer)value;
            }
        } else if (EXSEP_Y.equals(name)) {
            if (value instanceof String) {
                try {
                    this.exSepY = Integer.parseInt((String)value);
                }
                catch (NumberFormatException NaN) {
                    this.exSepY = 18;
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.bad_preference", EXSEP_Y, "StackMetrics"), (String)value, NaN));
                }
            } else if (value != null) {
                this.exSepY = (Integer)value;
            }
        } else if (UNEXSEP_X.equals(name)) {
            if (value instanceof String) {
                try {
                    this.unexSepX = Integer.parseInt((String)value);
                }
                catch (NumberFormatException NaN) {
                    this.unexSepX = 2;
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.bad_preference", UNEXSEP_X, "StackMetrics"), (String)value, NaN));
                }
            } else if (value != null) {
                this.unexSepX = (Integer)value;
            }
        } else if (UNEXSEP_Y.equals(name)) {
            if (value instanceof String) {
                try {
                    this.unexSepY = Integer.parseInt((String)value);
                }
                catch (NumberFormatException NaN) {
                    this.unexSepY = 4;
                    ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.bad_preference", UNEXSEP_Y, "StackMetrics"), (String)value, NaN));
                }
            } else if (value != null) {
                this.unexSepY = (Integer)value;
            }
        } else if (DISABLED.equals(name)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.disabled = (Boolean)value;
        } else if (TOP_KEY.equals(name)) {
            this.topKey = HotKeyConfigurer.decode((String)value);
        } else if (BOTTOM_KEY.equals(name)) {
            this.bottomKey = HotKeyConfigurer.decode((String)value);
        } else if (UP_KEY.equals(name)) {
            this.upKey = HotKeyConfigurer.decode((String)value);
        } else if (DOWN_KEY.equals(name)) {
            this.downKey = HotKeyConfigurer.decode((String)value);
        } else if (COLOR.equals(name)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.blankColor = (Color)value;
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if (EXSEP_X.equals(name)) {
            return String.valueOf(this.exSepX);
        }
        if (EXSEP_Y.equals(name)) {
            return String.valueOf(this.exSepY);
        }
        if (UNEXSEP_X.equals(name)) {
            return String.valueOf(this.unexSepX);
        }
        if (UNEXSEP_Y.equals(name)) {
            return String.valueOf(this.unexSepY);
        }
        if (DISABLED.equals(name)) {
            return String.valueOf(this.disabled);
        }
        if (TOP_KEY.equals(name)) {
            return HotKeyConfigurer.encode(this.topKey);
        }
        if (BOTTOM_KEY.equals(name)) {
            return HotKeyConfigurer.encode(this.bottomKey);
        }
        if (UP_KEY.equals(name)) {
            return HotKeyConfigurer.encode(this.upKey);
        }
        if (DOWN_KEY.equals(name)) {
            return HotKeyConfigurer.encode(this.downKey);
        }
        if (COLOR.equals(name)) {
            return this.blankColor == null ? null : ColorConfigurer.colorToString(this.blankColor);
        }
        return null;
    }

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        this.map.setStackMetrics(this);
    }

    public StackMetrics() {
        this(false, 6, 18, 2, 4);
    }

    public StackMetrics(boolean dis, int exSx, int exSy, int unexSx, int unexSy) {
        this.disabled = dis;
        this.exSepX = exSx;
        this.exSepY = exSy;
        this.unexSepX = unexSx;
        this.unexSepY = unexSy;
        this.unselectedVisible = piece -> !Boolean.TRUE.equals(piece.getProperty("Invisible")) && !Boolean.TRUE.equals(piece.getProperty("Selected"));
        this.selectedVisible = piece -> !Boolean.TRUE.equals(piece.getProperty("Invisible")) && Boolean.TRUE.equals(piece.getProperty("Selected"));
    }

    public void draw(Stack stack, Graphics g, int x, int y, Component obs, double zoom) {
        Highlighter highlighter = stack.getMap() == null ? BasicPiece.getHighlighter() : stack.getMap().getHighlighter();
        Point[] positions = new Point[stack.getPieceCount()];
        this.getContents(stack, positions, null, null, x, y);
        PieceIterator e = new PieceIterator(stack.getPiecesIterator(), this.unselectedVisible);
        while (e.hasMoreElements()) {
            GamePiece next = e.nextPiece();
            int index = stack.indexOf(next);
            if (index < 0) continue;
            int nextX = x + (int)(zoom * (double)(positions[index].x - x));
            int nextY = y + (int)(zoom * (double)(positions[index].y - y));
            if (stack.isExpanded() || !e.hasMoreElements()) {
                next.draw(g, nextX, nextY, obs, zoom);
                continue;
            }
            this.drawUnexpanded(next, g, nextX, nextY, obs, zoom);
        }
        stack.asList().stream().filter(gamePiece -> this.selectedVisible.accept((GamePiece)gamePiece)).forEach(gamePiece -> {
            int index = stack.indexOf((GamePiece)gamePiece);
            if (index >= 0) {
                int nextX = x + (int)(zoom * (double)(positions[index].x - x));
                int nextY = y + (int)(zoom * (double)(positions[index].y - y));
                gamePiece.draw(g, nextX, nextY, obs, zoom);
                highlighter.draw((GamePiece)gamePiece, g, nextX, nextY, obs, zoom);
            }
        });
    }

    public void draw(Stack stack, Point location, Graphics g, Map map, double zoom, Rectangle visibleRect) {
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        JComponent view = map.getView();
        Highlighter highlighter = map.getHighlighter();
        Point mapLocation = map.drawingToMap(location, os_scale);
        Rectangle region = visibleRect == null ? null : map.drawingToMap(visibleRect, os_scale);
        Point[] positions = new Point[stack.getPieceCount()];
        Rectangle[] bounds = region == null ? null : new Rectangle[stack.getPieceCount()];
        this.getContents(stack, positions, null, bounds, mapLocation.x, mapLocation.y);
        PieceIterator e = new PieceIterator(stack.getPiecesIterator(), this.unselectedVisible);
        while (e.hasMoreElements()) {
            GamePiece next = e.nextPiece();
            int index = stack.indexOf(next);
            if (index < 0) continue;
            Point pt = map.mapToDrawing(positions[index], os_scale);
            if (bounds != null && !this.isVisible(region, bounds[index])) continue;
            if (stack.isExpanded() || !e.hasMoreElements()) {
                next.draw(g, pt.x, pt.y, view, zoom);
                continue;
            }
            this.drawUnexpanded(next, g, pt.x, pt.y, view, zoom);
        }
        stack.asList().stream().filter(gamePiece -> this.selectedVisible.accept((GamePiece)gamePiece)).forEach(gamePiece -> {
            int index = stack.indexOf((GamePiece)gamePiece);
            if (index >= 0 && (bounds == null || this.isVisible(region, bounds[index]))) {
                Point pt = map.mapToDrawing(positions[index], os_scale);
                gamePiece.draw(g, pt.x, pt.y, view, zoom);
                highlighter.draw((GamePiece)gamePiece, g, pt.x, pt.y, view, zoom);
            }
        });
    }

    private boolean isVisible(Rectangle region, Rectangle bounds) {
        boolean visible = true;
        if (region != null) {
            visible = region.intersects(bounds);
        }
        return visible;
    }

    protected void drawUnexpanded(GamePiece p, Graphics g, int x, int y, Component obs, double zoom) {
        if (this.blankColor == null) {
            p.draw(g, x, y, obs, zoom);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(this.blankColor);
            Shape s = p.getShape();
            AffineTransform t = AffineTransform.getScaleInstance(zoom, zoom);
            t.translate((double)x / zoom, (double)y / zoom);
            s = t.createTransformedShape(s);
            g2d.fill(s);
            g.setColor(Color.black);
            g2d.draw(s);
        }
    }

    public Color getBlankColor() {
        return this.blankColor;
    }

    public int getContents(Stack parent, Point[] positions, Shape[] shapes, Rectangle[] boundingBoxes, int x, int y) {
        int count = parent.getMaximumVisiblePieceCount();
        if (positions != null) {
            count = Math.min(count, positions.length);
        }
        if (boundingBoxes != null) {
            count = Math.min(count, boundingBoxes.length);
        }
        if (shapes != null) {
            count = Math.min(count, shapes.length);
        }
        int dx = parent.isExpanded() ? this.exSepX : this.unexSepX;
        int dy = parent.isExpanded() ? this.exSepY : this.unexSepY;
        Point currentPos = null;
        Rectangle currentSelBounds = null;
        for (int index = 0; index < count; ++index) {
            GamePiece child = parent.getPieceAt(index);
            if (Boolean.TRUE.equals(child.getProperty("Invisible"))) {
                Rectangle blank = new Rectangle(x, y, 0, 0);
                if (positions != null) {
                    positions[index] = blank.getLocation();
                }
                if (boundingBoxes != null) {
                    boundingBoxes[index] = blank;
                }
                if (shapes == null) continue;
                shapes[index] = blank;
                continue;
            }
            child.setProperty("useUnrotatedShape", Boolean.TRUE);
            Rectangle nextSelBounds = child.getShape().getBounds();
            child.setProperty("useUnrotatedShape", Boolean.FALSE);
            Point nextPos = new Point(0, 0);
            if (currentPos == null) {
                currentSelBounds = nextSelBounds;
                currentSelBounds.translate(x, y);
                nextPos = currentPos = new Point(x, y);
            } else {
                this.nextPosition(currentPos, currentSelBounds, nextPos, nextSelBounds, dx, dy);
            }
            if (positions != null) {
                positions[index] = nextPos;
            }
            if (boundingBoxes != null) {
                Rectangle bbox = child.boundingBox();
                bbox.translate(nextPos.x, nextPos.y);
                boundingBoxes[index] = bbox;
            }
            if (shapes != null) {
                Shape s = child.getShape();
                shapes[index] = s = AffineTransform.getTranslateInstance(nextPos.x, nextPos.y).createTransformedShape(s);
            }
            currentPos = nextPos;
            currentSelBounds = nextSelBounds;
        }
        return count;
    }

    protected void nextPosition(Point currentPos, Rectangle currentBounds, Point nextPos, Rectangle nextBounds, int dx, int dy) {
        int deltaX = dx > 0 ? currentBounds.x + dx - nextBounds.x : (dx < 0 ? currentBounds.x + currentBounds.width - nextBounds.width + dx - nextBounds.x : currentPos.x - nextPos.x);
        int deltaY = dy > 0 ? currentBounds.y + currentBounds.height - nextBounds.height - nextBounds.y - dy : (dy < 0 ? currentBounds.y - dy - nextBounds.y : currentPos.y - nextPos.y);
        nextBounds.translate(deltaX, deltaY);
        nextPos.translate(deltaX, deltaY);
    }

    public Point relativePosition(Stack parent, GamePiece c) {
        int index = Math.min(parent.indexOf(c), parent.getMaximumVisiblePieceCount() - 1);
        if (index < 0) {
            return new Point(0, 0);
        }
        Point[] pos = new Point[parent.getMaximumVisiblePieceCount()];
        this.getContents(parent, pos, null, null, 0, 0);
        return pos[index];
    }

    public boolean isStackingEnabled() {
        return !this.disabled;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Stacking.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "StackingOptions");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{DISABLED, EXSEP_X, EXSEP_Y, UNEXSEP_X, UNEXSEP_Y, COLOR, TOP_KEY, BOTTOM_KEY, UP_KEY, DOWN_KEY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.Stacking.disable"), Resources.getString("Editor.Stacking.h_expand"), Resources.getString("Editor.Stacking.v_expand"), Resources.getString("Editor.Stacking.hnon_expand"), Resources.getString("Editor.Stacking.vnon_expand"), Resources.getString("Editor.Stacking.color_nonexpand")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Boolean.class, Integer.class, Integer.class, Integer.class, Integer.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(EXSEP_X, EXSEP_Y, UNEXSEP_X, UNEXSEP_Y, COLOR).contains(name)) {
            return this.cond;
        }
        return null;
    }

    public Stack createStack(GamePiece p) {
        return this.createStack(p, false);
    }

    public Stack createStack(GamePiece p, boolean force) {
        return this.isStackingEnabled() || force ? new Stack(p) : null;
    }

    public KeyStroke getMoveUpKey() {
        return this.upKey;
    }

    public KeyStroke getMoveDownKey() {
        return this.downKey;
    }

    public KeyStroke getMoveTopKey() {
        return this.topKey;
    }

    public KeyStroke getMoveBottomKey() {
        return this.bottomKey;
    }

    public Command placeOrMerge(GamePiece fixed, GamePiece moving) {
        if (this.disabled) {
            return fixed.getMap().placeAt(moving, fixed.getPosition());
        }
        return this.merge(fixed, moving);
    }

    public Command merge(GamePiece fixed, GamePiece moving) {
        Command comm;
        if (fixed instanceof Stack && ((Stack)fixed).topPiece() != null) {
            comm = this.merge(((Stack)fixed).topPiece(), moving);
        } else {
            int index;
            MoveTracker tracker = new MoveTracker(moving);
            comm = new NullCommand();
            Stack fixedParent = fixed.getParent();
            int n = index = fixedParent == null ? 0 : fixedParent.indexOf(fixed) + 1;
            if (moving != fixed && moving != fixedParent) {
                boolean isNewPiece;
                GameState gs = GameModule.getGameModule().getGameState();
                boolean bl = isNewPiece = gs.getPieceForId(moving.getId()) == null;
                if (fixedParent == null) {
                    if (fixed instanceof Stack) {
                        fixedParent = (Stack)fixed;
                        index = fixedParent.getPieceCount();
                    } else {
                        fixedParent = this.createStack(fixed, true);
                        comm = comm.append(fixed.getMap().placeAt(fixedParent, fixedParent.getPosition()));
                        index = 1;
                    }
                }
                if (isNewPiece) {
                    gs.addPiece(moving);
                    comm = comm.append(new AddPiece(moving));
                }
                if (moving instanceof Stack) {
                    for (GamePiece p : ((Stack)moving).asList()) {
                        MoveTracker t = new MoveTracker(p);
                        fixedParent.insertChild(p, index++);
                        comm = comm.append(t.getMoveCommand());
                    }
                } else {
                    if (moving.getParent() == fixedParent && fixedParent != null && fixedParent.indexOf(moving) < index) {
                        --index;
                    }
                    if (moving.getMap() != null && moving.getMap() != this.map) {
                        moving.getMap().removePiece(moving);
                    }
                    fixedParent.insert(moving, index);
                    comm = comm.append(tracker.getMoveCommand());
                }
            }
        }
        GameModule.getGameModule().getIndexManager().pieceMoved(moving, this.map);
        return comm;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return true;
    }
}

