/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker;

import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.i18n.Resources;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class BoardSlot
extends JPanel
implements Icon,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final String prompt;
    protected BoardPicker picker;
    protected Board board = null;
    protected JComboBox<String> boards;
    protected JCheckBox reverseCheckBox;

    public BoardSlot(BoardPicker bp) {
        this(bp, Resources.getString("BoardPicker.select_board"));
    }

    public BoardSlot(BoardPicker bp, String prompt) {
        String[] lbn;
        this.prompt = prompt;
        this.picker = bp;
        this.boards = new JComboBox();
        this.boards.addItem(prompt);
        for (String s : lbn = this.picker.getAllowableLocalizedBoardNames()) {
            this.boards.addItem(s);
        }
        this.boards.setSelectedIndex(lbn.length == 1 ? 1 : 0);
        this.boards.addActionListener(this);
        this.reverseCheckBox = new JCheckBox(Resources.getString("BoardPicker.flip"));
        this.reverseCheckBox.addItemListener(e -> {
            if (this.getBoard() != null) {
                this.getBoard().setReversed(this.reverseCheckBox.isSelected());
                this.picker.repaint();
            }
        });
        this.reverseCheckBox.setVisible(false);
        this.setLayout(new OverlayLayout(this));
        JPanel p = new JPanel();
        Box b = Box.createHorizontalBox();
        b.add(this.boards);
        b.add(this.reverseCheckBox);
        p.add(b);
        p.setOpaque(false);
        p.setAlignmentX(0.5f);
        JLabel l = new JLabel(this);
        l.setAlignmentX(0.5f);
        this.add(p);
        this.add(l);
        this.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.prompt.equals(this.boards.getSelectedItem())) {
            this.setBoard(null);
        } else {
            String selectedBoard = (String)this.boards.getSelectedItem();
            if (selectedBoard != null) {
                Board b = this.picker.getLocalizedBoard(selectedBoard);
                if (this.picker.getBoardsFromControls().contains(b)) {
                    b = b.copy();
                }
                this.setBoard(b);
            }
        }
    }

    public Board getBoard() {
        return this.board;
    }

    public void setBoard(Board b) {
        this.board = b;
        if (b != null) {
            this.reverseCheckBox.setVisible("true".equals(b.getAttributeValueString("reversible")));
            this.reverseCheckBox.setSelected(b.isReversed());
            this.board = b;
            this.setSize(this.getPreferredSize());
            this.revalidate();
            this.repaint();
        } else {
            this.reverseCheckBox.setVisible(false);
            this.revalidate();
            this.setSize(this.getPreferredSize());
            this.repaint();
        }
    }

    @Override
    public int getIconHeight() {
        if (this.board != null) {
            return (int)(this.picker.getSlotScale() * (double)this.board.bounds().height);
        }
        if (this == this.picker.getSlot(0) || this.picker.getSlot(0) == null) {
            return this.picker.getDefaultSlotSize().height;
        }
        return this.picker.getSlot(0).getIconHeight();
    }

    @Override
    public int getIconWidth() {
        if (this.board != null) {
            return (int)(this.picker.getSlotScale() * (double)this.board.bounds().width);
        }
        if (this == this.picker.getSlot(0) || this.picker.getSlot(0) == null) {
            return this.picker.getDefaultSlotSize().width;
        }
        return this.picker.getSlot(0).getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform orig_t = g2d.getTransform();
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        g2d.setTransform(SwingUtils.descaleTransform(orig_t));
        x = (int)((double)x * os_scale);
        y = (int)((double)y * os_scale);
        if (this.board != null) {
            this.board.draw(g, x, y, this.picker.getSlotScale() * os_scale, c);
        } else {
            int w = (int)((double)this.getIconWidth() * os_scale);
            int h = (int)((double)this.getIconHeight() * os_scale);
            g.clearRect(x, y, w, h);
        }
        g2d.setTransform(orig_t);
    }
}

