/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractFolder;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameState;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.properties.ScenarioPropertiesOptionTab;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.NotNullConfigureName;
import VASSAL.i18n.Resources;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ToolBarComponent;
import java.util.Collections;
import java.util.List;

public abstract class AbstractScenarioProperty
extends GlobalProperty {
    public static final String HOTKEY = "hotkey";
    public static final String SWITCH = "switch";
    protected ScenarioPropertiesOptionTab tab;
    protected NamedKeyStroke hotkey = NamedKeyStroke.NULL_KEYSTROKE;
    protected boolean switchPosition = false;

    public boolean isSwitchPosition() {
        return this.switchPosition;
    }

    @Override
    public void addTo(Buildable parent) {
        GameModule gm;
        GameState gs;
        this.validator = new NotNullConfigureName(this);
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        if (parent instanceof ScenarioPropertiesOptionTab) {
            this.tab = (ScenarioPropertiesOptionTab)parent;
            parent = this.tab.getNonFolderAncestor();
        }
        if (parent != null) {
            this.parentContainer = (MutablePropertiesContainer)((Object)parent);
            this.property.addTo(this.parentContainer);
            this.tempToolbar.setDelegate((ToolBarComponent)((Object)parent));
            this.propertySource = (PropertySource)((Object)parent);
        }
        if (!(gs = (gm = GameModule.getGameModule()).getGameState()).getGameComponents().contains(this)) {
            gs.addGameComponent(this);
            gm.addCommandEncoder(this);
            this.setAllAttributesUntranslatable();
        }
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.GlobalProperty.initial_value"), Resources.getString("Editor.ScenarioProperties.prompt"), Resources.getString("Editor.ScenarioProperties.hotkey_on_change"), Resources.getString("Editor.BooleanScenarioProperty.property_right")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, this.getInitialValueClass(), String.class, NamedKeyStroke.class, Boolean.class};
    }

    public abstract Class<?> getInitialValueClass();

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", "initialValue", "description", HOTKEY, SWITCH};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if ("name".equals(key)) {
            super.setAttribute(key, value);
            this.property.setPropertyValue(this.initialValue);
        } else if (HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.hotkey = (NamedKeyStroke)value;
        } else if (SWITCH.equals(key)) {
            this.switchPosition = Boolean.TRUE.equals(value) || "true".equals(value);
        } else {
            super.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.hotkey);
        }
        if (SWITCH.equals(key)) {
            return String.valueOf(this.switchPosition);
        }
        return super.getAttributeValueString(key);
    }

    public abstract Configurer getOptionConfigurer();

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ScenarioProperties.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processOptionChange(Object newValue) {
        String oldValue = this.getPropertyValue();
        if (!oldValue.equals(newValue.toString())) {
            GameModule gm = GameModule.getGameModule();
            FormattedString reportFormat = this.tab.getReportFormat();
            Command c = new GlobalProperty.SetGlobalProperty(this, oldValue, newValue.toString());
            if (!reportFormat.getFormat().isBlank()) {
                reportFormat.clearProperties();
                reportFormat.setProperty("propertyName", this.getConfigureName());
                reportFormat.setProperty("propertyPrompt", this.getDescription());
                reportFormat.setProperty("tabName", this.tab.getConfigureName());
                reportFormat.setProperty("oldValue", oldValue);
                reportFormat.setProperty("newValue", newValue.toString());
                String report = reportFormat.getLocalizedText(this, "Editor.ScenarioOption.report_format");
                c = c.append(new Chatter.DisplayText(gm.getChatter(), "* " + report));
            }
            c.execute();
            if (!this.hotkey.isNull()) {
                boolean loggingPaused = gm.pauseLogging();
                try {
                    gm.fireKeyStroke(this.hotkey);
                }
                finally {
                    if (loggingPaused) {
                        c.append(gm.resumeLogging());
                    }
                }
            }
            GameModule.getGameModule().sendAndLog(c);
        }
    }

    public NamedKeyStroke getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(NamedKeyStroke hotkey) {
        this.hotkey = hotkey;
    }

    @Override
    public List<String> getExpressionList() {
        return Collections.emptyList();
    }
}

