/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.turn;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AbstractFolder;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedExpressionConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.BasicPiece;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import java.util.Collections;
import java.util.List;

public class TurnGlobalHotkey
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String HOTKEY = "hotkey";
    public static final String MATCH = "match";
    public static final String REPORT_FORMAT = "reportFormat";
    protected PropertyExpression match = new PropertyExpression();
    protected NamedKeyStroke hotkey;
    protected FormattedString format = new FormattedString();
    protected BasicPiece checkPiece = new BasicPiece();
    protected TurnTracker parent;

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.TurnGlobalHotkey.global_hotkey"), Resources.getString("Editor.TurnGlobalHotkey.match_properties"), Resources.getString("Editor.report_format")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, NamedKeyStroke.class, PropertyExpression.class, ReportFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, HOTKEY, MATCH, REPORT_FORMAT};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (HOTKEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.hotkey);
        }
        if (MATCH.equals(key)) {
            return this.match.getExpression();
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.format.getFormat();
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
        } else if (HOTKEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.hotkey = (NamedKeyStroke)value;
        } else if (MATCH.equals(key)) {
            this.match.setExpression((String)value);
        } else if (REPORT_FORMAT.equals(key)) {
            this.format.setFormat((String)value);
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.parent = null;
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof AbstractFolder) {
            parent = ((AbstractFolder)parent).getNonFolderAncestor();
        }
        if (parent instanceof TurnTracker) {
            this.parent = (TurnTracker)parent;
        }
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.TurnGlobalHotkey.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TurnTracker.html", "Hotkey");
    }

    public void apply() {
        if (this.match.isNull() || this.match.accept(this.checkPiece)) {
            String reportText;
            GameModule.getGameModule().fireKeyStroke(this.hotkey);
            if (this.parent != null) {
                this.parent.updateWidget();
            }
            if ((reportText = this.format.getLocalizedText(this, "Editor.report_format")).length() > 0) {
                Chatter.DisplayText c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + reportText);
                c.execute();
                GameModule.getGameModule().sendAndLog(c);
            }
        }
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.match.getExpression());
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.format.getFormat());
    }

    @Override
    public List<String> getPropertyList() {
        return Collections.emptyList();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(NamedHotKeyConfigurer.decode(this.getAttributeValueString(HOTKEY)));
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedExpressionConfigurer(key, name, new String[0]);
        }
    }
}

