/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.i18n.Resources;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.swing.DataArchiveHTMLEditorKit;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.io.IOUtils;

public class HtmlChart
extends Widget
implements MouseListener {
    public static final String NAME = "chartName";
    public static final String FILE = "fileName";
    private String fileName;
    private JScrollPane scroller;
    private JEditorPane htmlWin;

    private boolean isURL() {
        return this.htmlWin.getDocument().getProperty("stream") != null;
    }

    private void setText(String text) {
        this.htmlWin.setText(text);
        this.htmlWin.getDocument().putProperty("stream", null);
        this.htmlWin.revalidate();
    }

    private void setFile(String fname) {
        try {
            this.setText(this.getFile(fname));
        }
        catch (RuntimeException e) {
            ErrorDialog.dataWarning(new BadDataReport(this, Resources.getString("Editor.HTMLChart.html_failed_to_load", fname, this.getConfigureName(), e.getMessage()), fname, e, false));
        }
    }

    private String getFile(String fname) {
        if (fname == null) {
            return null;
        }
        String localizedFileName = GameModule.getGameModule().getResourcePathFinder().findHelpFileName(fname);
        DataArchive mda = GameModule.getGameModule().getDataArchive();
        String s = null;
        try (InputStream inner = mda.getInputStream(localizedFileName);
             BufferedInputStream in = new BufferedInputStream(inner);){
            s = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            ErrorDialog.dataWarning(new BadDataReport(this, Resources.getString("Error.not_found", "Chart"), fname, (Throwable)e));
        }
        return s;
    }

    @Override
    public Component getComponent() {
        if (this.htmlWin == null) {
            this.htmlWin = new JEditorPane();
            this.htmlWin.setEditable(false);
            this.htmlWin.setContentType("text/html");
            this.htmlWin.setEditorKit(new DataArchiveHTMLEditorKit(GameModule.getGameModule().getDataArchive()));
            this.htmlWin.addHyperlinkListener(new HtmlChartHyperlinkListener());
            this.htmlWin.addMouseListener(this);
            this.setFile(this.fileName);
            this.scroller = new ScrollPane(this.htmlWin);
            this.scroller.getViewport().setPreferredSize(this.htmlWin.getPreferredSize());
            this.scroller.getViewport().setAlignmentY(0.0f);
            Font f = new JLabel().getFont();
            FontMetrics fm = this.htmlWin.getFontMetrics(f);
            this.scroller.getVerticalScrollBar().setUnitIncrement(fm.getHeight() * 3);
        }
        return this.scroller;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void addTo(Buildable parent) {
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.HTMLChart.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.html", "HtmlChart");
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)val);
        } else if (FILE.equals(key)) {
            if (val instanceof File) {
                val = ((File)val).getName();
            }
            this.fileName = (String)val;
            if (this.htmlWin != null) {
                this.setFile(this.fileName);
            }
        } else if ("description".equals(key)) {
            this.description = (String)val;
        }
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, "description", FILE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.description_label"), Resources.getString("Editor.HTMLChart.html_file")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, File.class};
    }

    @Override
    public String getAttributeValueString(String name) {
        if (NAME.equals(name)) {
            return this.getConfigureName();
        }
        if (FILE.equals(name)) {
            return this.fileName;
        }
        if ("description".equals(name)) {
            return this.description;
        }
        return null;
    }

    protected void maybePopup(MouseEvent event) {
        if (event.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item = new JMenuItem(Resources.getString("Editor.HTMLChart.return_to_default_page"));
            item.addActionListener(e -> this.setFile(this.fileName));
            popup.add(item);
            if (event.getComponent().isShowing()) {
                popup.show(event.getComponent(), event.getX(), event.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybePopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybePopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(new File(this.fileName));
        h.addImageNames(s);
    }

    public class HtmlChartHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String desc = event.getDescription();
            if (!HtmlChart.this.isURL() && desc.indexOf(47) < 0 || event.getURL() == null) {
                int hash = desc.lastIndexOf(35);
                if (hash < 0) {
                    HtmlChart.this.setFile(desc);
                } else if (hash > 0) {
                    HtmlChart.this.setFile(desc.substring(0, hash));
                }
                if (hash != -1) {
                    HtmlChart.this.htmlWin.scrollToReference(desc.substring(hash + 1));
                }
            } else {
                try {
                    HtmlChart.this.htmlWin.setPage(event.getURL());
                }
                catch (IOException ex) {
                    ReadErrorDialog.error(ex, event.getURL().toString());
                }
                HtmlChart.this.htmlWin.revalidate();
            }
        }
    }

    @Deprecated(since="2020-10-10", forRemoval=true)
    public static class XTMLEditorKit
    extends HTMLEditorKit {
        private static final long serialVersionUID = 1L;

        @Override
        public ViewFactory getViewFactory() {
            return new XTMLFactory();
        }

        public static class XTMLFactory
        extends HTMLEditorKit.HTMLFactory
        implements ViewFactory {
            @Override
            public View create(Element element) {
                String imageName;
                HTML.Tag kind = (HTML.Tag)element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (kind != null && element.getName().equals("img") && !(imageName = (String)element.getAttributes().getAttribute(HTML.Attribute.SRC)).contains("/")) {
                    return new ImageComponentView(element);
                }
                return super.create(element);
            }

            public static class ImageComponentView
            extends ComponentView {
                protected String imageName;
                protected SourceOp srcOp;

                public ImageComponentView(Element e) {
                    super(e);
                    this.imageName = (String)e.getAttributes().getAttribute(HTML.Attribute.SRC);
                    this.srcOp = this.imageName == null || this.imageName.isBlank() ? null : Op.load(this.imageName);
                }

                @Override
                protected Component createComponent() {
                    JLabel label = new JLabel();
                    label.setIcon(new OpIcon(this.srcOp));
                    return label;
                }
            }
        }
    }
}

