/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.SynchEncoder;
import VASSAL.chat.WelcomeMessageServer;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.chat.peer2peer.PeerPool;
import VASSAL.chat.peer2peer.RoomManager;
import VASSAL.chat.peer2peer.RoomTracker;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.RoomInteractionControlsInitializer;
import VASSAL.chat.ui.ShowProfileAction;
import VASSAL.chat.ui.SimpleStatusControlsInitializer;
import VASSAL.chat.ui.SynchAction;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.i18n.Resources;
import VASSAL.tools.PropertiesEncoder;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Properties;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;

public class P2PClient
implements ChatServerConnection,
ChatControlsInitializer,
UserDialog,
PlayerEncoder {
    private SimplePlayer me;
    private PendingPeerManager ppm;
    protected ActivePeerManager peerMgr;
    private final PeerPool pool;
    private final WelcomeMessageServer welcomeMessageServer;
    private final RoomManager roomMgr;
    private final RoomTracker tracker;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private final CommandEncoder encoder;
    private boolean connected = false;
    private ServerStatus svrStatus;
    private final RoomInteractionControlsInitializer roomControls;
    private final SimpleStatusControlsInitializer playerStatusControls;
    private final SoundEncoder soundEncoder;
    private final SynchEncoder synchEncoder;
    private final PropertyChangeListener nameChangeListener;
    private final Properties params;

    public P2PClient(CommandEncoder encoder, WelcomeMessageServer welcomeMessageServer, PeerPool pool) {
        this(encoder, welcomeMessageServer, pool, new Properties());
    }

    public P2PClient(CommandEncoder encoder, WelcomeMessageServer welcomeMessageServer, PeerPool pool, Properties param) {
        this.encoder = encoder;
        this.welcomeMessageServer = welcomeMessageServer;
        this.pool = pool;
        this.params = param;
        this.ppm = new PendingPeerManager(this);
        this.ppm.setName("Pending Peer Manager");
        this.roomMgr = new RoomManager();
        this.tracker = new RoomTracker();
        this.me = new SimplePlayer("???");
        this.me.updateStatus();
        this.playerStatusControls = new SimpleStatusControlsInitializer(this, false);
        this.roomControls = new RoomInteractionControlsInitializer(this);
        this.roomControls.addPlayerActionFactory(ShowProfileAction.factory());
        this.roomControls.addPlayerActionFactory(SynchAction.factory(this));
        this.synchEncoder = new SynchEncoder(this, this);
        this.soundEncoder = new SoundEncoder(this);
        this.nameChangeListener = evt -> {
            SimplePlayer p = (SimplePlayer)this.getUserInfo();
            p.setName((String)evt.getNewValue());
            this.setUserInfo(p);
        };
    }

    public RoomManager getRoomMgr() {
        return this.roomMgr;
    }

    @Override
    public void sendToOthers(Command c) {
        String s = this.encoder.encode(c);
        if (s != null) {
            this.sendToOthers(s);
        }
    }

    public void sendToAll(String msg) {
        if (this.isConnected()) {
            this.sendToOthers(msg);
            this.showCHAT(((P2PPlayer)this.me).getInfo(), msg);
        }
    }

    public void sendToOthers(String msg) {
        if (this.isConnected()) {
            Player[] pl;
            Room myRoom = this.getRoom();
            for (Player p : pl = myRoom.getPlayerList().toArray(new Player[0])) {
                ActivePeer peer;
                if (p.equals(this.me) || (peer = this.peerMgr.getPeerListenerByID(((P2PPlayer)p).getInfo().getID())) == null) continue;
                peer.sendCHAT(msg);
            }
        }
    }

    @Override
    public void sendTo(Player recipient, Command c) {
        if (this.peerMgr != null) {
            this.peerMgr.getPeerListenerByInfo(((P2PPlayer)recipient).getInfo()).sendCHAT(this.encoder.encode(c));
        }
    }

    @Override
    public Room getRoom() {
        return this.roomMgr.getRoomContaining(this.me);
    }

    @Override
    public void setRoom(Room r) {
        if (this.me instanceof P2PPlayer) {
            ((P2PPlayer)this.me).setRoom(r.getName());
            if (this.isConnected()) {
                this.peerMgr.sendToAllNAME();
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(((P2PPlayer)this.me).getInfo()));
                Room newRoom = this.getRoom();
                this.propSupport.firePropertyChange("Room", null, newRoom);
            }
        }
    }

    @Override
    public Room[] getAvailableRooms() {
        return this.roomMgr.getRooms();
    }

    @Override
    public Player getUserInfo() {
        return this.me;
    }

    @Override
    public void setUserInfo(Player p) {
        if (this.me instanceof P2PPlayer) {
            ((P2PPlayer)this.me).setStats(p);
            if (this.isConnected()) {
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(((P2PPlayer)this.me).getInfo()));
                this.propSupport.firePropertyChange("Room", null, this.getRoom());
                this.peerMgr.sendToAllNAME();
            }
        } else {
            this.me = (SimplePlayer)p;
            this.me.updateStatus();
        }
        this.propSupport.firePropertyChange("Player", null, this.me);
    }

    @Override
    public void setConnected(boolean connect) {
        if (connect) {
            try {
                int port;
                try {
                    port = Integer.parseInt(this.params.getProperty("listenPort"));
                }
                catch (NumberFormatException ex) {
                    port = 5050;
                }
                MyInfo info = new MyInfo(null, port);
                info.setNetworkPw(this.params.getProperty("serverPw"));
                P2PPlayer p = new P2PPlayer(info);
                p.updateStatus();
                p.setName(this.me.getName());
                p.setRoom(this.roomMgr.getDefaultRoom().getName());
                p.setId(GameModule.getUserId() + "." + System.currentTimeMillis());
                this.setUserInfo(p);
                this.pool.initialize(p, this.ppm);
                if (this.peerMgr == null) {
                    this.peerMgr = new ActivePeerManager(info, this, this.ppm);
                }
                this.roomMgr.update(((P2PPlayer)this.me).getInfo());
                this.fireStatus(Resources.getString("Peer2Peer.server_connection_established", this.params.getProperty("listenPort")));
                this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.getRooms());
                this.propSupport.firePropertyChange("Room", null, this.getRoom());
                this.welcomeMessageServer.getWelcomeMessage().execute();
                this.connected = true;
                this.propSupport.firePropertyChange("Connected", null, Boolean.TRUE);
            }
            catch (IOException e) {
                this.fireStatus(Resources.getString("Peer2Peer.connection_error", e.getMessage()));
                this.fireStatus(Resources.getString("Peer2Peer.disconnected"));
                this.connected = false;
                this.propSupport.firePropertyChange("Connected", null, Boolean.FALSE);
            }
        } else if (this.isConnected()) {
            if (this.peerMgr != null) {
                this.peerMgr.clear();
            }
            this.roomMgr.clear();
            this.pool.disconnect();
            this.propSupport.firePropertyChange("AvailableRooms", null, new Room[0]);
            this.propSupport.firePropertyChange("Room", new SimpleRoom(), null);
            this.connected = false;
            this.propSupport.firePropertyChange("Connected", Boolean.TRUE, Boolean.FALSE);
            this.fireStatus(Resources.getString("Peer2Peer.disconnected"));
            this.ppm.finish();
        }
    }

    protected void fireStatus(String msg) {
        this.propSupport.firePropertyChange("Status", null, msg);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public ServerStatus getStatusServer() {
        return this.svrStatus;
    }

    @Override
    public Player stringToPlayer(String s) {
        return this.roomMgr.getPlayerById(s);
    }

    @Override
    public String playerToString(Player p) {
        return p.getId();
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(propertyName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    @Override
    public void setActivePeerManager(ActivePeerManager pActivePeerManager) {
        this.peerMgr = pActivePeerManager;
    }

    @Override
    public void setPendingPeerManager(PendingPeerManager pPendingPeerManager) {
        this.ppm = pPendingPeerManager;
    }

    @Override
    public synchronized void showUnrecognized(PeerInfo pPeerInfo, String pBadMessage) {
    }

    @Override
    public synchronized void showStreamsFailed(PeerInfo pPeerInfo) {
        P2PPlayer p = new P2PPlayer(pPeerInfo);
        this.propSupport.firePropertyChange("Status", null, Resources.getString("Peer2Peer.connection_lost", p.getName()));
    }

    @Override
    public synchronized void showConnectFailed(PeerInfo pPeerInfo) {
        this.pool.connectFailed(pPeerInfo);
    }

    @Override
    public synchronized void showConnect(PeerInfo pPeerInfo) {
    }

    @Override
    public synchronized void showDisconnect(PeerInfo pPeerInfo) {
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.remove(pPeerInfo));
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    @Override
    public synchronized void showCHAT(PeerInfo pPeerInfo, String msg) {
        this.propSupport.firePropertyChange("Msg", null, msg);
    }

    @Override
    public synchronized void showPMSG(PeerInfo pPeerInfo, String msg) {
        this.showCHAT(pPeerInfo, msg);
    }

    @Override
    public synchronized void showNAME(PeerInfo pPeerInfo) {
        this.tracker.init(this.getRoom());
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(pPeerInfo));
        Room myRoom = this.getRoom();
        this.propSupport.firePropertyChange("Room", null, myRoom);
        this.tracker.finalizeRoom(myRoom);
    }

    @Override
    public synchronized void showHELO(PeerInfo pPeerInfo) {
        Object details;
        Chatter chatter = GameModule.getGameModule().getChatter();
        ActivePeer peer = this.peerMgr.getPeerListenerByInfo(pPeerInfo);
        try {
            Properties props = new PropertiesEncoder(pPeerInfo.getChatName()).getProperties();
            String name = props.getProperty("name");
            String ip = props.getProperty("ip");
            details = name + " (" + ip + ":" + pPeerInfo.getPort() + ")";
        }
        catch (IOException ex) {
            details = "";
        }
        if (!pPeerInfo.getNetworkPw().equals(this.params.getProperty("serverPw"))) {
            new Chatter.DisplayText(chatter, Resources.getString("Peer2Peer.bad_password", details)).execute();
            peer.finish();
            return;
        }
        this.fireStatus(Resources.getString("Peer2Peer.connected", details));
        this.propSupport.firePropertyChange("AvailableRooms", null, this.roomMgr.update(pPeerInfo));
        this.propSupport.firePropertyChange("Room", null, this.getRoom());
    }

    @Override
    public void initializeControls(ChatServerControls controls) {
        this.playerStatusControls.initializeControls(controls);
        this.roomControls.initializeControls(controls);
        controls.setRoomControlsVisible(false);
        GameModule g = GameModule.getGameModule();
        this.me.setName((String)g.getPrefs().getValue("RealName"));
        g.getPrefs().getOption("RealName").addPropertyChangeListener(this.nameChangeListener);
        g.addCommandEncoder(this.synchEncoder);
        g.addCommandEncoder(this.soundEncoder);
        if (this.pool instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.pool)).initializeControls(controls);
        }
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        this.playerStatusControls.uninitializeControls(controls);
        this.roomControls.uninitializeControls(controls);
        GameModule g = GameModule.getGameModule();
        g.getPrefs().getOption("RealName").removePropertyChangeListener(this.nameChangeListener);
        g.removeCommandEncoder(this.synchEncoder);
        g.removeCommandEncoder(this.soundEncoder);
        if (this.pool instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.pool)).uninitializeControls(controls);
        }
    }
}

