/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.peer2peer.P2PPlayer;
import VASSAL.i18n.Resources;
import java.util.ArrayList;
import java.util.List;
import org.litesoft.p2pchat.PeerInfo;

public class RoomManager {
    private final List<Room> rooms = new ArrayList<Room>();
    private final SimpleRoom defaultRoom = new SimpleRoom(Resources.getString("Chat.main_room"));

    public RoomManager() {
        this.rooms.add(this.defaultRoom);
    }

    public Room[] update(PeerInfo info) {
        P2PPlayer p = new P2PPlayer(info);
        SimpleRoom oldRoom = this.getRoomContaining(p);
        Room newRoom = new SimpleRoom(p.getRoom());
        if (this.rooms.contains(newRoom)) {
            newRoom = this.rooms.get(this.rooms.indexOf(newRoom));
        } else {
            this.rooms.add(newRoom);
        }
        newRoom.addPlayer(p);
        if (oldRoom != null && !((Object)oldRoom).equals(newRoom)) {
            oldRoom.removePlayer(p);
            if (oldRoom.getPlayerList().isEmpty() && !((Object)oldRoom).equals(this.defaultRoom)) {
                this.rooms.remove(oldRoom);
            }
        }
        return this.getRooms();
    }

    public Room[] remove(PeerInfo info) {
        P2PPlayer p = new P2PPlayer(info);
        for (int i = 0; i < this.rooms.size(); ++i) {
            Room r = this.rooms.get(i);
            r.removePlayer(p);
            if (!r.getPlayerList().isEmpty() || r.equals(this.defaultRoom)) continue;
            this.rooms.remove(i--);
        }
        return this.getRooms();
    }

    public P2PPlayer getPlayerById(String id) {
        for (Room r : this.rooms) {
            for (Player p : r.getPlayerList()) {
                P2PPlayer p2pp = (P2PPlayer)p;
                if (!id.equals(p2pp.getId())) continue;
                return p2pp;
            }
        }
        return null;
    }

    public Room[] getRooms() {
        return this.rooms.toArray(new Room[0]);
    }

    public SimpleRoom getRoomContaining(Player p) {
        for (Room r : this.rooms) {
            SimpleRoom sr = (SimpleRoom)r;
            if (!sr.contains(p)) continue;
            return sr;
        }
        return null;
    }

    public void setDefaultRoomName(String name) {
        this.defaultRoom.setName(name);
    }

    public Room getDefaultRoom() {
        return this.defaultRoom;
    }

    public void clear() {
        this.rooms.clear();
        this.defaultRoom.setPlayers(new Player[0]);
        this.rooms.add(this.defaultRoom);
    }
}

