/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class InviteAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final SimplePlayer invitee;
    private final LockableChatServerConnection client;

    public InviteAction(LockableChatServerConnection client, SimplePlayer target) {
        super(Resources.getString("Chat.invite"));
        this.invitee = target;
        this.client = client;
        this.setEnabled(client.isInvitable(target));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isEnabled()) {
            this.client.sendInvite(this.invitee);
            GameModule.getGameModule().warn(Resources.getString("Chat.invite_sent", this.invitee.getName()));
        }
    }

    public static PlayerActionFactory factory(LockableChatServerConnection client) {
        return (p, tree) -> {
            Room r = client.getRoom();
            if (r instanceof LockableRoom && !((LockableRoom)((Object)r)).isLocked()) {
                return null;
            }
            return new InviteAction(client, p);
        };
    }
}

