/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.AbstractConfigurableListEntry;
import VASSAL.configure.ConfigurableList;
import VASSAL.configure.ConfigurableListController;
import VASSAL.configure.ConfigurableListEntry;
import VASSAL.configure.Configurer;
import VASSAL.configure.Parameter;
import VASSAL.configure.ParameterConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ParameterListConfigurer
extends Configurer
implements ConfigurableList {
    private static final int HEADER_COMPONENT_COUNT = 2;
    private static final int COMPONENT_COUNT = 3;
    private ConfigurableListController controller;
    private int selectedEntryIndex = -1;
    private JPanel panel;
    private JPanel controls;
    private JPanel configControls;
    private final List<ConfigurableListEntry> entries = new ArrayList<ConfigurableListEntry>();

    public static String encode(List<Parameter> parameters) {
        if (parameters == null) {
            return "";
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (Parameter param : parameters) {
            if (param == null) continue;
            se.append(param.encode());
        }
        return se.getValue();
    }

    public static List<Parameter> decode(String s) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (s != null && s.length() > 0) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
            while (sd.hasMoreTokens()) {
                parameters.add(new Parameter(sd.nextToken("")));
            }
        }
        return parameters;
    }

    public ParameterListConfigurer(String key, String name, List<Parameter> params) {
        super(key, name);
        this.value = params;
    }

    public ParameterListConfigurer(String key, String name) {
        this(key, name, new ArrayList<Parameter>());
    }

    public ParameterListConfigurer(List<Parameter> params) {
        this("", "", params);
    }

    public List<String> getParameterNames() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.getListValue() != null) {
            for (Object p : this.getListValue()) {
                l.add(((Parameter)p).getPropertyName());
            }
        }
        return l;
    }

    public List<Parameter> getParameterList() {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        for (Object o : this.getListValue()) {
            parameterList.add((Parameter)o);
        }
        return parameterList;
    }

    public List<String> getParameterValues() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.getListValue() != null) {
            for (Object p : this.getListValue()) {
                l.add(((Parameter)p).getValue());
            }
        }
        return l;
    }

    @Override
    public void moveEntryUp() {
        int pos = this.getSelectedEntryIndex();
        if (pos < 0 || pos > this.entries.size() - 1) {
            return;
        }
        int listPos = this.getSelectedEntryIndex();
        ParameterEntry entry = (ParameterEntry)this.entries.get(listPos);
        this.removeConfigControls(entry);
        this.insertConfigControls(entry, listPos - 1);
        this.entries.remove(entry);
        this.entries.add(listPos - 1, entry);
        Object temp = this.getListValue().get(pos);
        this.getListValue().set(pos, this.getListValue().get(pos - 1));
        this.getListValue().set(pos - 1, temp);
        this.setSelectedEntryIndex(pos - 1);
        this.updateControls();
    }

    @Override
    public void moveEntryDown() {
        int pos = this.getSelectedEntryIndex();
        if (pos < 0 || pos >= this.entries.size()) {
            return;
        }
        int listPos = this.getSelectedEntryIndex();
        ParameterEntry entry = (ParameterEntry)this.entries.get(listPos);
        this.removeConfigControls(entry);
        this.insertConfigControls(entry, listPos + 1);
        this.entries.remove(entry);
        this.entries.add(listPos + 1, entry);
        Object temp = this.getListValue().get(pos);
        this.getListValue().set(pos, this.getListValue().get(pos + 1));
        this.getListValue().set(pos + 1, temp);
        this.setSelectedEntryIndex(pos + 1);
        this.updateControls();
    }

    @Override
    public void addEntry() {
        int pos = this.getSelectedEntryIndex();
        ParameterEntry newEntry = new ParameterEntry(this);
        this.getListValue().add(pos + 1, newEntry.getConfigurer().getValue());
        this.entries.add(pos + 1, newEntry);
        this.insertConfigControls(newEntry, pos + 1);
        this.setSelectedEntryIndex(pos + 1);
        this.updateControls(pos + 1);
    }

    @Override
    public void deleteEntry(ConfigurableListEntry entry) {
        int listPos = this.entries.indexOf(entry);
        int componentPos = this.listPosToControlsPos(listPos);
        for (int i = 0; i < 3; ++i) {
            this.configControls.remove(componentPos);
        }
        this.entries.remove(entry);
        if (this.getSelectedEntryIndex() > this.entries.size() - 1) {
            this.setSelectedEntryIndex(this.entries.size() - 1);
        }
        this.getListValue().remove(listPos);
        this.updateControls();
    }

    @Override
    public void selectEntry(ConfigurableListEntry entry) {
        this.setSelectedEntryIndex(entry == null ? -1 : this.entries.indexOf(entry));
        this.updateControls();
    }

    @Override
    public void setSelectedEntryIndex(int index) {
        this.selectedEntryIndex = index;
    }

    @Override
    public int getSelectedEntryIndex() {
        return Math.min(this.selectedEntryIndex, this.getListValue() == null ? -1 : this.getListValue().size() - 1);
    }

    @Override
    public void entryChanged(ConfigurableListEntry entry) {
        int pos = this.entries.indexOf(entry);
        if (pos >= 0) {
            this.getListValue().set(pos, entry.getConfigurer().getValue());
            this.fireUpdate();
        }
    }

    @Override
    public JComponent getListController() {
        if (this.controller == null) {
            this.controller = new ConfigurableListController(this);
        }
        return this.controller;
    }

    @Override
    public String getValueString() {
        return ParameterListConfigurer.encode(this.getParameterListValue());
    }

    public List<Object> getListValue() {
        return (List)this.getValue();
    }

    public List<Parameter> getParameterListValue() {
        return (List)this.getValue();
    }

    @Override
    public void setValue(String s) {
        this.getListValue().clear();
        this.getListValue().addAll(ParameterListConfigurer.decode(s));
        this.rebuildControls();
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            o = new ArrayList();
        }
        super.setValue(o);
        this.rebuildControls();
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel((LayoutManager)new MigLayout("gapy 4", "[grow,fill][]"));
            this.panel.setBorder(BorderFactory.createEtchedBorder());
            this.controls = new JPanel((LayoutManager)new MigLayout("hidemode 3,ins 2", "[grow,fill]", "[grow,fill]"));
            this.configControls = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 3,ins 0,gapy 4", "[fill]rel[grow,fill]rel[grow 0]", "[center]"));
            this.controls.add((Component)this.configControls, "grow, aligny center");
            this.panel.add((Component)this.controls, "grow");
            this.panel.add((Component)this.getListController(), "growy 0,aligny center");
            this.rebuildControls();
        }
        return this.panel;
    }

    protected void rebuildControls() {
        if (this.controls != null) {
            this.entries.clear();
            this.configControls.removeAll();
            this.buildHeader();
            for (Object value : this.getListValue()) {
                ParameterEntry entry = new ParameterEntry(this, value);
                this.entries.add(entry);
                this.appendConfigControls(entry);
            }
            this.updateControls();
            this.repack();
        }
    }

    private void updateControls(int focus) {
        this.updateControls();
        this.entries.get(focus).requestFocus();
    }

    private void updateControls() {
        this.configControls.setVisible(!this.getListValue().isEmpty());
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).updateVisibility();
            this.entries.get(i).setHighlighted(i == this.getSelectedEntryIndex());
        }
        this.updateListController();
        this.configControls.revalidate();
        this.repack();
    }

    private void updateListController() {
        this.getListController();
        this.controller.setCanMoveUp(this.getSelectedEntryIndex() > 0);
        this.controller.setCanMoveDown(this.getSelectedEntryIndex() >= 0 && this.getSelectedEntryIndex() < this.entries.size() - 1);
    }

    private void buildHeader() {
        JLabel propertyNameHeader = new JLabel(Resources.getString("Editor.ParameterListConfigurer.dynamic_property_name"));
        Font boldFont = new Font(propertyNameHeader.getFont().getFontName(), 1, propertyNameHeader.getFont().getSize());
        propertyNameHeader.setFont(boldFont);
        this.configControls.add((Component)propertyNameHeader, "alignx center");
        JLabel valueHeader = new JLabel(Resources.getString("Editor.ParameterListConfigurer.value"));
        valueHeader.setFont(boldFont);
        this.configControls.add((Component)valueHeader, "alignx center,wrap");
        this.configControls.setVisible(false);
    }

    private void appendConfigControls(ParameterEntry entry) {
        ParameterConfigurer c = entry.getParameterConfigurer();
        this.getControls();
        this.configControls.add(c.getPropertyNameControls());
        this.configControls.add(c.getValueControls());
        this.configControls.add(entry.getRemoveButton());
    }

    private void insertConfigControls(ParameterEntry entry, int listPos) {
        int controlPos = this.listPosToControlsPos(listPos);
        ParameterConfigurer c = entry.getParameterConfigurer();
        this.getControls();
        this.configControls.add(c.getPropertyNameControls(), controlPos++);
        this.configControls.add(c.getValueControls(), controlPos++);
        this.configControls.add((Component)entry.getRemoveButton(), controlPos++);
    }

    private void removeConfigControls(ParameterEntry entry) {
        ParameterConfigurer c = entry.getParameterConfigurer();
        this.getControls();
        this.configControls.remove(c.getPropertyNameControls());
        this.configControls.remove(c.getValueControls());
        this.configControls.remove(entry.getRemoveButton());
    }

    private int listPosToControlsPos(int listPos) {
        return 2 + listPos * 3;
    }

    @Override
    public void repack() {
        this.repack(this.panel);
    }

    private static class ParameterEntry
    extends AbstractConfigurableListEntry {
        private final ParameterListConfigurer listConfig;

        public ParameterEntry(ParameterListConfigurer listConfig) {
            this(listConfig, null);
        }

        public ParameterEntry(ParameterListConfigurer listConfig, Object value) {
            this(listConfig, value, 0);
        }

        public ParameterEntry(ParameterListConfigurer listConfig, Object value, int iconSize) {
            super(listConfig, value, iconSize);
            this.listConfig = listConfig;
        }

        public ParameterConfigurer getParameterConfigurer() {
            return (ParameterConfigurer)this.getConfigurer();
        }

        @Override
        public Configurer buildChildConfigurer(Object value) {
            ParameterConfigurer c = new ParameterConfigurer();
            ((Configurer)c).setFrozen(true);
            ((Configurer)c).setValue(value);
            ((Configurer)c).setFrozen(false);
            return c;
        }

        @Override
        public void focusGained() {
            this.listConfig.selectEntry(this);
        }

        @Override
        public void setHighlighted(boolean highlighted) {
            this.getConfigurer().setHighlighted(highlighted);
        }
    }
}

