/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.AuditTrail;
import VASSAL.script.expression.Auditable;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.PropertyMatchExpression;
import VASSAL.tools.ErrorDialog;

public class PropertyExpression
implements PieceFilter {
    protected Expression expression = NullExpression.instance();

    public PropertyExpression() {
    }

    public PropertyExpression(String s) {
        this.setExpression(s);
    }

    public void setExpression(String s) {
        this.expression = Expression.createPropertyExpression(s);
    }

    public String getExpression() {
        return this.expression.getExpression();
    }

    public boolean isNull() {
        return this.expression == null || this.expression instanceof NullExpression;
    }

    public PieceFilter getFilter(PropertySource source, Auditable owner, String fieldKey) {
        return this.getFilter(source, owner, AuditTrail.create(owner, this.getExpression(), Resources.getString(fieldKey)));
    }

    public PieceFilter getFilter(PropertySource source, Auditable owner, AuditTrail audit) {
        return this.expression.getFilter(source, owner, audit);
    }

    public PieceFilter getFilter(PropertySource source) {
        return this.getFilter(source, null, (AuditTrail)null);
    }

    public PieceFilter getFilter() {
        return this.expression.getFilter(null, null);
    }

    @Override
    public boolean accept(GamePiece piece) {
        return this.accept(piece, null, (AuditTrail)null);
    }

    @Override
    public boolean accept(GamePiece piece, Auditable owner, String fieldKey) {
        return this.accept(piece, owner, AuditTrail.create(owner, this.getExpression(), Resources.getString(fieldKey)));
    }

    @Override
    public boolean accept(GamePiece piece, Auditable owner, AuditTrail audit) {
        if (this.expression instanceof PropertyMatchExpression) {
            return this.expression.getFilter(piece, owner, audit).accept(piece, owner, audit);
        }
        return this.isTrue(piece, owner, audit);
    }

    public boolean accept(GamePiece source, GamePiece piece) {
        return this.accept(source, piece, null, null);
    }

    public boolean accept(PropertySource source, GamePiece piece) {
        return this.accept(source, piece, null, null);
    }

    public boolean accept(GamePiece source, GamePiece piece, Auditable owner, AuditTrail trail) {
        return this.getFilter(source).accept(piece, owner, trail);
    }

    public boolean accept(PropertySource source, GamePiece piece, Auditable owner, AuditTrail trail) {
        return this.getFilter(source).accept(piece, owner, trail);
    }

    public int hashCode() {
        return this.getExpression().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof PropertyExpression && this.getExpression().equals(((PropertyExpression)o).getExpression());
    }

    public boolean isTrue(PropertySource ps) {
        return this.isTrue(ps, null, null);
    }

    public boolean isTrue(PropertySource ps, Auditable owner, AuditTrail audit) {
        String result;
        block2: {
            result = null;
            try {
                result = this.expression.evaluate(ps, owner, audit);
            }
            catch (ExpressionException e) {
                if (owner instanceof EditablePiece && ((EditablePiece)owner).getMap() == null) break block2;
                ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.expression_error"), "Expression=" + this.getExpression() + ", Error=" + e.getError(), e));
            }
        }
        return "true".equals(result);
    }
}

