/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.KeyModifiersConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Embellishment0
extends Decorator
implements TranslatablePiece {
    public static final String OLD_ID = "emb;";
    public static final String ID = "emb2;";
    public static final String IMAGE = "_Image";
    public static final String NAME = "_Name";
    public static final String LEVEL = "_Level";
    public static final String ACTIVE = "_Active";
    protected String activateKey = "";
    protected String upKey;
    protected String downKey;
    protected int activateModifiers;
    protected int upModifiers;
    protected int downModifiers;
    protected String upCommand;
    protected String downCommand;
    protected String activateCommand;
    protected String resetCommand;
    protected FormattedString resetLevel = new FormattedString("1");
    protected boolean loopLevels;
    protected KeyStroke resetKey;
    protected boolean followProperty;
    protected String propertyName = "";
    protected int firstLevelValue;
    protected KeyStroke rndKey;
    private String rndText = "";
    protected int value = -1;
    protected String activationStatus = "";
    protected int nValues;
    protected int xOff;
    protected int yOff;
    protected String[] imageName;
    protected String[] commonName;
    protected Rectangle[] size;
    protected ScaledImagePainter[] imagePainter;
    protected boolean drawUnderneathWhenSelected = false;
    protected String name = "";
    protected KeyCommand[] commands;
    protected KeyCommand up = null;
    protected KeyCommand down = null;
    protected Rectangle lastBounds = null;
    protected Area lastShape = null;

    public Embellishment0() {
        this(ID + Resources.getString("Editor.Embellishment.activate"), null);
    }

    public Embellishment0(String type, GamePiece d) {
        this.mySetType(type);
        this.setInner(d);
    }

    public boolean isActive() {
        return this.value > 0;
    }

    public void setActive(boolean val) {
        this.value = val ? Math.abs(this.value) : -Math.abs(this.value);
    }

    public int getValue() {
        return Math.abs(this.value) - 1;
    }

    public void setValue(int val) {
        if (val >= this.nValues) {
            throw new IllegalArgumentException();
        }
        this.value = this.value > 0 ? val + 1 : -val - 1;
    }

    @Override
    public void mySetType(String s) {
        if (!s.startsWith(ID)) {
            this.originalSetType(s);
        } else {
            s = s.substring(ID.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
            this.activateCommand = st.nextToken("Activate");
            this.activateModifiers = st.nextInt(128);
            this.activateKey = st.nextToken("A");
            this.upCommand = st.nextToken("Increase");
            this.upModifiers = st.nextInt(128);
            this.upKey = st.nextToken("]");
            this.downCommand = st.nextToken("Decrease");
            this.downModifiers = st.nextInt(128);
            this.downKey = st.nextToken("[");
            this.resetCommand = st.nextToken("Reset");
            this.resetKey = st.nextKeyStroke('R');
            this.resetLevel = new FormattedString(st.nextToken("1"));
            this.drawUnderneathWhenSelected = st.nextBoolean(false);
            this.xOff = st.nextInt(0);
            this.yOff = st.nextInt(0);
            this.imageName = st.nextStringArray(0);
            this.commonName = st.nextStringArray(this.imageName.length);
            this.loopLevels = st.nextBoolean(true);
            this.name = st.nextToken("");
            this.rndKey = st.nextKeyStroke(null);
            this.rndText = st.nextToken("");
            this.followProperty = st.nextBoolean(false);
            this.propertyName = st.nextToken("");
            this.firstLevelValue = st.nextInt(1);
            this.value = this.activateKey.length() > 0 ? -1 : 1;
            this.nValues = this.imageName.length;
            this.size = new Rectangle[this.imageName.length];
            this.imagePainter = new ScaledImagePainter[this.imageName.length];
            for (int i = 0; i < this.imageName.length; ++i) {
                this.imagePainter[i] = new ScaledImagePainter();
                this.imagePainter[i].setImageName(this.imageName[i]);
            }
        }
        this.commands = null;
    }

    private void originalSetType(String s) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        st.nextToken();
        SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), ';');
        this.activateKey = st2.nextToken().toUpperCase();
        this.activateModifiers = 128;
        if (st2.hasMoreTokens()) {
            this.resetCommand = st2.nextToken();
            this.resetKey = st2.nextKeyStroke(null);
            this.resetLevel.setFormat(st2.nextToken("0"));
        } else {
            this.resetKey = null;
            this.resetCommand = "";
            this.resetLevel.setFormat("0");
        }
        this.activateCommand = st.nextToken();
        this.drawUnderneathWhenSelected = this.activateCommand.startsWith("_");
        if (this.drawUnderneathWhenSelected) {
            this.activateCommand = this.activateCommand.substring(1);
        }
        this.value = this.activateKey.length() > 0 ? -1 : 1;
        this.upKey = st.nextToken().toUpperCase();
        this.upCommand = st.nextToken();
        this.upModifiers = 128;
        this.downKey = st.nextToken().toUpperCase();
        this.downCommand = st.nextToken();
        this.downModifiers = 128;
        this.xOff = st.nextInt(0);
        this.yOff = st.nextInt(0);
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        this.nValues = l.size();
        this.imageName = new String[l.size()];
        this.commonName = new String[l.size()];
        this.size = new Rectangle[this.imageName.length];
        this.imagePainter = new ScaledImagePainter[this.imageName.length];
        for (int i = 0; i < this.imageName.length; ++i) {
            String sub = (String)l.get(i);
            SequenceEncoder.Decoder subSt = new SequenceEncoder.Decoder(sub, ',');
            this.imageName[i] = subSt.nextToken();
            this.imagePainter[i] = new ScaledImagePainter();
            this.imagePainter[i].setImageName(this.imageName[i]);
            if (!subSt.hasMoreTokens()) continue;
            this.commonName[i] = subSt.nextToken();
        }
        this.loopLevels = true;
    }

    @Override
    public String getLocalizedName() {
        return this.getName(true);
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean localized) {
        Object name;
        String cname;
        this.checkPropertyLevel();
        String string = cname = 0 < this.value && this.value - 1 < this.commonName.length ? this.getCommonName(localized, this.value - 1) : null;
        if (cname != null && cname.length() > 0) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(cname, '+');
            String first = st.nextToken();
            if (st.hasMoreTokens()) {
                String second = st.nextToken();
                name = first.length() == 0 ? (localized ? this.piece.getLocalizedName() : this.piece.getName()) + second : first + (localized ? this.piece.getLocalizedName() : this.piece.getName());
            } else {
                name = first;
            }
        } else {
            name = localized ? this.piece.getLocalizedName() : this.piece.getName();
        }
        return name;
    }

    @Override
    public void mySetState(String s) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.value = st.nextInt(1);
        this.activationStatus = st.nextToken(this.value < 0 ? "" : this.activateKey);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.activateCommand).append(this.activateModifiers).append(this.activateKey).append(this.upCommand).append(this.upModifiers).append(this.upKey).append(this.downCommand).append(this.downModifiers).append(this.downKey).append(this.resetCommand).append(this.resetKey).append(this.resetLevel.getFormat()).append(this.drawUnderneathWhenSelected).append(this.xOff).append(this.yOff).append(this.imageName).append(this.commonName).append(this.loopLevels).append(this.name).append(this.rndKey).append(this.rndText).append(this.followProperty).append(this.propertyName).append(this.firstLevelValue);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        return se.append(String.valueOf(this.value)).append(this.activationStatus).getValue();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
        this.checkPropertyLevel();
        if (!this.isActive()) {
            return;
        }
        int i = this.value - 1;
        if (i < this.imagePainter.length && this.imagePainter[i] != null) {
            Rectangle r = this.getCurrentImageBounds();
            this.imagePainter[i].draw(g, x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y), zoom, obs);
        }
        if (this.drawUnderneathWhenSelected && Boolean.TRUE.equals(this.getProperty("Selected"))) {
            this.piece.draw(g, x, y, obs, zoom);
        }
    }

    protected void checkPropertyLevel() {
        if (!this.followProperty || this.propertyName.length() == 0) {
            return;
        }
        Object propertyValue = Embellishment0.getOutermost(this).getProperty(this.propertyName);
        String val = propertyValue == null ? String.valueOf(this.firstLevelValue) : String.valueOf(propertyValue);
        try {
            int v = Integer.parseInt(val) - this.firstLevelValue + 1;
            if (v <= 0) {
                v = 1;
            }
            if (v > this.nValues) {
                v = this.nValues;
            }
            this.value = this.isActive() ? v : -v;
        }
        catch (NumberFormatException e) {
            Embellishment0.reportDataError(this, Resources.getString("Error.non_number_error"), "followProperty[" + this.propertyName + "]=" + val, e);
        }
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            GamePiece outer = Embellishment0.getOutermost(this);
            if (this.activateCommand.length() > 0 && this.activateKey.length() > 0) {
                KeyCommand k = new KeyCommand(this.activateCommand, KeyStroke.getKeyStroke((int)this.activateKey.charAt(0), this.activateModifiers), outer, (TranslatablePiece)this);
                k.setEnabled(this.nValues > 0);
                l.add(k);
            }
            if (this.upCommand.length() > 0 && this.upKey.length() > 0 && this.nValues > 1 && !this.followProperty) {
                this.up = new KeyCommand(this.upCommand, KeyStroke.getKeyStroke((int)this.upKey.charAt(0), this.upModifiers), outer, (TranslatablePiece)this);
                l.add(this.up);
            }
            if (this.downCommand.length() > 0 && this.downKey.length() > 0 && this.nValues > 1 && !this.followProperty) {
                this.down = new KeyCommand(this.downCommand, KeyStroke.getKeyStroke((int)this.downKey.charAt(0), this.downModifiers), outer, (TranslatablePiece)this);
                l.add(this.down);
            }
            if (this.resetKey != null && this.resetCommand.length() > 0 && !this.followProperty) {
                l.add(new KeyCommand(this.resetCommand, this.resetKey, outer, (TranslatablePiece)this));
            }
            if (this.rndKey != null && this.rndText.length() > 0 && !this.followProperty) {
                l.add(new KeyCommand(this.rndText, this.rndKey, outer, (TranslatablePiece)this));
            }
            this.commands = l.toArray(new KeyCommand[0]);
        }
        if (this.up != null) {
            this.up.setEnabled(this.loopLevels || Math.abs(this.value) < this.imageName.length);
        }
        if (this.down != null) {
            this.down.setEnabled(this.loopLevels || Math.abs(this.value) > 1);
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        char strokeChar = this.getMatchingActivationChar(stroke);
        ChangeTracker tracker = null;
        if (strokeChar != '\u0000' && this.nValues > 0) {
            tracker = new ChangeTracker(this);
            int index = this.activationStatus.indexOf(strokeChar);
            if (index < 0) {
                this.activationStatus = this.activationStatus + strokeChar;
            } else {
                String before = this.activationStatus.substring(0, index);
                String after = this.activationStatus.substring(index + 1);
                this.activationStatus = before + after;
            }
            this.value = this.activationStatus.length() == this.activateKey.length() ? Math.abs(this.value) : -Math.abs(this.value);
        }
        if (!this.followProperty) {
            int i;
            for (i = 0; i < this.upKey.length(); ++i) {
                if (!KeyStroke.getKeyStroke((int)this.upKey.charAt(i), this.upModifiers).equals(stroke)) continue;
                if (tracker == null) {
                    tracker = new ChangeTracker(this);
                }
                int val = Math.abs(this.value);
                if (++val > this.nValues) {
                    val = this.loopLevels ? 1 : this.nValues;
                }
                this.value = this.value > 0 ? val : -val;
                break;
            }
            for (i = 0; i < this.downKey.length(); ++i) {
                if (!KeyStroke.getKeyStroke((int)this.downKey.charAt(i), this.downModifiers).equals(stroke)) continue;
                if (tracker == null) {
                    tracker = new ChangeTracker(this);
                }
                int val = Math.abs(this.value);
                if (--val < 1) {
                    val = this.loopLevels ? this.nValues : 1;
                }
                this.value = this.value > 0 ? val : -val;
                break;
            }
            if (this.resetKey != null && this.resetKey.equals(stroke)) {
                if (tracker == null) {
                    tracker = new ChangeTracker(this);
                }
                GamePiece outer = Embellishment0.getOutermost(this);
                String levelText = this.resetLevel.getText((PropertySource)outer, (Auditable)this, "Editor.Embellishment.reset_to_level");
                try {
                    int level = Integer.parseInt(levelText);
                    this.setValue(Math.abs(level) - 1);
                    this.setActive(level > 0);
                }
                catch (NumberFormatException e) {
                    Embellishment0.reportDataError(this, Resources.getString("Error.non_number_error"), this.resetLevel.debugInfo(levelText, "resetLevel"), e);
                }
            }
            if (this.rndKey != null && this.rndKey.equals(stroke)) {
                if (tracker == null) {
                    tracker = new ChangeTracker(this);
                }
                int val = GameModule.getGameModule().getRNG().nextInt(this.nValues) + 1;
                this.value = this.value > 0 ? val : -val;
            }
        }
        return tracker != null ? tracker.getChangeCommand() : null;
    }

    private char getMatchingActivationChar(KeyStroke stroke) {
        for (int i = 0; i < this.activateKey.length(); ++i) {
            if (stroke == null || !stroke.equals(KeyStroke.getKeyStroke((int)this.activateKey.charAt(i), this.activateModifiers))) continue;
            return this.activateKey.charAt(i);
        }
        return '\u0000';
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        if (this.value > 0) {
            r.add(this.getCurrentImageBounds());
        }
        return r;
    }

    public Rectangle getCurrentImageBounds() {
        if (this.value > 0) {
            int i = this.value - 1;
            if (i >= this.size.length) {
                return new Rectangle();
            }
            if (this.size[i] == null) {
                if (this.imagePainter[i] != null) {
                    this.size[i] = ImageUtils.getBounds(this.imagePainter[i].getImageSize());
                    this.size[i].translate(this.xOff, this.yOff);
                } else {
                    this.size[i] = new Rectangle();
                }
            }
            return this.size[i];
        }
        return new Rectangle();
    }

    @Override
    public Shape getShape() {
        Shape innerShape = this.piece.getShape();
        if (this.value > 0 && !this.drawUnderneathWhenSelected) {
            Rectangle r = this.getCurrentImageBounds();
            if (innerShape.contains(r.x, r.y, r.width, r.height)) {
                return innerShape;
            }
            Area a = new Area(innerShape);
            if (!r.equals(this.lastBounds)) {
                this.lastShape = new Area(r);
                this.lastBounds = new Rectangle(r);
            }
            a.add(this.lastShape);
            return a;
        }
        return innerShape;
    }

    @Override
    public String getDescription() {
        String displayName = this.name;
        if ((this.name == null || this.name.length() == 0) && this.imageName.length > 0 && this.imageName[0] != null && this.imageName[0].length() > 0) {
            displayName = this.imageName[0];
        }
        if (displayName == null || displayName.length() == 0) {
            return "Layer";
        }
        return "Layer - " + displayName;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.Embellishment.trait_description");
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals(this.name + IMAGE)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.imageName[Math.abs(this.value) - 1];
            }
            return "";
        }
        if (key.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.commonName[Math.abs(this.value) - 1]);
            }
            return "";
        }
        if (key.equals(this.name + LEVEL)) {
            this.checkPropertyLevel();
            return String.valueOf(this.value);
        }
        if (key.equals(this.name + ACTIVE)) {
            return String.valueOf(this.isActive());
        }
        if (key.equals("visibleState")) {
            Object s = String.valueOf(super.getProperty(key));
            if (this.drawUnderneathWhenSelected) {
                s = (String)s + String.valueOf(this.getProperty("Selected"));
            }
            return s;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals(this.name + IMAGE) || key.equals(this.name + LEVEL) || key.equals(this.name + ACTIVE) || key.equals("visibleState")) {
            return this.getProperty(key);
        }
        if (key.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.getLocalizedCommonName(Math.abs(this.value) - 1));
            }
            return "";
        }
        return super.getLocalizedProperty(key);
    }

    protected String strip(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("+")) {
            return s.substring(1);
        }
        if (s.endsWith("+")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected String getCommonName(boolean localized, int i) {
        return localized ? this.getLocalizedCommonName(i) : this.commonName[i];
    }

    protected String getLocalizedCommonName(int i) {
        String name = this.commonName[i];
        if (name == null) {
            return null;
        }
        String translation = this.getTranslation(this.strip(name));
        if (name.startsWith("+")) {
            return "+" + translation;
        }
        if (name.endsWith("+")) {
            return translation + "+";
        }
        return translation;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Layer.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece piece, KeyStroke stroke, boolean active) {
        Embellishment layer = (Embellishment)Embellishment0.getDecorator(piece, Embellishment.class);
        while (layer != null) {
            for (int i = 0; i < layer.activateKey.length(); ++i) {
                if (!stroke.equals(KeyStroke.getKeyStroke((int)layer.activateKey.charAt(i), layer.activateModifiers))) continue;
                if (active && layer.isActive()) {
                    return layer;
                }
                if (active || layer.isActive()) break;
                return layer;
            }
            layer = (Embellishment)Embellishment0.getDecorator(layer.piece, Embellishment.class);
        }
        return null;
    }

    @Override
    public PieceI18nData getI18nData() {
        String prefix;
        PieceI18nData data = new PieceI18nData(this);
        String string = prefix = this.name.length() > 0 ? this.name + ": " : "";
        if (this.activateKey.length() > 0) {
            data.add(this.activateCommand, prefix + "Activate command");
        }
        if (!this.followProperty) {
            data.add(this.upCommand, prefix + "Increase command");
            data.add(this.downCommand, prefix + "Decrease command");
            data.add(this.resetCommand, prefix + "Reset command");
            data.add(this.rndText, prefix + "Random command");
        }
        for (int i = 0; i < this.commonName.length; ++i) {
            data.add(this.strip(this.commonName[i]), prefix + "Level " + (i + 1) + " name");
        }
        return data;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        s.addAll(Arrays.asList(this.imageName));
    }

    private static class Ed
    implements PieceEditor {
        private final MultiImagePicker images;
        private final JTextField activateKeyInput = new JTextField("A");
        private final JTextField upKeyInput = new JTextField("]");
        private final JTextField downKeyInput = new JTextField("[");
        private final JTextField activateCommand = new JTextField("Activate");
        private final KeyModifiersConfigurer activateModifiers = new KeyModifiersConfigurer(null, "  key:  ");
        private final JTextField upCommand = new JTextField("Increase");
        private final KeyModifiersConfigurer upModifiers = new KeyModifiersConfigurer(null, "  key:  ");
        private final JTextField downCommand = new JTextField("Decrease");
        private final KeyModifiersConfigurer downModifiers = new KeyModifiersConfigurer(null, "  key:  ");
        private final JTextField rndCommand = new JTextField(12);
        private final JTextField xOffInput = new JTextField(2);
        private final JTextField yOffInput = new JTextField(2);
        private final JTextField levelNameInput = new JTextField(8);
        private final JRadioButton prefix = new JRadioButton("is prefix");
        private final JRadioButton suffix = new JRadioButton("is suffix");
        private final JCheckBox alwaysActive = new JCheckBox("Always active?");
        private final JCheckBox drawUnderneath = new JCheckBox("Underneath when highlighted?");
        private final JTextField resetLevel = new JTextField(2);
        private final JTextField resetCommand = new JTextField(8);
        private final JCheckBox loop = new JCheckBox("Loop through levels?");
        private final HotKeyConfigurer resetKey = new HotKeyConfigurer(null, "  Keyboard:  ");
        private final JTextField name = new JTextField(8);
        private final JPanel controls = new JPanel();
        private List<String> names;
        private List<Integer> isPrefix;
        private static final Integer NEITHER = 0;
        private static final Integer PREFIX = 1;
        private static final Integer SUFFIX = 2;
        private final HotKeyConfigurer rndKeyConfig;
        private final BooleanConfigurer followConfig;
        private final StringConfigurer propertyConfig;
        private final IntConfigurer firstLevelConfig;
        private final Box reset1Controls;
        private final Box reset2Controls;
        private final Box rnd1Controls;
        private final Box rnd2Controls;

        public Ed(Embellishment0 e) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            Box nameControls = Box.createHorizontalBox();
            nameControls.add(new JLabel("Name:  "));
            nameControls.add(this.name);
            this.controls.add(nameControls);
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(5, 3));
            p.add(this.resetKey.getControls());
            this.activateCommand.setMaximumSize(this.activateCommand.getPreferredSize());
            p.add(this.activateCommand);
            p.add(this.activateModifiers.getControls());
            p.add(this.activateKeyInput);
            this.upCommand.setMaximumSize(this.upCommand.getPreferredSize());
            p.add(this.upCommand);
            p.add(this.upModifiers.getControls());
            p.add(this.upKeyInput);
            this.downCommand.setMaximumSize(this.downCommand.getPreferredSize());
            p.add(this.downCommand);
            p.add(this.downModifiers.getControls());
            p.add(this.downKeyInput);
            this.reset1Controls = Box.createHorizontalBox();
            this.reset1Controls.add(new JLabel("Reset to level:  "));
            this.reset1Controls.add(this.resetLevel);
            p.add(this.reset1Controls);
            this.reset2Controls = Box.createHorizontalBox();
            this.reset2Controls.add(new JLabel("  Command:  "));
            this.reset2Controls.add(this.resetCommand);
            p.add(this.reset2Controls);
            p.add(this.resetKey.getControls());
            this.rnd1Controls = Box.createHorizontalBox();
            this.rnd1Controls.add(new JLabel("Randomize:  "));
            p.add(this.rnd1Controls);
            this.rnd2Controls = Box.createHorizontalBox();
            this.rnd2Controls.add(new JLabel("  Command:  "));
            this.rndCommand.setMaximumSize(this.rndCommand.getPreferredSize());
            this.rndCommand.setText(e.rndText);
            this.rnd2Controls.add(this.rndCommand);
            p.add(this.rnd2Controls);
            this.rndKeyConfig = new HotKeyConfigurer(null, "  Keyboard:  ", e.rndKey);
            p.add(this.rndKeyConfig.getControls());
            Box box = Box.createVerticalBox();
            this.alwaysActive.addItemListener(evt -> {
                if (this.alwaysActive.isSelected()) {
                    this.activateCommand.setText("");
                    this.activateKeyInput.setText("");
                    this.activateCommand.setEnabled(false);
                    this.activateKeyInput.setEnabled(false);
                } else {
                    this.activateCommand.setText("Activate");
                    this.activateKeyInput.setText("A");
                    this.activateCommand.setEnabled(true);
                    this.activateKeyInput.setEnabled(true);
                }
            });
            JPanel checkBoxes = new JPanel();
            checkBoxes.setLayout(new GridLayout(3, 2));
            checkBoxes.add(this.alwaysActive);
            checkBoxes.add(this.drawUnderneath);
            checkBoxes.add(this.loop);
            box.add(checkBoxes);
            box.add(p);
            Box offsetControls = Box.createHorizontalBox();
            this.xOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.xOffInput.setText("0");
            this.yOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.yOffInput.setText("0");
            offsetControls.add(new JLabel("Offset: "));
            offsetControls.add(this.xOffInput);
            offsetControls.add(new JLabel(","));
            offsetControls.add(this.yOffInput);
            checkBoxes.add(offsetControls);
            this.followConfig = new BooleanConfigurer(null, "Levels follow Property Value?");
            checkBoxes.add(this.followConfig.getControls());
            Box levelBox = Box.createHorizontalBox();
            this.propertyConfig = new StringConfigurer(null, "Property Name:  ");
            levelBox.add(this.propertyConfig.getControls());
            this.firstLevelConfig = new IntConfigurer(null, " Level 1 = ", (Integer)e.firstLevelValue);
            levelBox.add(this.firstLevelConfig.getControls());
            checkBoxes.add(levelBox);
            this.followConfig.addPropertyChangeListener(e1 -> this.showHideFields());
            this.controls.add(box);
            this.images = new MultiImagePicker();
            this.controls.add(this.images);
            JPanel p2 = new JPanel();
            p2.setLayout(new GridLayout(2, 2));
            box = Box.createHorizontalBox();
            box.add(new JLabel("Level Name:  "));
            this.levelNameInput.setMaximumSize(this.levelNameInput.getPreferredSize());
            this.levelNameInput.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    this.changeLevelName();
                }
            });
            box.add(this.levelNameInput);
            p2.add(box);
            box = Box.createHorizontalBox();
            this.prefix.addActionListener(evt -> {
                if (this.prefix.isSelected()) {
                    this.suffix.setSelected(false);
                }
                this.changeLevelName();
            });
            this.suffix.addActionListener(evt -> {
                if (this.suffix.isSelected()) {
                    this.prefix.setSelected(false);
                }
                this.changeLevelName();
            });
            box.add(this.prefix);
            box.add(this.suffix);
            p2.add(box);
            JButton b = new JButton("Add Level");
            b.addActionListener(evt -> {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            });
            p2.add(b);
            b = new JButton("Remove Level");
            b.addActionListener(evt -> {
                int index = this.images.getList().getSelectedIndex();
                if (index >= 0) {
                    this.names.remove(index);
                    this.isPrefix.remove(index);
                    this.images.removeEntryAt(index);
                }
            });
            p2.add(b);
            this.controls.add(p2);
            this.images.getList().addListSelectionListener(evt -> this.updateLevelName());
            this.reset(e);
        }

        protected void showHideFields() {
            boolean show = this.followConfig.booleanValue() == false;
            this.loop.setEnabled(show);
            this.propertyConfig.getControls().setVisible(!show);
            this.firstLevelConfig.getControls().setVisible(!show);
            this.reset1Controls.setVisible(show);
            this.reset2Controls.setVisible(show);
            this.resetKey.getControls().setVisible(show);
            this.rnd1Controls.setVisible(show);
            this.rnd2Controls.setVisible(show);
            this.rndKeyConfig.getControls().setVisible(show);
            this.upCommand.setVisible(show);
            this.upModifiers.getControls().setVisible(show);
            this.upKeyInput.setVisible(show);
            this.downCommand.setVisible(show);
            this.downModifiers.getControls().setVisible(show);
            this.downKeyInput.setVisible(show);
        }

        private void updateLevelName() {
            int index = this.images.getList().getSelectedIndex();
            if (index < 0) {
                this.levelNameInput.setText(null);
            } else {
                this.levelNameInput.setText(this.names.get(index));
                this.prefix.setSelected(PREFIX.equals(this.isPrefix.get(index)));
                this.suffix.setSelected(SUFFIX.equals(this.isPrefix.get(index)));
            }
        }

        private void changeLevelName() {
            int index = this.images.getList().getSelectedIndex();
            if (index >= 0) {
                String s = this.levelNameInput.getText();
                this.names.set(index, s);
                if (this.prefix.isSelected()) {
                    this.isPrefix.set(index, PREFIX);
                } else if (this.suffix.isSelected()) {
                    this.isPrefix.set(index, SUFFIX);
                } else {
                    this.isPrefix.set(index, NEITHER);
                }
            } else if (index == 0) {
                this.names.set(index, null);
                this.isPrefix.set(index, NEITHER);
            }
        }

        @Override
        public String getState() {
            return this.alwaysActive.isSelected() ? "1" : "-1";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            ArrayList<String> imageNames = new ArrayList<String>();
            ArrayList<String> commonNames = new ArrayList<String>();
            int i = 0;
            for (String n : this.images.getImageNameList()) {
                imageNames.add(n);
                String commonName = this.names.get(i);
                if (commonName != null && commonName.length() > 0) {
                    commonName = PREFIX.equals(this.isPrefix.get(i)) ? new SequenceEncoder(commonName, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(i)) ? new SequenceEncoder("", '+').append(commonName).getValue() : new SequenceEncoder(commonName, '+').getValue());
                }
                commonNames.add(commonName);
                ++i;
            }
            try {
                Integer.parseInt(this.xOffInput.getText());
            }
            catch (NumberFormatException xNAN) {
                this.xOffInput.setText("0");
            }
            try {
                Integer.parseInt(this.yOffInput.getText());
            }
            catch (NumberFormatException yNAN) {
                this.yOffInput.setText("0");
            }
            se.append(this.activateCommand.getText()).append(this.activateModifiers.getValueString()).append(this.activateKeyInput.getText()).append(this.upCommand.getText()).append(this.upModifiers.getValueString()).append(this.upKeyInput.getText()).append(this.downCommand.getText()).append(this.downModifiers.getValueString()).append(this.downKeyInput.getText()).append(this.resetCommand.getText()).append((KeyStroke)this.resetKey.getValue()).append(this.resetLevel.getText()).append(this.drawUnderneath.isSelected()).append(this.xOffInput.getText()).append(this.yOffInput.getText()).append(imageNames.toArray(new String[0])).append(commonNames.toArray(new String[0])).append(this.loop.isSelected()).append(this.name.getText()).append((KeyStroke)this.rndKeyConfig.getValue()).append(this.rndCommand.getText() == null ? "" : this.rndCommand.getText().trim()).append(this.followConfig.getValueString()).append(this.propertyConfig.getValueString()).append(this.firstLevelConfig.getValueString());
            return Embellishment0.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        public void reset(Embellishment0 e) {
            this.name.setText(e.name);
            this.names = new ArrayList<String>();
            this.isPrefix = new ArrayList<Integer>();
            for (int i = 0; i < e.commonName.length; ++i) {
                String s = e.commonName[i];
                Integer is = NEITHER;
                if (s != null && s.length() > 0) {
                    SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '+');
                    String first = st.nextToken();
                    if (st.hasMoreTokens()) {
                        String second = st.nextToken();
                        if (first.length() == 0) {
                            s = second;
                            is = SUFFIX;
                        } else {
                            s = first;
                            is = PREFIX;
                        }
                    } else {
                        s = first;
                    }
                }
                this.names.add(s);
                this.isPrefix.add(is);
            }
            this.alwaysActive.setSelected(e.activateKey.length() == 0);
            this.drawUnderneath.setSelected(e.drawUnderneathWhenSelected);
            this.loop.setSelected(e.loopLevels);
            this.images.clear();
            this.activateKeyInput.setText(e.activateKey);
            this.activateCommand.setText(e.activateCommand);
            this.activateModifiers.setValue(e.activateModifiers);
            this.upKeyInput.setText(e.upKey);
            this.upCommand.setText(e.upCommand);
            this.upModifiers.setValue(e.upModifiers);
            this.downKeyInput.setText(e.downKey);
            this.downCommand.setText(e.downCommand);
            this.downModifiers.setValue(e.downModifiers);
            this.resetKey.setValue(e.resetKey);
            this.resetCommand.setText(e.resetCommand);
            this.resetLevel.setText(e.resetLevel.getFormat());
            this.xOffInput.setText(String.valueOf(e.xOff));
            this.yOffInput.setText(String.valueOf(e.yOff));
            this.images.setImageList(e.imageName);
            this.followConfig.setValue(e.followProperty);
            this.propertyConfig.setValue(e.propertyName);
            if (this.images.getImageNameList().isEmpty()) {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            }
            this.updateLevelName();
            this.showHideFields();
        }
    }
}

