/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.Auditable;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class RestrictCommands
extends Decorator
implements EditablePiece {
    public static final String ID = "hideCmd;";
    protected static final String HIDE = "Hide";
    protected static final String DISABLE = "Disable";
    protected static final String[] restrictionKeys = new String[]{"Editor.RestrictCommands.hide", "Editor.RestrictCommands.disable"};
    protected String name = "";
    protected PropertyExpression propertyMatch = new PropertyExpression();
    protected String action = "Hide";
    protected NamedKeyStroke[] watchKeys = new NamedKeyStroke[0];

    public RestrictCommands() {
        this(ID, null);
    }

    public RestrictCommands(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return KeyCommand.NONE;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.name).append(this.action).append(this.propertyMatch.getExpression()).append(NamedKeyStrokeArrayConfigurer.encode(this.watchKeys));
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        for (NamedKeyStroke watchKey : this.watchKeys) {
            if (!watchKey.equals(stroke)) continue;
            if (!this.matchesFilter()) break;
            return null;
        }
        return super.keyEvent(stroke);
    }

    @Override
    protected KeyCommand[] getKeyCommands() {
        KeyCommand[] commands = super.getKeyCommands();
        ArrayList<KeyCommand> newCommands = new ArrayList<KeyCommand>(commands.length);
        if (this.matchesFilter()) {
            for (KeyCommand command : commands) {
                boolean matches = false;
                for (int j = 0; j < this.watchKeys.length && !matches; ++j) {
                    matches = this.watchKeys[j].equals(command.getKeyStroke());
                }
                if (matches) {
                    if (!this.action.equals(DISABLE)) continue;
                    KeyCommand newCommand = new KeyCommand(command);
                    newCommand.setEnabled(false);
                    newCommands.add(newCommand);
                    continue;
                }
                newCommands.add(command);
            }
            commands = newCommands.toArray(new KeyCommand[0]);
        }
        return commands;
    }

    protected boolean matchesFilter() {
        return this.propertyMatch.isNull() || this.propertyMatch.accept(RestrictCommands.getOutermost(this), (Auditable)this, "Editor.RestrictCommands.restrict_when_properties_match");
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        Object s = this.buildDescription("Editor.RestrictCommands.trait_description", this.name);
        for (NamedKeyStroke key : this.watchKeys) {
            s = (String)s + this.getCommandDesc("", key);
        }
        return s;
    }

    @Override
    public String getBaseDescription() {
        return Resources.getString("Editor.RestrictCommands.trait_description");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RestrictCommands.html");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.name = st.nextToken("");
        this.action = st.nextToken(HIDE);
        this.propertyMatch.setExpression(st.nextToken(""));
        String keys = st.nextToken("");
        if (keys.indexOf(44) > 0) {
            this.watchKeys = NamedKeyStrokeArrayConfigurer.decode(keys);
        } else {
            this.watchKeys = new NamedKeyStroke[keys.length()];
            for (int i = 0; i < this.watchKeys.length; ++i) {
                this.watchKeys[i] = NamedKeyStroke.of(keys.charAt(i), 128);
            }
        }
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof RestrictCommands)) {
            return false;
        }
        RestrictCommands c = (RestrictCommands)o;
        if (!Objects.equals(this.name, c.name)) {
            return false;
        }
        if (!Objects.equals(this.action, c.action)) {
            return false;
        }
        if (!Objects.equals(this.propertyMatch, c.propertyMatch)) {
            return false;
        }
        return Objects.equals(NamedKeyStrokeArrayConfigurer.encode(this.watchKeys), NamedKeyStrokeArrayConfigurer.encode(c.watchKeys));
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.propertyMatch.getExpression());
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
        Collections.addAll(l, this.watchKeys);
        return l;
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer name;
        protected PropertyExpressionConfigurer propertyMatch;
        protected NamedKeyStrokeArrayConfigurer watchKeys;
        protected TranslatingStringEnumConfigurer actionOption;
        protected TraitConfigPanel box = new TraitConfigPanel();

        public Ed(RestrictCommands piece) {
            this.name = new StringConfigurer(piece.name);
            this.name.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.name);
            this.actionOption = new TranslatingStringEnumConfigurer(new String[]{RestrictCommands.HIDE, RestrictCommands.DISABLE}, restrictionKeys, piece.action);
            this.box.add("Editor.RestrictCommands.restriction", (Configurer)this.actionOption);
            this.propertyMatch = new PropertyExpressionConfigurer(piece.propertyMatch, (GamePiece)piece);
            this.box.add("Editor.RestrictCommands.restrict_when_properties_match", (Configurer)this.propertyMatch);
            this.watchKeys = new NamedKeyStrokeArrayConfigurer(piece.watchKeys);
            this.box.add("Editor.RestrictCommands.restrict_these_key_commands", (Configurer)this.watchKeys);
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.name.getValueString()).append(this.actionOption.getValueString()).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString());
            return RestrictCommands.ID + se.getValue();
        }
    }
}

