/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.CustomVmOptions;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.TilingHandler;
import VASSAL.launch.UseTracker;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.ReadOnlyPrefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.concurrent.FutureUtils;
import VASSAL.tools.deprecation.RemovalAndDeprecationChecker;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ModuleFileFilter;
import VASSAL.tools.io.ProcessLauncher;
import VASSAL.tools.io.ProcessWrapper;
import VASSAL.tools.lang.MemoryUtils;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLaunchAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractLaunchAction.class);
    protected static final int PHYS_MEMORY;
    public static final int DEFAULT_MAXIMUM_HEAP = 1024;
    protected static final int FAILSAFE_MAXIMUM_HEAP = 128;
    protected final Window window;
    protected final String entryPoint;
    protected final LaunchRequest lr;
    private static final UseTracker useTracker;

    public static UseTracker getUseTracker() {
        return useTracker;
    }

    public AbstractLaunchAction(String name, Window window, String entryPoint, LaunchRequest lr) {
        super(name);
        this.window = window;
        this.entryPoint = entryPoint;
        this.lr = lr;
    }

    public static boolean anyInUse() {
        return useTracker.anyInUse();
    }

    public static boolean isInUse(File file) {
        return useTracker.isInUse(file);
    }

    public static boolean isEditing(File file) {
        return useTracker.isEditing(file);
    }

    protected static void incrementUsed(File file) {
        useTracker.incrementUsed(file);
    }

    protected static void decrementUsed(File file) {
        useTracker.decrementUsed(file);
    }

    protected static void markEditing(File file) {
        useTracker.markEditing(file);
    }

    protected static void unmarkEditing(File file) {
        useTracker.unmarkEditing(file);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ModuleManagerWindow.getInstance().setWaitCursor(true);
        this.getLaunchTask().execute();
    }

    protected abstract LaunchTask getLaunchTask();

    protected File promptForFile() {
        FileChooser fc = FileChooser.createFileChooser(this.window, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        this.addFileFilters(fc);
        if (fc.showOpenDialog() == 0) {
            this.lr.module = fc.getSelectedFile();
            if (this.lr.module != null) {
                if (this.lr.module.exists()) {
                    AbstractMetaData metadata = MetaDataFactory.buildMetaData(this.lr.module);
                    if (!(metadata instanceof ModuleMetaData)) {
                        ErrorDialog.show("Error.invalid_vassal_module", this.lr.module.getAbsolutePath());
                        logger.error("-- Load of {} failed: Not a Vassal module", (Object)this.lr.module.getAbsolutePath());
                        this.lr.module = null;
                    }
                } else {
                    this.lr.module = null;
                }
            }
        }
        return this.lr.module;
    }

    protected void addFileFilters(FileChooser fc) {
        fc.addChoosableFileFilter(new ModuleFileFilter());
    }

    protected boolean checkRemovedAndDeprecated(File f) throws IOException {
        Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> rd;
        RemovalAndDeprecationChecker rdc = new RemovalAndDeprecationChecker();
        try (ZipFile zf = new ZipFile(f.getAbsolutePath());){
            rd = rdc.check(zf);
        }
        Map removed = (Map)rd.getLeft();
        if (!removed.isEmpty()) {
            String msg = "Removed classes, methods, and fields in " + f.toString() + "\n(used by => removed item, version when removed\n" + RemovalAndDeprecationChecker.formatResult(removed);
            logger.error(msg);
            FutureUtils.wait(ProblemDialog.showDetails(0, msg, "Dialogs.removed_code", new Object[0]));
            return false;
        }
        Map deprecated = (Map)rd.getRight();
        if (!deprecated.isEmpty()) {
            boolean showDialog = this.lr.mode == LaunchRequest.Mode.EDIT || this.lr.mode == LaunchRequest.Mode.EDIT_EXT;
            LocalDate sixMonthsFromNow = LocalDate.now().plusMonths(6L);
            DateTimeFormatter fmt = DateTimeFormatter.ISO_LOCAL_DATE;
            for (Map.Entry e1 : deprecated.entrySet()) {
                for (Map.Entry entry : ((Map)e1.getValue()).entrySet()) {
                    LocalDate removalDate = LocalDate.parse((CharSequence)entry.getValue(), fmt).plusYears(1L);
                    if (removalDate.isBefore(sixMonthsFromNow)) {
                        showDialog = true;
                    }
                    entry.setValue(removalDate.toString());
                }
            }
            String msg = "Deprecated classes, methods, and fields in " + f.toString() + "\n(used by => removed item, date eligible for removal)\n" + RemovalAndDeprecationChecker.formatResult(deprecated);
            logger.warn(msg);
            if (showDialog) {
                FutureUtils.wait(ProblemDialog.showDetails(2, msg, "Dialogs.deprecated_code", new Object[0]));
            }
        }
        return true;
    }

    static {
        long physMemoryBytes = MemoryUtils.getPhysicalMemory();
        PHYS_MEMORY = physMemoryBytes <= 0L ? 4096 : (int)(physMemoryBytes >> 20);
        useTracker = new UseTracker();
    }

    protected class LaunchTask
    extends SwingWorker<Void, Void> {
        protected final LaunchRequest lr;

        protected LaunchTask() {
            this.lr = new LaunchRequest(AbstractLaunchAction.this.lr);
        }

        @Override
        public Void doInBackground() throws InterruptedException, IOException {
            if (this.lr.module != null) {
                logger.info("Loading module file {}", (Object)this.lr.module.getAbsolutePath());
                if (!AbstractLaunchAction.this.checkRemovedAndDeprecated(this.lr.module)) {
                    return null;
                }
                ExtensionsManager mgr = new ExtensionsManager(this.lr.module);
                for (File ext : mgr.getActiveExtensions()) {
                    if (AbstractLaunchAction.this.checkRemovedAndDeprecated(ext)) continue;
                    return null;
                }
                int max_tiler_heap = this.getHeapSize(Prefs.getGlobalPrefs(), "tilerMaximumHeap", 3 * PHYS_MEMORY / 4);
                String aname = this.lr.module.getAbsolutePath();
                ModuleMetaData meta = new ModuleMetaData(new ZipFile(aname));
                String hstr = DigestUtils.sha1Hex((String)(meta.getName() + "_" + meta.getVersion()));
                File cdir = new File(Info.getCacheDir(), "tiles/" + hstr);
                TilingHandler th = new TilingHandler(aname, cdir, new Dimension(256, 256), max_tiler_heap);
                try {
                    th.sliceTiles();
                }
                catch (CancellationException e) {
                    this.cancel(true);
                    return null;
                }
                for (File ext : mgr.getActiveExtensions()) {
                    TilingHandler eth = new TilingHandler(ext.getAbsolutePath(), cdir, new Dimension(256, 256), max_tiler_heap);
                    try {
                        eth.sliceTiles();
                    }
                    catch (CancellationException e) {
                        this.cancel(true);
                        return null;
                    }
                }
            }
            if (this.lr.game != null) {
                logger.info("Loading game file {}", (Object)this.lr.game.getAbsolutePath());
            }
            if (this.lr.importFile != null) {
                logger.info("Importing module file {}", (Object)this.lr.importFile.getAbsolutePath());
            }
            int maximumHeap = 1024;
            String moduleName = null;
            if (this.lr.module != null) {
                AbstractMetaData data = MetaDataFactory.buildMetaData(this.lr.module);
                if (data == null) {
                    ErrorDialog.show("Error.invalid_vassal_file", this.lr.module.getAbsolutePath());
                    return null;
                }
                if (data instanceof ModuleMetaData) {
                    moduleName = ((ModuleMetaData)data).getName();
                    logger.info("Loading module {}", (Object)moduleName);
                    ReadOnlyPrefs p = new ReadOnlyPrefs(moduleName);
                    maximumHeap = this.getHeapSize(p, "maximumHeap", 1024);
                    logger.info("JVM maximum heap size: {} MB", (Object)maximumHeap);
                }
            } else if (this.lr.importFile != null) {
                Prefs p = Prefs.getGlobalPrefs();
                maximumHeap = this.getHeapSize(p, "converterMaximumHeap", 1024);
            }
            if (maximumHeap > PHYS_MEMORY) {
                maximumHeap = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            } else if (maximumHeap < 128) {
                maximumHeap = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_small", 128));
            }
            int initialHeap = maximumHeap;
            List<String> argumentList = this.buildArgumentList(moduleName);
            String[] args = argumentList.toArray(new String[0]);
            args[1] = "-Xms" + initialHeap + "M";
            args[2] = "-Xmx" + maximumHeap + "M";
            ProcessWrapper proc = new ProcessLauncher().launch(args);
            try {
                proc.future.get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException e) {
                this.cancel(true);
                return null;
            }
            catch (ExecutionException e) {
                logger.error("", (Throwable)e);
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            if (proc.future.isDone()) {
                args[1] = "-Xms128M";
                args[2] = "-Xmx128M";
                proc = new ProcessLauncher().launch(args);
                try {
                    proc.future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    logger.error("", (Throwable)e);
                }
                catch (TimeoutException e) {
                    // empty catch block
                }
                if (proc.future.isDone()) {
                    throw new IOException("failed to start child process");
                }
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            }
            ModuleManagerWindow mmw = ModuleManagerWindow.getInstance();
            if (this.lr.module != null) {
                mmw.addModule(this.lr.module);
            }
            mmw.setWaitCursor(false);
            try {
                proc.future.get();
            }
            catch (ExecutionException e) {
                logger.error("", (Throwable)e);
            }
            return null;
        }

        private int strToInt(Object val, int defaultVal) {
            if (val == null) {
                return defaultVal;
            }
            try {
                return Integer.parseInt(val.toString());
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }

        protected int getHeapSize(ReadOnlyPrefs p, String key, int defaultHeap) {
            return this.strToInt(p.getStoredValue(key), defaultHeap);
        }

        protected int getHeapSize(Prefs p, String key, int defaultHeap) {
            return this.strToInt(p.getValue(key), defaultHeap);
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException e) {
                String msg;
                if (SystemUtils.IS_OS_WINDOWS && ThrowableUtils.getAncestor(IOException.class, e) != null && (msg = e.getMessage()).contains("jre\\bin\\java") && msg.contains("CreateProcess")) {
                    ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.possible_windows_av_interference", msg);
                    return;
                }
                ErrorDialog.bug(e);
            }
            catch (InterruptedException e) {
                ErrorDialog.bug(e);
            }
            finally {
                ModuleManagerWindow.getInstance().setWaitCursor(false);
            }
        }

        private List<String> buildArgumentList(String moduleName) {
            Boolean disableD3d;
            String vConf;
            String userDir;
            ArrayList<String> result = new ArrayList<String>();
            result.add(Info.getJavaBinPath().getAbsolutePath());
            result.add("");
            result.add("");
            result.addAll(new CustomVmOptions().getCustomVmOptions());
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                result.add("-Duser.home=" + userHome);
            }
            if ((userDir = System.getProperty("user.dir")) != null) {
                result.add("-Duser.dir=" + userDir);
            }
            if ((vConf = System.getProperty("VASSAL.conf")) != null) {
                result.add("-DVASSAL.conf=" + vConf);
            }
            result.add("-cp");
            result.add(System.getProperty("java.class.path"));
            if (SystemUtils.IS_OS_MAC) {
                String d_name = moduleName != null && moduleName.length() > 0 ? moduleName : Resources.getString("Editor.AbstractLaunchAction.unnamed_module");
                String d_icon = new File(Info.getBaseDir(), "Contents/Resources/VASSAL.icns").getAbsolutePath();
                result.add("-Xdock:name=" + d_name);
                result.add("-Xdock:icon=" + d_icon);
                Boolean disableOGLFBO = (Boolean)Prefs.getGlobalPrefs().getValue("disableOGLFBO");
                if (Boolean.TRUE.equals(disableOGLFBO)) {
                    result.add("-Dsun.java2d.opengl=true");
                    result.add("-Dsun.java2d.opengl.fbobject=false");
                }
            } else if (SystemUtils.IS_OS_WINDOWS && Boolean.TRUE.equals(disableD3d = (Boolean)Prefs.getGlobalPrefs().getValue("disableD3d"))) {
                result.add("-Dsun.java2d.d3d=false");
            }
            result.add(AbstractLaunchAction.this.entryPoint);
            result.addAll(Arrays.asList(this.lr.toArgs()));
            return result;
        }
    }
}

