/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class ColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final Font FONT = new Font("Dialog", 0, 10);
    private Color color;

    public ColorButton() {
        this((Color)null);
    }

    public ColorButton(Color c) {
        this.color = c;
        this.setIcon(new SwatchIcon(30, 15));
        this.setMargin(new Insets(2, 2, 2, 2));
    }

    public void setColor(Color c) {
        this.color = c;
    }

    private class SwatchIcon
    implements Icon {
        private final int swatchWidth;
        private final int swatchHeight;

        public SwatchIcon(int width, int height) {
            this.swatchWidth = width;
            this.swatchHeight = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            AffineTransform orig_t = g2d.getTransform();
            g2d.setTransform(SwingUtils.descaleTransform(orig_t));
            x = (int)((double)x * os_scale);
            y = (int)((double)y * os_scale);
            int w = (int)((double)this.swatchWidth * os_scale);
            int h = (int)((double)this.swatchHeight * os_scale);
            g.setColor(Color.black);
            g.drawRect(x, y, w - 1, h - 1);
            if (ColorButton.this.color != null) {
                g.setColor(ColorButton.this.color);
                g.fillRect(x + 1, y + 1, w - 2, h - 2);
            } else {
                g2d.addRenderingHints(SwingUtils.FONT_HINTS);
                g.setColor(UIManager.getColor("controlText"));
                Font font = FONT.deriveFont((float)((double)FONT.getSize() * os_scale));
                g.setFont(font);
                g.drawString("nil", x + (w - g.getFontMetrics(font).stringWidth("nil")) / 2, y + (h + g.getFontMetrics(font).getAscent()) / 2);
            }
            g2d.setTransform(orig_t);
        }

        @Override
        public int getIconWidth() {
            return this.swatchWidth;
        }

        @Override
        public int getIconHeight() {
            return this.swatchHeight;
        }
    }
}

