/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class WrapLayout
extends FlowLayout {
    private static final long serialVersionUID = 1L;
    boolean recursing = false;

    public WrapLayout() {
        super(0);
    }

    public WrapLayout(int align) {
        super(align);
    }

    public WrapLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.layoutSize(target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container target, boolean preferred) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension targetSize = target.getSize();
            int targetWidth = 0;
            targetWidth = targetSize.width == 0 ? Integer.MAX_VALUE : targetSize.width;
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int maxWidth = targetWidth - (insets.left + insets.right + hgap * 2);
            Dimension dim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Dimension d;
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                if (rowWidth + d.width > maxWidth) {
                    this.addRow(dim, rowWidth, rowHeight);
                    rowWidth = 0;
                    rowHeight = 0;
                }
                if (rowWidth > 0) {
                    rowWidth += this.getHgap();
                }
                rowWidth += d.width;
                rowHeight = Math.max(rowHeight, d.height);
            }
            this.addRow(dim, rowWidth, rowHeight);
            dim.width += insets.left + insets.right + hgap * 2;
            dim.height += insets.top + insets.bottom + vgap * 2;
            return dim;
        }
    }

    private void addRow(Dimension dim, int rowWidth, int rowHeight) {
        dim.width = Math.max(dim.width, rowWidth);
        if (dim.height > 0) {
            dim.height += this.getVgap();
        }
        dim.height += rowHeight;
    }

    @Override
    public void layoutContainer(Container target) {
        super.layoutContainer(target);
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component cmp = target.getComponent(i);
            if (!cmp.isVisible()) continue;
            Rectangle b = cmp.getBounds();
            if (b.x + b.width > maxX) {
                maxX = b.x + b.width;
            }
            if (b.y + b.height <= maxY) continue;
            maxY = b.y + b.height;
        }
        Dimension size = target.getSize();
        if (maxX > size.width || maxY > size.height) {
            if (this.recursing) {
                return;
            }
            this.recursing = true;
            target.invalidate();
            if (target instanceof JComponent) {
                target.revalidate();
            }
            this.recursing = false;
        }
    }
}

