/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ThrowableUtils;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;

public class WriteErrorDialog {
    private WriteErrorDialog() {
    }

    public static void error(Throwable t, IOException e, String filename) {
        ErrorDialog.showDetails(t, ThrowableUtils.getStackTrace(e), "Error.file_write_error", filename);
    }

    public static void error(Throwable t, IOException e, File file) {
        WriteErrorDialog.error(t, e, file.getPath());
    }

    public static void error(IOException e, String filename) {
        WriteErrorDialog.error((Throwable)e, e, filename);
    }

    public static void error(IOException e, File file) {
        WriteErrorDialog.error((Throwable)e, e, file.getPath());
    }

    public static void reportFileOverwriteFailure(FileSystemException e, String messageKey) {
        ErrorDialog.showFileOverwriteFailure(e, ThrowableUtils.getStackTrace(e), messageKey, new Object[0]);
    }

    public static void showError(Component parent, IOException e, File file, String messageKey) {
        String msg = e instanceof AccessDeniedException ? "Access denied" : (e instanceof FileSystemException ? ((FileSystemException)e).getReason() : e.getMessage());
        ProblemDialog.showDetails(2, parent, (Throwable)e, ThrowableUtils.getStackTrace(e), Resources.getString(messageKey + "_title"), Resources.getString(messageKey + "_heading"), Resources.getString(messageKey + "_message", file.getName(), msg));
    }
}

