/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent;

import VASSAL.tools.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleFuture<V>
implements SettableFuture<V> {
    protected V result = null;
    protected Throwable exception = null;
    protected volatile boolean cancelled = false;
    protected final CountDownLatch done = new CountDownLatch(1);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled) {
            return false;
        }
        if (this.done.getCount() != 0L) {
            this.cancelled = true;
            this.done.countDown();
        }
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.done.getCount() == 0L;
    }

    @Override
    public void setException(Throwable t) {
        this.exception = t;
        this.done.countDown();
    }

    @Override
    public void set(V r) {
        this.result = r;
        this.done.countDown();
    }

    @Override
    public V get() throws CancellationException, ExecutionException, InterruptedException {
        this.done.await();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.result;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (!this.done.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.result;
    }
}

