/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class CompositeInputStream
extends InputStream {
    protected final Queue<InputStream> queue;
    protected InputStream in;

    public CompositeInputStream(List<InputStream> streams) {
        this.queue = new LinkedList<InputStream>(streams);
        this.in = this.queue.poll();
    }

    public CompositeInputStream(InputStream ... streams) {
        this(Arrays.asList(streams));
    }

    protected void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = this.queue.poll();
        }
    }

    @Override
    public int available() throws IOException {
        int bytes = this.in != null ? this.in.available() : 0;
        for (InputStream ch : this.queue) {
            bytes += Math.max(ch.available(), 0);
        }
        return bytes;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int c = this.in.read();
        if (c != -1) {
            return c;
        }
        this.nextStream();
        return this.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        int count = this.in.read(b, off, len);
        if (count > 0) {
            return count;
        }
        this.nextStream();
        return this.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        while (this.in != null) {
            this.nextStream();
        }
    }
}

