/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.UserDialogAWT;

public class UserDialogPrivMsgAWT
extends Frame {
    private static final long serialVersionUID = 1L;
    private UserDialogAWT zUserDialog;
    private MyInfo zMyInfo;
    private ActivePeer zPeerListener;
    private TextField zChatText;
    private TextArea zMessagesTextArea;

    public UserDialogPrivMsgAWT(UserDialogAWT pUserDialog, MyInfo pMyInfo, ActivePeer pPeerListener) {
        super("P2P Chat Private Messaging with " + pPeerListener.getPeerInfo().toString());
        this.zUserDialog = pUserDialog;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zMyInfo = pMyInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        this.zPeerListener = pPeerListener;
        IllegalArgument.ifNull("PeerListener", this.zPeerListener);
        this.setLayout(new BorderLayout());
        this.add("Center", this.layoutReceivedMessagesPanel());
        this.add("South", this.layoutChatEntryPanel());
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UserDialogPrivMsgAWT.this.zUserDialog.unregisterPrivateMessager(UserDialogPrivMsgAWT.this.zPeerListener.getPeerInfo());
                UserDialogPrivMsgAWT.this.dispose();
            }
        });
        this.setVisible(true);
    }

    private Panel layoutChatEntryPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("West", new Label("Message to Send:"));
        this.zChatText = new TextField();
        panel.add("Center", this.zChatText);
        this.zChatText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pLine = e.getActionCommand();
                UserDialogPrivMsgAWT.this.zChatText.setText("");
                UserDialogPrivMsgAWT.this.zPeerListener.sendPMSG(pLine);
                UserDialogPrivMsgAWT.this.send(UserDialogPrivMsgAWT.this.zMyInfo.getChatName() + ": " + pLine);
            }
        });
        return panel;
    }

    private Panel layoutReceivedMessagesPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new Label("Received Messages:"));
        this.zMessagesTextArea = new TextArea();
        panel.add("Center", this.zMessagesTextArea);
        this.zMessagesTextArea.setEnabled(true);
        this.zMessagesTextArea.setEditable(false);
        return panel;
    }

    public void send(String pMessage) {
        IllegalArgument.ifNull("Message", pMessage);
        Object current = this.zMessagesTextArea.getText();
        current = (String)current + pMessage + "\n";
        this.zMessagesTextArea.setText((String)current);
    }
}

